/** 
 * THIS FILE HAS BEEN GENERATED, PLEASE DO NOT EDIT!
 */
package org.molgenis.data.jpa;

import java.util.Iterator;
import java.util.Map;

import javax.annotation.PostConstruct;

import org.molgenis.data.EntityMetaData;
import org.molgenis.data.Repository;
import org.molgenis.data.RepositoryCollection;
import org.molgenis.data.elasticsearch.IndexedRepositoryCollectionDecorator;
import org.molgenis.data.elasticsearch.SearchService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

import com.google.common.collect.Maps;

@Component("JpaRepositoryCollection")
public class JpaRepositoryCollection extends IndexedRepositoryCollectionDecorator
{
	public static final String NAME = "JPA";
	private final Map<String, Repository> repositories = Maps.newLinkedHashMap();

	@Autowired
	public JpaRepositoryCollection(SearchService searchService)
	{
		super(searchService);
	}

	@PostConstruct
	public void init()
	{
		setDelegate(new RepositoryCollection()
		{
			@Override
			public Iterator<Repository> iterator()
			{
				return repositories.values().iterator();
			}

			@Override
			public String getName()
			{
				return NAME;
			}

			@Override
			public Repository addEntityMeta(EntityMetaData entityMeta)
			{
				return getRepository(entityMeta.getName());
			}

			@Override
			public Iterable<String> getEntityNames()
			{
				return repositories.keySet();
			}

			@Override
			public Repository getRepository(String name)
			{
				return repositories.get(name);
			}

			@Override
			public boolean hasRepository(String name)
			{
				return repositories.containsKey(name);
			}
		});
	}


	@Autowired
	@Qualifier("MolgenisUserRepository")
	public void setMolgenisUserRepository(Repository molgenisUserRepository)
	{	
		repositories.put("MolgenisUser", new org.molgenis.security.user.MolgenisUserDecorator(molgenisUserRepository));	
	}
	@Autowired
	@Qualifier("MolgenisGroupRepository")
	public void setMolgenisGroupRepository(Repository molgenisGroupRepository)
	{	
		repositories.put("MolgenisGroup", molgenisGroupRepository);	
	}
	@Autowired
	@Qualifier("MolgenisGroupMemberRepository")
	public void setMolgenisGroupMemberRepository(Repository molgenisGroupMemberRepository)
	{	
		repositories.put("MolgenisGroupMember", molgenisGroupMemberRepository);	
	}
	@Autowired
	@Qualifier("UserAuthorityRepository")
	public void setUserAuthorityRepository(Repository userAuthorityRepository)
	{	
		repositories.put("UserAuthority", userAuthorityRepository);	
	}
	@Autowired
	@Qualifier("GroupAuthorityRepository")
	public void setGroupAuthorityRepository(Repository groupAuthorityRepository)
	{	
		repositories.put("GroupAuthority", groupAuthorityRepository);	
	}
	@Autowired
	@Qualifier("RuntimePropertyRepository")
	public void setRuntimePropertyRepository(Repository runtimePropertyRepository)
	{	
		repositories.put("RuntimeProperty", runtimePropertyRepository);	
	}
	@Autowired
	@Qualifier("FreemarkerTemplateRepository")
	public void setFreemarkerTemplateRepository(Repository freemarkerTemplateRepository)
	{	
		repositories.put("FreemarkerTemplate", freemarkerTemplateRepository);	
	}
	@Autowired
	@Qualifier("MolgenisTokenRepository")
	public void setMolgenisTokenRepository(Repository molgenisTokenRepository)
	{	
		repositories.put("MolgenisToken", molgenisTokenRepository);	
	}
	@Autowired
	@Qualifier("ImportRunRepository")
	public void setImportRunRepository(Repository importRunRepository)
	{	
		repositories.put("ImportRun", importRunRepository);	
	}
}
