/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.tools.compare;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.molgenis.data.Entity;
import org.molgenis.data.MolgenisInvalidFormatException;
import org.molgenis.data.Repository;
import org.molgenis.data.csv.CsvRepository;
import org.molgenis.data.excel.ExcelRepositoryCollection;
import org.molgenis.data.processor.CellProcessor;
import org.molgenis.data.processor.TrimProcessor;
import org.molgenis.tools.compare.ValidationFile;

/*
 * Exception performing whole class analysis ignored.
 */
public class Validator {
    private static final String IDENTIFIER = "id_sample";
    private static final String IDENTIFIER2 = "id_individual";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void check(String excelFile1, String file2, BufferedWriter logger) throws IOException, MolgenisInvalidFormatException {
        ValidationFile excelfile = new ValidationFile();
        ExcelRepositoryCollection excelReaderReferenceFile = new ExcelRepositoryCollection(new File(excelFile1), new CellProcessor[]{new TrimProcessor()});
        try (Repository excelSheetReaderReferenceFile = excelReaderReferenceFile.getRepository("dataset_celiac_sprue");){
            excelfile.readFile(excelSheetReaderReferenceFile, "id_sample", "id_individual");
        }
        ValidationFile csvFile = new ValidationFile();
        CsvRepository csvReaderFileToCompare = new CsvRepository(new File(file2), "", null);
        csvFile.readFile((Repository)csvReaderFileToCompare, "id_sample", "id_individual");
        boolean noUniqueColums = false;
        ArrayList<String> listOfSharedHeaders = new ArrayList<String>();
        System.out.println("-----------------------------------------------------------------------------------");
        System.out.println("### Unique columns");
        for (String string : excelfile.getListOfHeaders()) {
            listOfSharedHeaders.add(string);
            if (csvFile.getListOfHeaders().contains(string)) continue;
            listOfSharedHeaders.remove(string);
            System.out.println("In file1: " + string);
            noUniqueColums = true;
        }
        for (String string : csvFile.getListOfHeaders()) {
            if (excelfile.getListOfHeaders().contains(string)) continue;
            System.out.println("In file2: " + string);
            noUniqueColums = true;
        }
        if (!noUniqueColums) {
            System.out.println("###There are no added/deleted columns\n");
        }
        System.out.println("-----------------------------------------------------------------------------------");
        System.out.println("\n###Comparing the values ");
        System.out.println("Sample ID\tFeature\tFile1\tFile2");
        try {
            for (Map.Entry entry : excelfile.getHash().entrySet()) {
                Validator.compareRows((String)"excel", (String)"csvFile", (Entity)((Entity)entry.getValue()), (Entity)((Entity)csvFile.getHash().get(((Entity)entry.getValue()).getString("id_sample") + "_" + ((Entity)entry.getValue()).getString("id_individual"))), listOfSharedHeaders, (BufferedWriter)logger);
            }
            for (Map.Entry entry : csvFile.getHash().entrySet()) {
                Validator.compareRows((String)"csvFile", (String)"excel", (Entity)((Entity)entry.getValue()), (Entity)((Entity)excelfile.getHash().get(((Entity)entry.getValue()).getString("id_sample") + "_" + ((Entity)entry.getValue()).getString("id_individual"))), listOfSharedHeaders, (BufferedWriter)logger);
            }
            System.out.println("-----------------------------------------------------------------------------------");
            System.out.println("\n###Unique samples in file1");
            if (excelfile.getHash().size() == 0) {
                System.out.println("There are no unique samples in file1");
            }
            for (Map.Entry entry : excelfile.getHash().entrySet()) {
                if (csvFile.getHash().containsKey(entry.getKey())) continue;
                System.out.println((String)entry.getKey());
            }
            System.out.println("-----------------------------------------------------------------------------------");
            System.out.println("\n###Unique samples in file2 ");
            if (csvFile.getHash().size() == 0) {
                System.out.println("There are no unique samples in file2");
            }
            for (Map.Entry entry : csvFile.getHash().entrySet()) {
                if (excelfile.getHash().containsKey(entry.getKey())) continue;
                System.out.println((String)entry.getKey());
            }
        }
        finally {
            IOUtils.closeQuietly((Closeable)csvReaderFileToCompare);
        }
    }

    public static void compareRows(String fileName1, String fileName2, Entity firstEntity, Entity secondEntity, List<String> listOfHeaders, BufferedWriter logger) throws IOException {
        for (String e : listOfHeaders) {
            if (firstEntity == null || secondEntity == null) {
                System.out.println("NULLLLL");
            }
            if (firstEntity.getString(e) == null && secondEntity.getString(e) == null) continue;
            if (firstEntity.getString(e) != null && secondEntity.getString(e) == null) {
                System.out.println(fileName1 + " ### " + firstEntity.getString("id_sample") + "\t" + e + "\tREMOVED IN:" + fileName2 + "\t" + firstEntity.getString(e));
                continue;
            }
            if (firstEntity.getString(e) == null && secondEntity.getString(e) != null) {
                System.out.println(fileName1 + "---" + firstEntity.getString("id_sample") + "\t" + e + "\t\tADDED IN " + fileName2 + "|\t|" + firstEntity.getString(e) + "|");
                continue;
            }
            if (firstEntity.getString(e).equals(secondEntity.getString(e))) continue;
            System.out.println(fileName1 + "-" + firstEntity.getString("id_sample") + "\t" + e + "\t" + secondEntity.getString(e) + "|\t|" + firstEntity.getString(e) + "|");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws FileNotFoundException, MolgenisInvalidFormatException {
        if (args.length != 3) {
            System.err.println("To run this script it needs 3 arguments; \n1) An excelfile\n2) a csvfile\n3) a path for the logfile\ne.g.\nargs[0] /Users/Roan/Work/GIDS_8_may/Cohorts/Bloodbank/Export_Gids1_Bloodbank.xls\nargs[1] /Users/Roan/Work/GIDS_8_may/Cohorts/Bloodbank/Export_Gids2_Bloodbank_dataset125_2013-05-08.csv/\nargs[2] /Users/Roan/logger.txt");
            return;
        }
        Validator vc = new Validator();
        BufferedWriter logger = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(args[2]), Charset.forName("UTF-8")));
        try {
            logger.write("file1: " + args[0] + "\nfile2: " + args[1]);
            vc.check(args[0], args[1], logger);
            logger.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            IOUtils.closeQuietly((Writer)logger);
        }
    }
}

