/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.tools.compare;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.molgenis.data.Entity;
import org.molgenis.data.MolgenisInvalidFormatException;
import org.molgenis.data.Repository;
import org.molgenis.data.excel.ExcelRepositoryCollection;
import org.molgenis.data.processor.CellProcessor;
import org.molgenis.data.processor.TrimProcessor;

public class CategoryParser {
    public static void main(String[] args) throws IOException, MolgenisInvalidFormatException {
        if (args.length != 2) {
            System.err.println("2 arguments please 1) filename 2) name of datamatrix tab\nexample:\n/Users/Roan/Work/GIDS_Imported_30_august_2013/Omx_Import_CeliacSprue_metadata.xlsdataset_celiac_sprue");
            return;
        }
        CategoryParser vc = new CategoryParser();
        vc.check(args[0], args[1]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void check(String file, String datasetMatrix) throws IOException, MolgenisInvalidFormatException {
        ExcelRepositoryCollection repositorySource = new ExcelRepositoryCollection(new File(file), new CellProcessor[]{new TrimProcessor()});
        ArrayList<String> listOfCategoricalFeatures = new ArrayList<String>();
        HashMap hashCategories = new HashMap();
        try (Repository repo = repositorySource.getRepository("observablefeature");){
            for (Entity entity : repo) {
                if (!"categorical".equals(entity.getString("datatype"))) continue;
                listOfCategoricalFeatures.add(entity.getString("identifier"));
                hashCategories.put(entity.getString("identifier"), new ArrayList());
            }
        }
        try (Repository readObservableDataMatrixRepo = repositorySource.getRepository(datasetMatrix);){
            for (Entity entity : readObservableDataMatrixRepo) {
                for (String category : listOfCategoricalFeatures) {
                    List getList = (List)hashCategories.get(category);
                    if (((List)hashCategories.get(category)).contains(entity.getString(category))) continue;
                    getList.add(entity.getString(category));
                }
            }
            this.printForCategoryTab(hashCategories);
        }
    }

    public void printAsList(Map<String, List<String>> hashCategories) {
        for (Map.Entry<String, List<String>> entry : hashCategories.entrySet()) {
            System.out.println(entry.getKey() + "-" + entry.getValue());
        }
    }

    public void printForCategoryTab(Map<String, List<String>> hashCategories) {
        System.out.println("identifier\tname\tvalueCode\tobservablefeature_identifier");
        for (Map.Entry<String, List<String>> entry : hashCategories.entrySet()) {
            for (String valueCode : entry.getValue()) {
                if (!StringUtils.isNotBlank((CharSequence)valueCode)) continue;
                String identifierCode = valueCode.replaceAll("\\s", "_");
                System.out.println(entry.getKey() + "_" + identifierCode + "\t" + valueCode + "\t" + valueCode + "\t" + entry.getKey());
            }
        }
    }
}

