/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.gaf;

import java.io.IOException;
import java.util.ArrayList;
import javax.mail.MessagingException;
import javax.servlet.http.HttpServletRequest;
import org.molgenis.gaf.GafListFileImporterService;
import org.molgenis.gaf.GafListValidationReport;
import org.molgenis.ui.MolgenisPluginController;
import org.molgenis.util.ErrorMessageResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/plugin/gaflistimporter"})
@Scope(value="request")
public class GafListImporterController
extends MolgenisPluginController {
    private static final Logger LOG = LoggerFactory.getLogger(GafListImporterController.class);
    public static final String ID = "gaflistimporter";
    public static final String URI = "/plugin/gaflistimporter";
    public static final String KEY_GAF_LIST_PROTOCOL_NAME = "gafList.protocol.name";
    public static final String KEY_GAF_LIST_DATASET_IDENTIFIER = "gafList.dataset.identifier";
    private final GafListFileImporterService gafListFileImporterService;
    @Autowired
    private GafListValidationReport report;

    @Autowired
    public GafListImporterController(GafListFileImporterService gafListFileImporter) {
        super(URI);
        if (gafListFileImporter == null) {
            throw new IllegalArgumentException("gafListFileImporter is null");
        }
        this.gafListFileImporterService = gafListFileImporter;
    }

    @RequestMapping(method={RequestMethod.GET})
    @PreAuthorize(value="hasAnyRole('ROLE_SU')")
    public String init(Model model) throws Exception {
        model.addAttribute("action", (Object)"/validate");
        model.addAttribute("enctype", (Object)"multipart/form-data");
        return "view-gaflistimporter";
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/validate"})
    @PreAuthorize(value="hasAnyRole('ROLE_SU')")
    public String validateGAFList(Model model) throws Exception {
        return this.init(model);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/import"})
    @PreAuthorize(value="hasAnyRole('ROLE_SU')")
    public String importGAFList(Model model) throws Exception {
        return this.init(model);
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/validate"})
    @PreAuthorize(value="hasAnyRole('ROLE_SU')")
    public String validateGAFList(HttpServletRequest request, @RequestParam(value="csvFile") MultipartFile csvFile, Model model) throws IOException, MessagingException, Exception {
        boolean submitState = false;
        String action = "/validate";
        String enctype = "multipart/form-data";
        ArrayList<String> messages = new ArrayList<String>();
        if (!csvFile.isEmpty()) {
            try {
                this.gafListFileImporterService.validateGAFList(this.report, csvFile);
                model.addAttribute("hasValidationError", (Object)(this.report.hasGlobalErrors() || this.report.hasRunIdsErrors() ? 1 : 0));
                model.addAttribute("validationReport", (Object)this.report.toStringHtml());
                if (!this.report.getValidRunIds().isEmpty()) {
                    submitState = true;
                    action = "/import";
                    enctype = "application/x-www-form-urlencoded";
                    model.addAttribute("fileName", (Object)this.report.getTempFileOriginalName());
                    messages.add("Run id's: <b>" + this.report.getValidRunIds() + "</b> can be imported");
                } else {
                    messages.add("Validation for all runs failed");
                }
                if (this.report.hasGlobalErrors()) {
                    messages.addAll(this.report.getValidationGlobalErrorMessages());
                }
                if (this.report.hasRunIdsErrors()) {
                    messages.add("Run id's: <b>" + this.report.getInvalidRunIds() + "</b> cannot be imported");
                }
            }
            catch (Exception e) {
                String errorMessage = "Failed to validate this file";
                messages.add(errorMessage);
                LOG.error(errorMessage, (Throwable)e);
            }
        } else {
            String errorMessage = "The file you try to upload is empty! Filename: " + csvFile.getOriginalFilename();
            messages.add(errorMessage);
            LOG.error(errorMessage);
        }
        model.addAttribute("action", (Object)action);
        model.addAttribute("enctype", (Object)enctype);
        model.addAttribute("submit_state", (Object)submitState);
        model.addAttribute("messages", messages);
        return "view-gaflistimporter";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(method={RequestMethod.POST}, value={"/import"})
    @PreAuthorize(value="hasAnyRole('ROLE_SU')")
    public String importGAFList(HttpServletRequest request, Model model) throws Exception {
        ArrayList<String> messages = new ArrayList<String>();
        try {
            this.gafListFileImporterService.importGAFList(this.report, KEY_GAF_LIST_PROTOCOL_NAME);
            if (!this.report.getValidRunIds().isEmpty()) {
                messages.add("Successfully imported GAF list named: <b><a href=/menu/main/dataexplorer?entity=" + this.report.getDataSetIdentifier() + ">" + this.report.getDataSetName() + "</a></b>");
                messages.add("Imported run id's: <b>" + this.report.getValidRunIds() + "</b>");
            }
            if (this.report.hasRunIdsErrors()) {
                messages.add("Not imported run id's: <b>" + this.report.getInvalidRunIds() + "</b>");
            }
        }
        catch (Exception e) {
            String errorMessage = "Failed to import this file";
            messages.add(errorMessage);
            LOG.error(errorMessage, (Throwable)e);
        }
        finally {
            model.addAttribute("messages", messages);
            model.addAttribute("submit_state", (Object)false);
            model.addAttribute("action", (Object)"/validate");
            model.addAttribute("enctype", (Object)"multipart/form-data");
            this.report.cleanUp();
        }
        return "view-gaflistimporter";
    }

    @ExceptionHandler(value={Throwable.class})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public ErrorMessageResponse handleThrowable(Throwable t) {
        LOG.error("", t);
        return new ErrorMessageResponse(new ErrorMessageResponse.ErrorMessage(t.getMessage()));
    }
}

