<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <title>Genome report</title>
  <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/css/bootstrap.min.css" integrity="sha384-ggOyR0iXCbMQv3Xipma34MD+dH/1fQ784/j6cY/iJTQUOhcWr7x9JvoRxT2MZw1T" crossorigin="anonymous">
  <style>
    html {
      font-size: 12px;
    }
    h2 {
      margin-top: 3rem;
    }
    h3 {
      margin-top: 2rem;
    }
    .navbar-brand {
      padding-top: .75rem;
      padding-bottom: .75rem;
      font-size: 1rem;
    }
    .container-fluid {
      width: 100%;
      padding-right: 15px;
      padding-left: 15px;
      margin-right: auto;
      margin-left: auto;
    }
    .sidebar {
      position: fixed;
      top: 0;
      bottom: 0;
      left: 0;
      z-index: 100;
      padding: 48px 0 0;
      box-shadow: inset -1px 0 0 rgba(0, 0, 0, .1);
      margin-left: 1rem;
      margin-right: 1rem;
    }
    .sidebar-sticky {
      position: relative;
      top: 0;
      height: calc(100vh - 48px);
      padding-top: .5rem;
      overflow-x: hidden;
      overflow-y: auto;
    }
    main {
      padding-top: .5rem;
    }
    table {
      table-layout: fixed;
    }
    table.table-hover tr:hover {
      cursor: pointer;
    }
    $font-size-base: 0.8rem;
    $line-height-base: 1;
  </style>
  <script src="https://code.jquery.com/jquery-3.3.1.slim.min.js" integrity="sha384-q8i/X+965DzO0rT7abK41JStQIAqVgRVzpbzo5smXKp4YfRvH+8abtTE1Pi6jizo" crossorigin="anonymous"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.14.7/umd/popper.min.js" integrity="sha384-UO2eT0CpHqdSJQ6hJty5KVphtPhzWj9WO1clHTMGa3JDZwrnQq4sF86dIHNDz0W1" crossorigin="anonymous"></script>
  <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/js/bootstrap.min.js" integrity="sha384-JjSmVgyd0p3pXB1rRibZUAYoIIy6OrQ6VrjIEaFf/nJGzIxFDsf4x0xIM+B07jRM" crossorigin="anonymous"></script>
  <script src="https://cdn.jsdelivr.net/npm/vue/dist/vue.js"></script>
  <script>
    var variants = {
    <#list variants as category, categoryVariants>
    ${category}: [
      <#list categoryVariants as variant>
      {
        chrom: '${variant.chrom}',
        pos: '${variant.pos?c}',
        id: '${variant.id}',
        ref: '${variant.ref}',
        alt: '${variant.alt}',
        qual: '${variant.qual}',
        filter: '${variant.filter}',
        info: [<#list variant.info as info>'${info?js_string}'<#sep>,</#list>],
        cdna: '${variant.cdna}',
        gene: '${variant.gene}',
        genePhenotypes: '<#list variant.genePhenotypes as genePhenotype>${genePhenotype?js_string}<#sep>,</#list>',
        transcript: '${variant.transcript}',
        effect: '${variant.effect}',
        justification: '${variant.justification}',
        genotypeQuality: ${variant.genotypeQuality?c}
      }<#sep>,
      </#list>
    ]<#sep>,
    </#list>
    }

    var genePanels = {
    <#list genePanels as name, genes>
    ${name} : [<#list genes as gene>'${gene}'<#sep>,</#list>]
      <#sep>,</#list>
    }
  </script>
</head>
<body>
  <div id="app">
    <nav class="navbar navbar-dark fixed-top bg-dark flex-md-nowrap p-0 shadow">
      <a class="navbar-brand col-sm-3 col-md-2 mr-0" href="#">Genome report</a>
      <div class="form-check form-check-inline">
        <input v-model="showFilterNotPassed" class="form-check-input" type="checkbox" id="inlineCheckbox0" value="option1">
        <label class="form-check-label table-warning" for="inlineCheckbox0">Show Filter not passed</label>
      </div>
      <div class="form-check form-check-inline">
        <input v-model="showLowGenotypeQuality" class="form-check-input" type="checkbox" id="inlineCheckbox1" value="option1">
        <label class="form-check-label table-warning" for="inlineCheckbox1">Show Genotype Quality < 20</label>
      </div>
      <form class="form-inline">
        <select v-model="selectedGenePanel" class="custom-select">
          <option :value="null">Filter by virtual gene panel ...</option>
          <option v-for="(genes, name) in genePanels" :value="name">{{ name }}</option>
        </select>
      </form>
      <form class="form-inline">
        <input v-model="q" type="search" class="form-control mr-sm-2" placeholder="Search...">
      </form>
    </nav>
    <div class="container-fluid">
      <div class="row">
        <nav class="col-2 sidebar">
          <div class="sidebar-sticky">
            <ul class="nav flex-column">
              <li>STRONG CAUSAL SUSPECTS FOR MONOGENIC DISORDER</li>
              <li class="nav-item">
                <a :class="{'nav-link': true, disabled: filteredVariants.cat1.length === 0}" href="#variants-cat1">CAT. I</a>
              </li>
              <li class="nav-item">
                <a :class="{'nav-link': true, disabled: filteredVariants.cat2.length === 0}" href="#variants-cat2">CAT. II</a>
              </li>
              <li class="nav-item">
                <a :class="{'nav-link': true, disabled: filteredVariants.cat3.length === 0}" href="#variants-cat3">CAT. III</a>
              </li>
              <li class="nav-item">
                <a :class="{'nav-link': true, disabled: filteredVariants.cat4.length === 0}" href="#variants-cat4">CAT. IV</a>
              </li>
              <li>WEAK CAUSAL SUSPECTS FOR MONOGENIC DISORDER</li>
              <li class="nav-item">
                <a :class="{'nav-link': true, disabled: filteredVariants.cat5.length === 0}" href="#variants-cat5">CAT. V</a>
              </li>
              <li class="nav-item">
                <a :class="{'nav-link': true, disabled: filteredVariants.cat6.length === 0}" href="#variants-cat6">CAT. VI</a>
              </li>
              <li class="nav-item">
                <a :class="{'nav-link': true, disabled: filteredVariants.cat7.length === 0}" href="#variants-cat7">CAT. VII</a>
              </li>
              <li class="nav-item">
                <a :class="{'nav-link': true, disabled: filteredVariants.cat8.length === 0}" href="#variants-cat8">CAT. VIII</a>
              </li>
              <li>CARRIER STATUS OF MONOGENIC DISORDER</li>
              <li class="nav-item">
                <a :class="{'nav-link': true, disabled: filteredVariants.cat9.length === 0}" href="#variants-cat9">CAT. IX</a>
              </li>
              <li class="nav-item">
                <a :class="{'nav-link': true, disabled: filteredVariants.cat10.length === 0}" href="#variants-cat10">CAT. X</a>
              </li>
            </ul>
          </div>
        </nav>
        <main class="col-10 ml-sm-auto pl-5">
          <h2>STRONG CAUSAL SUSPECTS FOR MONOGENIC DISORDER</h2>
          <div v-if="filteredVariants.cat1.length > 0">
            <h3 id="variants-cat1">CAT. I: KNOWN PATHOGENIC VARIANT, IN CLINICAL GENE, AFFECTED STATUS</h3></a>
            <variant-table :variants="filteredVariants.cat1" @show-variant-details="onShowVariantDetails"></variant-table>
          </div>
          <div v-if="filteredVariants.cat2.length > 0">
            <h3 id="variants-cat2">CAT. II: PREDICTED PATHOGENIC VARIANT, IN CLINICAL GENE, AFFECTED STATUS</h3>
            <variant-table :variants="filteredVariants.cat2" @show-variant-details="onShowVariantDetails"></variant-table>
          </div>
          <div v-if="filteredVariants.cat3.length > 0">
            <h3 id="variants-cat3">CAT. III: KNOWN PATHOGENIC VARIANT, IN UNCHARACTERIZED GENE, HOMOZYGOUS GENOTYPE</h3>
            <variant-table :variants="filteredVariants.cat3" @show-variant-details="onShowVariantDetails"></variant-table>
          </div>
          <div v-if="filteredVariants.cat4.length > 0">
            <h3 id="variants-cat4">CAT. IV: PREDICTED PATHOGENIC VARIANT, IN UNCHARACTERIZED GENE, HOMOZYGOUS GENOTYPE</h3>
            <variant-table :variants="filteredVariants.cat4" @show-variant-details="onShowVariantDetails"></variant-table>
          </div>
          <h2>WEAK CAUSAL SUSPECTS FOR MONOGENIC DISORDER</h2>
          <div v-if="filteredVariants.cat5.length > 0">
            <h3 id="variants-cat5">CAT. V: KNOWN PATHOGENIC VARIANT, IN UNCHARACTERIZED GENE, HETEROZYGOUS GENOTYPE</h3>
            <variant-table :variants="filteredVariants.cat5" @show-variant-details="onShowVariantDetails"></variant-table>
          </div>
          <div v-if="filteredVariants.cat6.length > 0">
            <h3 id="variants-cat6">CAT. VI: PREDICTED PATHOGENIC VARIANT, IN UNCHARACTERIZED GENE, HETEROZYGOUS GENOTYPE</h3>
            <variant-table :variants="filteredVariants.cat6" @show-variant-details="onShowVariantDetails"></variant-table>
          </div>
          <div v-if="filteredVariants.cat7.length > 0">
            <h3 id="variants-cat7">CAT. VII: VUS, IN CLINICAL GENE, AFFECTED STATUS</h3>
            <variant-table :variants="filteredVariants.cat7" @show-variant-details="onShowVariantDetails"></variant-table>
          </div>
          <div v-if="filteredVariants.cat8.length > 0">
            <h3 id="variants-cat8">CAT. VIII: VUS, IN UNCHARACTERIZED GENE, HOMOZYGOUS GENOTYPE</h3>
            <variant-table :variants="filteredVariants.cat8" @show-variant-details="onShowVariantDetails"></variant-table>
          </div>
          <div v-if="filteredVariants.cat9.length > 0">
          <h2>CARRIER STATUS OF MONOGENIC DISORDER</h2>
            <h3 id="variants-cat9">CAT. IX: KNOWN PATHOGENIC VARIANT, IN CLINICAL GENE, CARRIER GENOTYPE</h3>
            <variant-table :variants="filteredVariants.cat9" @show-variant-details="onShowVariantDetails"></variant-table>
          </div>
          <div v-if="filteredVariants.cat10.length > 0">
            <h3 id="variants-cat10">CAT. X: PREDICTED PATHOGENIC VARIANT, IN CLINICAL GENE, CARRIER GENOTYPE</h3>
            <variant-table :variants="filteredVariants.cat10" @show-variant-details="onShowVariantDetails"></variant-table>
          </div>
        </main>
      </div>
    </div>
    <div class="modal" id="variant-details-modal" tabindex="-1" role="dialog">
      <div class="modal-dialog modal-xl" role="document">
        <div class="modal-content">
          <div class="modal-header">
            <h5 class="modal-title">Variant details</h5>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true">&times;</span>
            </button>
          </div>
          <div class="modal-body">
            <variant-details-table v-if="selectedVariant" :variant="selectedVariant"></variant-details-table>
          </div>
          <div class="modal-footer">
            <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
          </div>
        </div>
      </div>
    </div>
  </div>
</body>
<script>
  Vue.component('variant-details-table', {
    props: ['variant'],
    template: `
      <table class="table table-borderless">
        <tbody>
          <tr>
            <th scope="row">CHROM</th>
            <td>{{ variant.chrom }}</td>
          </tr>
          <tr>
            <th scope="row">POS</th>
            <td>{{ variant.pos }}</td>
          </tr>
          <tr>
            <th scope="row">ID</th>
            <td><a :href="'https://www.ncbi.nlm.nih.gov/snp/' + variant.id" target="_blank">{{ variant.id }}</a></td>
          </tr>
          <tr>
            <th scope="row">REF</th>
            <td>{{ variant.ref }}</td>
          </tr>
          <tr>
            <th scope="row">ALT</th>
            <td>{{ variant.alt }}</td>
          </tr>
          <tr>
            <th scope="row">QUAL</th>
            <td>{{ variant.qual }}</td>
          </tr>
          <tr>
            <th scope="row">FILTER</th>
            <td>{{ variant.filter }}</td>
          </tr>
          <tr>
            <th scope="row">INFO</th>
            <td><span class="text-break" style="display:block;" v-for="info in variant.info">{{ info }}</span></td>
          </tr>
        </tbody>
      </table>`
  })

  Vue.component('variant-table', {
    props: ['variants'],
    template: `
      <table class="table table-hover table-sm">
        <thead>
          <tr class="d-flex">
            <th class="col-3" colspan="3"scope="col">Change</th>
            <th class="col-2" scope="col">Consequence</th>
            <th class="col-2" scope="col">Justification</th>
            <th class="col-5" scope="col">Phenotypes</th>
          </tr>
        </thead>
        <tbody>
          <tr v-for="variant in variants" class="d-flex" :class="{'table-warning': variant.genotypeQuality < 20 || variant.filter !== 'PASS'}" @click="$emit('show-variant-details', variant)">
            <td class="col-1 text-truncate" @click.stop><a :href="'https://www.ncbi.nlm.nih.gov/nuccore/' + variant.transcript" target="_blank">{{ variant.transcript }}</a></td>
            <td class="col-1 text-truncate" @click.stop><a :href="'https://www.omim.org/search/?search=' + variant.gene + '&field=approved_gene_symbol'">{{ variant.gene }}</a></td>
            <td class="col-1 text-truncate">{{ variant.cdna }}</td>
            <td class="col-2 text-truncate">{{ variant.effect }}</td>
            <td class="col-2 text-truncate">{{ variant.justification }}</td>
            <td class="col-5 text-truncate">{{ variant.genePhenotypes }}</td>
          </tr>
        </tbody>
      </table>`
  })

  var app = new Vue({
    el: '#app',
    data: {
      showFilterNotPassed: true,
      showLowGenotypeQuality: true,
      variants: variants,
      selectedVariant: null,
      q: null,
      genePanels: genePanels,
      selectedGenePanel: null,
    },
    computed: {
      filteredVariants: function () {
        let qVariants = {}
        for (const category in this.variants) {
          qVariants[category] = this.variants[category].filter(
            variant => (this.showFilterNotPassed || variant.filter === 'PASS') && (this.showLowGenotypeQuality || variant.genotypeQuality >= 20))
        }

        if(this.q !== null) {
          var filteredVariants = {}
          for (const category in qVariants) {
            filteredVariants[category] = qVariants[category].filter(
              variant => variant.cdna.toLowerCase().indexOf(this.q.toLowerCase()) !== -1 || variant.gene.toLowerCase().indexOf(this.q.toLowerCase()) !== -1 || variant.transcript.toLowerCase().indexOf(this.q.toLowerCase()) !== -1 || variant.effect.toLowerCase().indexOf(this.q.toLowerCase()) !== -1 || variant.justification.toLowerCase().indexOf(this.q.toLowerCase()) !== -1 || variant.genePhenotypes.toLowerCase().indexOf(this.q.toLowerCase()) !== -1)
          }
          qVariants = filteredVariants
        }
        if(this.selectedGenePanel == null) {
          return qVariants
        } else {
          let genes = this.genePanels[this.selectedGenePanel]
          var filteredVariants = {}
          for (const category in this.variants) {
            filteredVariants[category] = qVariants[category].filter(variant => variant.gene && genes.includes(variant.gene))
          }
          return filteredVariants
        }
      }
    },
    methods: {
      onShowVariantDetails: function(variant) {
        this.selectedVariant = variant
      }
    },
    watch: {
      selectedVariant: function () {
        $('#variant-details-modal').modal('show')
      }
    }
  })
</script>
</html>

