/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.vcf.meta;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.LinkedHashMap;
import java.util.Map;
import net.sf.samtools.util.BlockCompressedInputStream;
import org.apache.commons.lang3.StringUtils;
import org.molgenis.vcf.meta.VcfMeta;
import org.molgenis.vcf.meta.VcfMetaAlt;
import org.molgenis.vcf.meta.VcfMetaContig;
import org.molgenis.vcf.meta.VcfMetaFilter;
import org.molgenis.vcf.meta.VcfMetaFormat;
import org.molgenis.vcf.meta.VcfMetaInfo;
import org.molgenis.vcf.meta.VcfMetaPedigree;
import org.molgenis.vcf.meta.VcfMetaSample;

public class VcfMetaParser {
    private static final String PREFIX_ALT = "##ALT";
    private static final String PREFIX_CONTIG = "##contig";
    private static final String PREFIX_FILTER = "##FILTER";
    private static final String PREFIX_FORMAT = "##FORMAT";
    private static final String PREFIX_INFO = "##INFO";
    private static final String PREFIX_PEDIGREE = "##PEDIGREE";
    private static final String PREFIX_SAMPLE = "##SAMPLE";
    private final BufferedReader reader;
    private final BlockCompressedInputStream blockCompressedInputStream;

    public VcfMetaParser(Reader reader) throws IOException {
        if (reader == null) {
            throw new IllegalArgumentException("reader is null");
        }
        this.reader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        this.blockCompressedInputStream = null;
    }

    public VcfMetaParser(BlockCompressedInputStream blockCompressedInputStream) {
        if (blockCompressedInputStream == null) {
            throw new IllegalArgumentException("blockCompressedInputStream is null");
        }
        this.blockCompressedInputStream = blockCompressedInputStream;
        this.reader = null;
    }

    public VcfMeta parse() throws IOException {
        String line;
        VcfMeta vcfMeta = new VcfMeta();
        while ((line = this.readLine()) != null && line.startsWith("##")) {
            if (line.startsWith(PREFIX_ALT)) {
                vcfMeta.addAltMeta(new VcfMetaAlt(this.parseMetaLine(line)));
                continue;
            }
            if (line.startsWith(PREFIX_CONTIG)) {
                vcfMeta.addContigMeta(new VcfMetaContig(this.parseMetaLine(line)));
                continue;
            }
            if (line.startsWith(PREFIX_FILTER)) {
                vcfMeta.addFilterMeta(new VcfMetaFilter(this.parseMetaLine(line)));
                continue;
            }
            if (line.startsWith(PREFIX_FORMAT)) {
                vcfMeta.addFormatMeta(new VcfMetaFormat(this.parseMetaLine(line)));
                continue;
            }
            if (line.startsWith(PREFIX_INFO)) {
                vcfMeta.addInfoMeta(new VcfMetaInfo(this.parseMetaLine(line)));
                continue;
            }
            if (line.startsWith(PREFIX_PEDIGREE)) {
                vcfMeta.addPedigreeMeta(new VcfMetaPedigree(this.parseMetaLine(line)));
                continue;
            }
            if (line.startsWith(PREFIX_SAMPLE)) {
                vcfMeta.addSampleMeta(new VcfMetaSample(this.parseMetaLine(line)));
                continue;
            }
            int idx = line.indexOf(61);
            vcfMeta.add(line.substring(2, idx), line.substring(idx + 1));
        }
        if (line == null || !line.startsWith("#CHROM")) {
            throw new IOException("missing column headers");
        }
        vcfMeta.setColNames(StringUtils.split(line, '\t'));
        return vcfMeta;
    }

    private Map<String, String> parseMetaLine(String line) {
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
        boolean inHeaderBlock = false;
        boolean inQuotes = false;
        boolean inKey = true;
        StringBuilder key = new StringBuilder();
        StringBuilder value = new StringBuilder();
        int nrChars = line.length();
        for (int i = 0; i < nrChars; ++i) {
            char c = line.charAt(i);
            if (!inHeaderBlock) {
                if ('<' != c) continue;
                inHeaderBlock = true;
                continue;
            }
            if (inKey && '=' == c) {
                inKey = false;
                continue;
            }
            if (!inKey && '\"' == c) {
                if (inQuotes) {
                    inQuotes = false;
                    properties.put(key.toString(), value.toString());
                    key = new StringBuilder();
                    value = new StringBuilder();
                    inKey = true;
                    continue;
                }
                inQuotes = true;
                continue;
            }
            if (!(inQuotes || inKey || ',' != c && '>' != c)) {
                properties.put(key.toString(), value.toString());
                key = new StringBuilder();
                value = new StringBuilder();
                inKey = true;
                continue;
            }
            if (inKey) {
                key.append(c);
                continue;
            }
            value.append(c);
        }
        return properties;
    }

    private String readLine() throws IOException {
        String line = this.reader != null ? this.reader.readLine() : this.blockCompressedInputStream.readLine();
        return line;
    }
}

