/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.vcf;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import net.sf.samtools.util.BlockCompressedOutputStream;
import org.molgenis.vcf.VcfWriter;
import org.molgenis.vcf.meta.VcfMeta;
import org.molgenis.vcf.v4_2.Vcf42Writer;

public class VcfWriterFactory {
    public VcfWriter create(File file, VcfMeta vcfMeta) throws FileNotFoundException {
        return this.create(file, vcfMeta, this.getFormat(file));
    }

    public VcfWriter create(File file, VcfMeta vcfMeta, Format format) throws FileNotFoundException {
        return this.create(file, vcfMeta, format, Version.V4_2);
    }

    public VcfWriter create(File file, VcfMeta vcfMeta, Format format, Version version) throws FileNotFoundException {
        OutputStream outputStream;
        switch (format) {
            case GZIP: {
                outputStream = new BlockCompressedOutputStream(file);
                break;
            }
            case UNCOMPRESSED: {
                outputStream = new FileOutputStream(file);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Unknown format '%s'", new Object[]{format}));
            }
        }
        return this.create(outputStream, vcfMeta, version);
    }

    public VcfWriter create(OutputStream outputStream, VcfMeta vcfMeta) {
        return this.create(outputStream, vcfMeta, Format.UNCOMPRESSED);
    }

    public VcfWriter create(OutputStream outputStream, VcfMeta vcfMeta, Format format) {
        return this.create(outputStream, vcfMeta, format, Version.V4_2);
    }

    public VcfWriter create(OutputStream outputStream, VcfMeta vcfMeta, Format format, Version version) {
        switch (format) {
            case GZIP: {
                outputStream = new BlockCompressedOutputStream(outputStream, null);
                break;
            }
            case UNCOMPRESSED: {
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Unknown format '%s'", new Object[]{format}));
            }
        }
        return this.create(outputStream, vcfMeta, version);
    }

    private VcfWriter create(OutputStream outputStream, VcfMeta vcfMeta, Version version) {
        Vcf42Writer vcfWriter;
        switch (version) {
            case V4_1: 
            case V4_3: {
                throw new IllegalArgumentException(String.format("Unsupported version '%s'", new Object[]{version}));
            }
            case V4_2: {
                vcfWriter = new Vcf42Writer(outputStream, vcfMeta);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Unknown version '%s'", new Object[]{version}));
            }
        }
        return vcfWriter;
    }

    private Format getFormat(File file) {
        if (file.getName().toLowerCase().endsWith(".gz")) {
            return Format.GZIP;
        }
        return Format.UNCOMPRESSED;
    }

    public static enum Version {
        V4_1,
        V4_2,
        V4_3;

    }

    public static enum Format {
        GZIP,
        UNCOMPRESSED;

    }
}

