/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.vcf;

import com.google.common.base.CharMatcher;
import java.util.ArrayList;
import java.util.List;
import org.molgenis.genotype.Allele;
import org.molgenis.vcf.VcfRecord;

public class VcfSample {
    private static final String FIELD_GT = "GT";
    private static final char GENOTYPE_UNPHASED = '/';
    private static final char GENOTYPE_PHASED = '|';
    private final VcfRecord vcfRecord;
    private String[] tokens;
    private transient List<Allele> cachedAlleles;

    public VcfSample(VcfRecord vcfRecord) {
        this(vcfRecord, null);
    }

    public VcfSample(VcfRecord vcfRecord, String[] tokens) {
        if (vcfRecord == null) {
            throw new IllegalArgumentException("vcfRecord is null");
        }
        this.vcfRecord = vcfRecord;
        this.tokens = tokens;
    }

    public String[] getTokens() {
        return this.tokens;
    }

    public String getData(int idx) {
        String data = idx == 0 || idx < this.tokens.length ? this.tokens[idx] : null;
        return data != null && data.equals(".") ? null : data;
    }

    public List<Boolean> getPhasings() {
        String[] dataTypes = this.vcfRecord.getFormat();
        if (dataTypes.length == 0 || !dataTypes[0].equals(FIELD_GT)) {
            return null;
        }
        String genotype = this.tokens[0];
        ArrayList<Boolean> phasings = new ArrayList<Boolean>(1);
        int nrChars = genotype.length();
        block4: for (int i = 0; i < nrChars; ++i) {
            switch (genotype.charAt(i)) {
                case '|': {
                    phasings.add(Boolean.TRUE);
                    continue block4;
                }
                case '/': {
                    phasings.add(Boolean.FALSE);
                    continue block4;
                }
            }
        }
        return phasings;
    }

    public List<Allele> getAlleles() {
        if (this.cachedAlleles == null) {
            String[] dataTypes = this.vcfRecord.getFormat();
            if (dataTypes.length == 0 || !dataTypes[0].equals(FIELD_GT)) {
                return null;
            }
            String genotype = this.tokens[0];
            Allele referenceAllele = this.vcfRecord.getReferenceAllele();
            List<Allele> alternateAlleles = this.vcfRecord.getAlternateAlleles();
            this.cachedAlleles = new ArrayList<Allele>(2);
            int nrGenotypeChars = genotype.length();
            int start = 0;
            for (int j = 0; j < nrGenotypeChars; ++j) {
                int alleleIndex;
                char c = genotype.charAt(j);
                if (c != '|' && c != '/' && j != nrGenotypeChars - 1) continue;
                if (j - start == 1) {
                    char alleleChar;
                    char c2 = alleleChar = j == nrGenotypeChars - 1 ? c : genotype.charAt(j - 1);
                    if (alleleChar != '.') {
                        alleleIndex = Character.digit(alleleChar, 10);
                        if (alleleIndex == 0) {
                            this.cachedAlleles.add(referenceAllele);
                        } else {
                            this.cachedAlleles.add(alternateAlleles.get(alleleIndex - 1));
                        }
                    } else {
                        this.cachedAlleles.add(Allele.ZERO);
                    }
                } else {
                    String alleleIndexStr;
                    String string = alleleIndexStr = j == nrGenotypeChars - 1 ? genotype.substring(start) : genotype.substring(start, j);
                    if (!alleleIndexStr.equals(".")) {
                        try {
                            alleleIndex = Integer.parseInt(alleleIndexStr);
                        }
                        catch (NumberFormatException ex) {
                            alleleIndex = Integer.parseInt(CharMatcher.JAVA_ISO_CONTROL.removeFrom(alleleIndexStr));
                        }
                        if (alleleIndex == 0) {
                            this.cachedAlleles.add(referenceAllele);
                        } else {
                            this.cachedAlleles.add(alternateAlleles.get(alleleIndex - 1));
                        }
                    } else {
                        this.cachedAlleles.add(Allele.ZERO);
                    }
                }
                start = j + 1;
            }
        }
        return this.cachedAlleles;
    }

    public VcfSample createClone() {
        return new VcfSample(this.vcfRecord, this.tokens);
    }

    public void reset(String[] tokens) {
        this.tokens = tokens;
        this.cachedAlleles = null;
    }
}

