/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.vcf;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import joptsimple.internal.Strings;
import org.apache.commons.lang.StringUtils;
import org.molgenis.data.vcf.datastructures.Sample;
import org.molgenis.genotype.Allele;
import org.molgenis.vcf.VcfInfo;
import org.molgenis.vcf.VcfRecord;
import org.molgenis.vcf.VcfSample;
import org.molgenis.vcf.meta.VcfMeta;

public class VcfRecordUtils {
    private VcfRecordUtils() {
    }

    public static Optional<VcfInfo> getInformation(String key, VcfRecord vcfRecord) {
        for (VcfInfo vcfInfo : vcfRecord.getInformation()) {
            if (!vcfInfo.getKey().equals(key)) continue;
            return Optional.of(vcfInfo);
        }
        return Optional.empty();
    }

    public static String getChrPosRefAlt(VcfRecord vcfRecord) {
        return vcfRecord.getChromosome() + "_" + vcfRecord.getPosition() + "_" + VcfRecordUtils.getRef(vcfRecord) + "_" + StringUtils.join((Object[])VcfRecordUtils.getAlts(vcfRecord), ',');
    }

    public static String getRef(VcfRecord vcfRecord) {
        return vcfRecord.getReferenceAllele().getAlleleAsString();
    }

    public static String[] getAltsAsStringArray(VcfRecord vcfRecord) {
        return vcfRecord.getAlternateAlleles().stream().map(Allele::getAlleleAsString).collect(Collectors.toList()).toArray(new String[vcfRecord.getAlternateAlleles().size()]);
    }

    public static String getAltString(VcfRecord vcfRecord) {
        StringBuilder sb = new StringBuilder();
        for (String alt : VcfRecordUtils.getAltsAsStringArray(vcfRecord)) {
            sb.append(alt).append(",");
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    public static String getAlt(VcfRecord vcfRecord, int i) {
        return VcfRecordUtils.getAltsAsStringArray(vcfRecord)[i];
    }

    public static String[] getAlts(VcfRecord vcfRecord) {
        return VcfRecordUtils.getAltsAsStringArray(vcfRecord);
    }

    public static String getAlt(VcfRecord vcfRecord) throws RuntimeException {
        if (VcfRecordUtils.getAltsAsStringArray(vcfRecord).length > 1) {
            throw new RuntimeException("more than 1 alt ! " + vcfRecord.toString());
        }
        return VcfRecordUtils.getAltsAsStringArray(vcfRecord)[0];
    }

    public static int getAltAlleleIndex(VcfRecord vcfRecord, String alt) {
        return Arrays.asList(VcfRecordUtils.getAlts(vcfRecord)).indexOf(alt) + 1;
    }

    public static int getAltIndex(VcfRecord vcfRecord, String alt) throws Exception {
        for (int i = 0; i < VcfRecordUtils.getAltsAsStringArray(vcfRecord).length; ++i) {
            if (!alt.equals(VcfRecordUtils.getAltsAsStringArray(vcfRecord)[i])) continue;
            return i + 1;
        }
        throw new Exception("alt not found");
    }

    public static String getId(VcfRecord vcfRecord) {
        return String.join((CharSequence)",", vcfRecord.getIdentifiers());
    }

    @Nullable
    public static String getSampleFieldValue(VcfRecord vcfEntity, VcfSample sample, String field) {
        String[] format = vcfEntity.getFormat();
        for (int i = 0; i < format.length; ++i) {
            if (!format[i].equals(field)) continue;
            return sample.getData(i);
        }
        return null;
    }

    public static Double[] getAltAlleleOrderedDoubleField(VcfRecord vcfRecord, String fieldName) {
        int nrOfAlts = VcfRecordUtils.getAltsAsStringArray(vcfRecord).length;
        String fieldValue = VcfRecordUtils.getInfoStringValue(vcfRecord, fieldName);
        Double[] result = new Double[nrOfAlts];
        if (fieldValue != null) {
            String[] split = fieldValue.split(",", -1);
            if (split != null) {
                if (split.length != nrOfAlts) {
                    throw new RuntimeException(String.format("Split length %s of string '%s' not equal to alt allele split length %s for record '%s'", split.length, fieldValue, nrOfAlts, vcfRecord.toString()));
                }
                for (int i = 0; i < split.length; ++i) {
                    result[i] = VcfRecordUtils.isValuePresent(split, i) ? Double.valueOf(Double.parseDouble(split[i])) : null;
                }
            } else {
                throw new RuntimeException(fieldName + " split is null");
            }
        }
        return result;
    }

    private static boolean isValuePresent(String[] split, int index) {
        String value = split[index];
        return !Strings.isNullOrEmpty(value) && !value.equals(".");
    }

    private static String getInfoStringValue(VcfRecord record, String infoField) {
        String result = null;
        Iterable<VcfInfo> infoFields = record.getInformation();
        for (VcfInfo info : infoFields) {
            if (!info.getKey().equals(infoField)) continue;
            Object vcfInfoVal = info.getVal();
            if (vcfInfoVal instanceof List) {
                List vcfInfoValTokens = (List)vcfInfoVal;
                result = vcfInfoValTokens.stream().map(vcfInfoValToken -> vcfInfoValToken != null ? vcfInfoValToken.toString() : ".").collect(Collectors.joining(","));
                continue;
            }
            result = vcfInfoVal.toString();
        }
        return result;
    }

    public static Stream<Sample> toSamples(VcfRecord vcfRecord) {
        AtomicInteger counter = new AtomicInteger(0);
        VcfMeta vcfMeta = vcfRecord.getVcfMeta();
        return StreamSupport.stream(vcfRecord.getSamples().spliterator(), false).map(vcfSample -> {
            String sampleName = vcfMeta.getSampleName(counter.getAndIncrement());
            String genoType = VcfRecordUtils.getSampleFieldValue(vcfRecord, vcfSample, "GT");
            String doubleString = VcfRecordUtils.getSampleFieldValue(vcfRecord, vcfSample, "DP");
            Double depth = doubleString != null ? Double.valueOf(Double.parseDouble(doubleString)) : null;
            return new Sample(sampleName, genoType, depth);
        });
    }
}

