/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.genotype.oxford;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.molgenis.genotype.GenotypeData;
import org.molgenis.genotype.Sample;
import org.molgenis.genotype.annotation.SampleAnnotation;
import org.molgenis.genotype.annotation.SexAnnotation;

public class OxfordSampleFileWriter {
    public static final Charset FILE_ENCODING = Charset.forName("UTF-8");
    public static final String LINE_ENDING = "\n";
    private static final char SEPARATOR = ' ';
    private static final Logger LOG = Logger.getLogger(OxfordSampleFileWriter.class);

    public static void writeSampleFile(File sampleFile, GenotypeData genotypeData, HashMap<Sample, Float> sampleMissingness) throws IOException {
        BufferedWriter sampleWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(sampleFile), FILE_ENCODING));
        sampleWriter.append("ID_1");
        sampleWriter.append(' ');
        sampleWriter.append("ID_2");
        sampleWriter.append(' ');
        sampleWriter.append("missing");
        ArrayList<String> colNames = new ArrayList<String>();
        ArrayList<String> dataTypes = new ArrayList<String>();
        block10: for (SampleAnnotation annotation : genotypeData.getSampleAnnotations()) {
            if (annotation.getId().equals("sampleMissingRateFloat")) continue;
            if (annotation.getSampleAnnotationType() == SampleAnnotation.SampleAnnotationType.COVARIATE) {
                switch (annotation.getType()) {
                    case INTEGER: {
                        colNames.add(annotation.getId());
                        dataTypes.add("D");
                        continue block10;
                    }
                    case STRING: {
                        colNames.add(annotation.getId());
                        dataTypes.add("D");
                        continue block10;
                    }
                    case SEX: {
                        colNames.add(annotation.getId());
                        dataTypes.add("D");
                        continue block10;
                    }
                    case FLOAT: {
                        colNames.add(annotation.getId());
                        dataTypes.add("C");
                        continue block10;
                    }
                }
                LOG.warn("Unsupported covariate datatype [" + (Object)((Object)annotation.getType()) + "]");
                continue;
            }
            if (annotation.getSampleAnnotationType() == SampleAnnotation.SampleAnnotationType.PHENOTYPE) {
                switch (annotation.getType()) {
                    case BOOLEAN: {
                        colNames.add(annotation.getId());
                        dataTypes.add("B");
                        continue block10;
                    }
                    case FLOAT: {
                        colNames.add(annotation.getId());
                        dataTypes.add("P");
                        continue block10;
                    }
                }
                LOG.warn("Unsupported phenotype datatype [" + (Object)((Object)annotation.getType()) + "]");
                continue;
            }
            LOG.warn("'OTHER' sample annotation type not supported by oxford sample file");
        }
        for (String colName : colNames) {
            if (colName.equals("sex_generic")) {
                colName = "sex";
            }
            sampleWriter.append(' ');
            sampleWriter.append(colName);
        }
        sampleWriter.append(LINE_ENDING);
        sampleWriter.append("0");
        sampleWriter.append(' ');
        sampleWriter.append("0");
        sampleWriter.append(' ');
        sampleWriter.append("0");
        for (String dataType : dataTypes) {
            sampleWriter.append(' ');
            sampleWriter.append(dataType);
        }
        sampleWriter.append(LINE_ENDING);
        for (Sample sample : genotypeData.getSamples()) {
            sampleWriter.append(sample.getFamilyId() == null ? "NA" : sample.getFamilyId());
            sampleWriter.append(' ');
            sampleWriter.append(sample.getId() == null ? "NA" : sample.getId());
            sampleWriter.append(' ');
            sampleWriter.append(String.valueOf(sampleMissingness.get(sample)));
            for (String colName : colNames) {
                sampleWriter.append(' ');
                sampleWriter.append(OxfordSampleFileWriter.getValue(colName, sample, "NA"));
            }
            sampleWriter.append(LINE_ENDING);
        }
        ((Writer)sampleWriter).close();
    }

    private static String getValue(String colName, Sample sample, String nullValue) {
        Object value = sample.getAnnotationValues().get(colName);
        if (value == null) {
            return nullValue;
        }
        if (value instanceof Boolean) {
            return value.equals(true) ? "1" : "0";
        }
        if (value instanceof Double) {
            if (Double.isNaN((Double)value)) {
                return nullValue;
            }
            String result = value.toString();
            if (result.equals("0.0")) {
                result = "0";
            }
            return result;
        }
        if (value instanceof Float) {
            if (Float.isNaN(((Float)value).floatValue())) {
                return nullValue;
            }
            String result = value.toString();
            if (result.equals("0.0")) {
                result = "0";
            }
            return result;
        }
        if (value instanceof SexAnnotation) {
            SexAnnotation sexValue = (SexAnnotation)((Object)value);
            switch (sexValue) {
                case UNKNOWN: {
                    return nullValue;
                }
            }
            return Byte.toString(sexValue.getPlinkSex());
        }
        return value.toString();
    }
}

