/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.genotype.examples;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.molgenis.genotype.Allele;
import org.molgenis.genotype.Alleles;
import org.molgenis.genotype.GenotypeDataException;
import org.molgenis.genotype.RandomAccessGenotypeData;
import org.molgenis.genotype.RandomAccessGenotypeDataReaderFormats;
import org.molgenis.genotype.Sample;
import org.molgenis.genotype.plink.BedBimFamGenotypeData;
import org.molgenis.genotype.util.Ld;
import org.molgenis.genotype.util.LdCalculatorException;
import org.molgenis.genotype.variant.GeneticVariant;

@SuppressWarnings(value={"UCF_USELESS_CONTROL_FLOW_NEXT_LINE"}, justification="It is just an example")
public class BasicUsage {
    private static Logger LOGGER = Logger.getLogger(BasicUsage.class);

    public static void main(String[] args) {
        String datasetPath = "/some/path/file";
        BedBimFamGenotypeData genotypeData = null;
        try {
            genotypeData = new BedBimFamGenotypeData(datasetPath, 1000);
        }
        catch (IOException ex) {
            LOGGER.fatal("IO error: " + ex.getMessage());
            System.exit(1);
        }
        for (GeneticVariant variant : genotypeData) {
            System.out.println(variant.getPrimaryVariantId());
        }
        for (Sample sample : genotypeData.getSamples()) {
            System.out.println("Sample ID: " + sample.getId() + " sex: " + (Object)((Object)sample.getSex()));
        }
        RandomAccessGenotypeData randomAccessGenotypeData = null;
        try {
            randomAccessGenotypeData = new BedBimFamGenotypeData(datasetPath);
            randomAccessGenotypeData = RandomAccessGenotypeDataReaderFormats.PLINK_BED.createGenotypeData(datasetPath, 1000);
            randomAccessGenotypeData = RandomAccessGenotypeDataReaderFormats.valueOf("PLINK_BED").createGenotypeData(datasetPath, 1000);
        }
        catch (IOException ex) {
            LOGGER.fatal("IO error: " + ex.getMessage());
            System.exit(1);
        }
        catch (GenotypeDataException ex) {
            LOGGER.fatal("Genotype data error: " + ex.getMessage());
            System.exit(1);
        }
        for (String sequenceNames : randomAccessGenotypeData.getSeqNames()) {
            System.out.println("Seq/Chr: " + sequenceNames);
        }
        for (GeneticVariant variant : randomAccessGenotypeData.getVariantsByRange("1", 1, 10)) {
            System.out.println("Variant ID: " + variant.getPrimaryVariantId());
        }
        HashMap<String, GeneticVariant> variantHashMap = randomAccessGenotypeData.getVariantIdMap();
        GeneticVariant snp = randomAccessGenotypeData.getSnpVariantByPos("1", 1);
        snp.isSnp();
        for (Alleles sampleAlleles : snp.getSampleVariants()) {
            System.out.println(sampleAlleles.getAllelesAsString());
        }
        for (Object dosage : (Object)snp.getSampleCalledDosages()) {
            System.out.println((int)dosage);
        }
        for (Object dosage : (Object)snp.getSampleDosages()) {
            System.out.println((float)dosage);
        }
        snp.getMinorAllele();
        snp.getMinorAlleleFrequency();
        snp.getCallRate();
        snp.getHwePvalue();
        snp.isBiallelic();
        snp.isMapped();
        snp.isAtOrGcSnp();
        GeneticVariant snp2 = null;
        Iterator<GeneticVariant> sampleAlleles = randomAccessGenotypeData.getVariantsByPos("1", 2).iterator();
        if (sampleAlleles.hasNext()) {
            GeneticVariant variantAtPos2;
            snp2 = variantAtPos2 = sampleAlleles.next();
        }
        Ld ld = null;
        try {
            ld = snp.calculateLd(snp2);
        }
        catch (LdCalculatorException ex) {
            LOGGER.fatal("Error in LD calculation: " + ex.getMessage(), ex);
            System.exit(1);
        }
        ld.getR2();
        ld.getDPrime();
        Alleles snpAlleles = snp.getVariantAlleles();
        for (Allele a : snpAlleles) {
            System.out.println("Allele: " + a);
        }
        Alleles alleles1 = Alleles.createAlleles(Allele.A, Allele.C);
        Alleles alleles2 = Alleles.createAlleles(Allele.C, Allele.A);
        Alleles alleles3 = Alleles.createAlleles(Allele.A, Allele.C);
        if (alleles1 == alleles2) {
            // empty if block
        }
        if (alleles1 == alleles3) {
            // empty if block
        }
        if (alleles1.sameAlleles(alleles2)) {
            // empty if block
        }
    }
}

