/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.annotation.reportrvcf;

import java.io.File;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.molgenis.calibratecadd.support.GavinUtils;
import org.molgenis.data.annotation.makervcf.structs.AnnotatedVcfRecord;
import org.molgenis.data.annotation.makervcf.structs.GavinRecord;
import org.molgenis.vcf.VcfReader;
import org.molgenis.vcf.VcfRecord;
import org.molgenis.vcf.VcfRecordUtils;

public class FOR {
    private File originalVcfFile;
    private File rvcfFile;
    private File genesFORoutput;

    public static void main(String[] args) throws Exception {
        String dir = args[0];
        FOR falseOM = new FOR(new File(dir + args[1]), new File(dir + args[2]), new File(dir + args[3]));
        falseOM.go();
    }

    public FOR(File originalVcfFile, File rvcfFile, File genesFORoutput) {
        this.originalVcfFile = originalVcfFile;
        this.rvcfFile = rvcfFile;
        this.genesFORoutput = genesFORoutput;
    }

    public void go() throws Exception {
        VcfReader vcf = GavinUtils.getVcfReader(this.originalVcfFile);
        Iterator<VcfRecord> originalVcfIterator = vcf.iterator();
        HashMap<String, Object> variantToGene = new HashMap<String, Object>();
        while (originalVcfIterator.hasNext()) {
            Object gene;
            GavinRecord record = new GavinRecord(originalVcfIterator.next());
            if (record.getId() != null && record.getId().split(":", -1).length == 2) {
                gene = record.getId().split(":", -1)[0];
            } else {
                if (record.getGenes().size() > 1) {
                    throw new Exception("more than 1 gene (" + record.getGenes().toString() + ") for " + record.toString());
                }
                gene = record.getGenes().toArray()[0].toString();
            }
            variantToGene.put(record.getChromosome() + "_" + record.getPosition() + "_" + record.getRef() + "_" + record.getAlt(), gene);
        }
        System.out.println("pathogenic variants, size BEFORE removing detected variants: " + variantToGene.size());
        HashMap<String, Integer> countPerGeneExpected = new HashMap<String, Integer>();
        for (Map.Entry entry : variantToGene.entrySet()) {
            String gene = (String)entry.getValue();
            if (countPerGeneExpected.containsKey(gene)) {
                countPerGeneExpected.put(gene, (Integer)countPerGeneExpected.get(gene) + 1);
                continue;
            }
            countPerGeneExpected.put(gene, 1);
        }
        System.out.println("gold standard patho variant counts per gene: " + countPerGeneExpected.toString());
        VcfReader rvcf = GavinUtils.getVcfReader(this.rvcfFile);
        for (Object aRvcf : rvcf) {
            AnnotatedVcfRecord record = new AnnotatedVcfRecord((VcfRecord)aRvcf);
            String key = record.getChromosome() + "_" + record.getPosition() + "_" + VcfRecordUtils.getRef(record) + "_" + VcfRecordUtils.getAlt(record);
            variantToGene.remove(key);
        }
        System.out.println("pathogenic variants, size AFTER removing detected variants: " + variantToGene.size());
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        for (String variant : variantToGene.keySet()) {
            String gene = (String)variantToGene.get(variant);
            if (hashMap.containsKey(gene)) {
                hashMap.put(gene, (Integer)hashMap.get(gene) + 1);
                continue;
            }
            hashMap.put(gene, 1);
        }
        System.out.println("left over variant counts per gene: " + hashMap.toString());
        PrintWriter pw = new PrintWriter(this.genesFORoutput);
        pw.println("Gene\tExpected\tObserved\tMissedFrac");
        for (String gene : countPerGeneExpected.keySet()) {
            int subtract = 0;
            if (hashMap.containsKey(gene)) {
                subtract = (Integer)hashMap.get(gene);
            }
            int exp = (Integer)countPerGeneExpected.get(gene);
            int obs = (Integer)countPerGeneExpected.get(gene) - subtract;
            pw.println(gene + "\t" + exp + "\t" + obs + "\t" + (1.0 - (double)obs / (double)exp));
        }
        pw.flush();
        pw.close();
    }
}

