/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.annotation.reportrvcf;

import java.io.File;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.molgenis.calibratecadd.support.GavinUtils;
import org.molgenis.data.annotation.makervcf.positionalstream.MatchVariantsToGenotypeAndInheritance;
import org.molgenis.data.annotation.makervcf.structs.AnnotatedVcfRecord;
import org.molgenis.data.annotation.makervcf.structs.RVCF;
import org.molgenis.vcf.VcfReader;
import org.molgenis.vcf.VcfRecord;

public class FDR {
    private VcfReader vcf;
    private PrintWriter pw;
    int nrOfSamples;
    public static final String HEADER = "Gene\tAffectedAbs\tCarrierAbs\tAffectedFrac\tCarrierFrac";

    public static void main(String[] args) throws Exception {
        String mtRvcfFileName = args[0];
        String fdrFileName = args[1];
        FDR fdr = new FDR(new File(mtRvcfFileName), new File(fdrFileName), 2504);
        fdr.go();
    }

    public FDR(File rvcfInput, File outputFDR, int nrOfSamples) throws Exception {
        this.vcf = GavinUtils.getVcfReader(rvcfInput);
        this.pw = new PrintWriter(outputFDR);
        this.nrOfSamples = nrOfSamples;
    }

    public void go() throws Exception {
        HashMap<String, Integer> geneToAffected = new HashMap<String, Integer>();
        HashMap<String, Integer> geneToCarrier = new HashMap<String, Integer>();
        HashSet<String> sampleGeneCombo = new HashSet<String>();
        for (VcfRecord vcfRecord : this.vcf) {
            AnnotatedVcfRecord record = new AnnotatedVcfRecord(vcfRecord);
            for (RVCF rvcf : record.getRvcf()) {
                String gene = rvcf.getGene();
                if (!geneToAffected.containsKey(gene)) {
                    geneToAffected.put(gene, 0);
                    geneToCarrier.put(gene, 0);
                }
                for (String sample : rvcf.getSampleStatus().keySet()) {
                    int count;
                    if (MatchVariantsToGenotypeAndInheritance.Status.isPresumedAffected(rvcf.getSampleStatus().get(sample))) {
                        if (sampleGeneCombo.contains(gene + "_" + sample)) continue;
                        count = (Integer)geneToAffected.get(gene);
                        geneToAffected.put(gene, count + 1);
                        sampleGeneCombo.add(gene + "_" + sample);
                        continue;
                    }
                    if (MatchVariantsToGenotypeAndInheritance.Status.isPresumedCarrier(rvcf.getSampleStatus().get(sample))) {
                        if (sampleGeneCombo.contains(gene + "_" + sample)) continue;
                        count = (Integer)geneToCarrier.get(gene);
                        geneToCarrier.put(gene, count + 1);
                        sampleGeneCombo.add(gene + "_" + sample);
                        continue;
                    }
                    throw new Exception("ERROR: Unknown sample Status: " + (Object)((Object)rvcf.getSampleStatus().get(sample)));
                }
            }
        }
        this.pw.println(HEADER);
        for (Map.Entry entry : geneToAffected.entrySet()) {
            String gene = (String)entry.getKey();
            this.pw.println(gene + "\t" + entry.getValue() + "\t" + geneToCarrier.get(gene) + "\t" + (double)((Integer)entry.getValue()).intValue() / (double)this.nrOfSamples + "\t" + (double)((Integer)geneToCarrier.get(gene)).intValue() / (double)this.nrOfSamples);
        }
        this.pw.flush();
        this.pw.close();
    }
}

