/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.annotation.makervcf.util;

import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.molgenis.calibratecadd.support.GavinUtils;
import org.molgenis.data.annotation.core.entity.impl.gavin.Judgment;
import org.molgenis.data.annotation.makervcf.structs.AnnotatedVcfRecord;
import org.molgenis.data.annotation.makervcf.structs.GavinRecord;
import org.molgenis.data.vcf.utils.FixVcfAlleleNotation;
import org.molgenis.vcf.VcfReader;
import org.molgenis.vcf.VcfRecord;
import org.molgenis.vcf.VcfRecordUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportedPathogenic {
    private static final Logger LOG = LoggerFactory.getLogger(ReportedPathogenic.class);
    private Map<String, AnnotatedVcfRecord> posRefAltToRepPatho;

    public ReportedPathogenic(File repPathoFile) throws Exception {
        VcfReader repPatho = GavinUtils.getVcfReader(repPathoFile);
        Iterator<VcfRecord> cvIt = repPatho.iterator();
        this.posRefAltToRepPatho = new HashMap<String, AnnotatedVcfRecord>();
        while (cvIt.hasNext()) {
            AnnotatedVcfRecord record = new AnnotatedVcfRecord(cvIt.next());
            for (String alt : VcfRecordUtils.getAlts(record)) {
                String trimmedRefAlt = FixVcfAlleleNotation.backTrimRefAlt(VcfRecordUtils.getRef(record), alt, "_");
                String key = record.getChromosome() + "_" + record.getPosition() + "_" + trimmedRefAlt;
                this.posRefAltToRepPatho.put(key, record);
            }
        }
    }

    public Judgment classifyVariant(GavinRecord record, String alt, String gene) throws Exception {
        Optional<String> repPatho;
        String trimmedRefAlt = FixVcfAlleleNotation.backTrimRefAlt(record.getRef(), alt, "_");
        String key = record.getChromosome() + "_" + record.getPosition() + "_" + trimmedRefAlt;
        if (this.posRefAltToRepPatho.containsKey(key) && (repPatho = this.posRefAltToRepPatho.get(key).getReportedPathogenic()).isPresent()) {
            String repPathoInfo = repPatho.get();
            String MTgene = this.getMTgene(repPathoInfo);
            return new Judgment(Judgment.Classification.Pathogenic, Judgment.Method.genomewide, MTgene, repPathoInfo, "GAVIN+RepPatho", "Reported pathogenic");
        }
        return null;
    }

    public String getMTgene(String repPathoInfo) {
        Matcher m = Pattern.compile(".+\\|(MT\\-.+?)\\|.+").matcher(repPathoInfo);
        if (m.matches()) {
            return m.group(1);
        }
        return "MT-undefined";
    }
}

