/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.annotation.makervcf.genestream.impl;

import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.molgenis.calibratecadd.support.GavinUtils;
import org.molgenis.data.annotation.makervcf.genestream.core.GeneStream;
import org.molgenis.data.annotation.makervcf.structs.GavinRecord;
import org.molgenis.data.annotation.makervcf.structs.Relevance;
import org.molgenis.data.annotation.makervcf.structs.TrioData;
import org.molgenis.data.vcf.datastructures.Trio;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrioFilter
extends GeneStream {
    private static final Logger LOG = LoggerFactory.getLogger(TrioFilter.class);
    private Map<String, Trio> trios;
    private Set<String> parents;

    public TrioFilter(Iterator<GavinRecord> relevantVariants, TrioData td) {
        super(relevantVariants);
        this.trios = td.getTrios();
        this.parents = td.getParents();
        LOG.debug("[TrioFilter] Trios: {}", (Object)this.trios);
        LOG.debug("[TrioFilter] Parents: {}", (Object)this.parents);
    }

    public static TrioData getTrioData(File inputVcfFile) throws Exception {
        Scanner scanner = GavinUtils.createVcfFileScanner(inputVcfFile);
        Map<String, Trio> trios = GavinUtils.getPedigree(scanner);
        HashSet<String> parents = new HashSet<String>();
        for (String child : trios.keySet()) {
            String dadId;
            String momId = trios.get(child).getMother() != null ? trios.get(child).getMother().getId() : null;
            String string = dadId = trios.get(child).getFather() != null ? trios.get(child).getFather().getId() : null;
            if (momId != null) {
                parents.add(momId);
            }
            if (dadId == null) continue;
            parents.add(dadId);
        }
        for (String child : trios.keySet()) {
            if (!parents.contains(child)) continue;
            throw new Exception("Trio child '" + child + "' is also a parent. Complex pedigrees currently not supported.");
        }
        return new TrioData(trios, parents);
    }

    @Override
    public void perGene(String gene, List<GavinRecord> variantsPerGene) throws Exception {
        LOG.debug("[TrioFilter] Encountered gene: {}", (Object)gene);
        for (GavinRecord gavinRecord : variantsPerGene) {
            if (!gavinRecord.isRelevant()) continue;
            for (Relevance rlv : gavinRecord.getRelevance()) {
                if (!rlv.getGene().equals(gene)) continue;
                LOG.debug("[TrioFilter] Encountered variant: {}", (Object)rlv);
                HashSet<String> samplesToRemove = new HashSet<String>();
                char affectedIndex = Character.forDigit(gavinRecord.getAltIndex(rlv.getAllele()), 10);
                for (String sample : rlv.getSampleStatus().keySet()) {
                    LOG.debug("[TrioFilter] Encountered sample: {}", (Object)sample);
                    boolean isParent = this.parents.contains(sample);
                    if (isParent) {
                        LOG.debug("[TrioFilter] Sample is parent! dropping");
                        samplesToRemove.add(sample);
                        continue;
                    }
                    if (this.trios.containsKey(sample)) {
                        String childGeno = rlv.getSampleGenotypes().get(sample);
                        String momId = this.trios.get(sample).getMother() != null ? this.trios.get(sample).getMother().getId() : null;
                        String motherGeno = rlv.getSampleGenotypes().get(momId);
                        String dadId = this.trios.get(sample).getFather() != null ? this.trios.get(sample).getFather().getId() : null;
                        String fatherGeno = rlv.getSampleGenotypes().get(dadId);
                        boolean childHomoOrHemizygous = childGeno.equals(affectedIndex + "/" + affectedIndex) || childGeno.equals(affectedIndex + "|" + affectedIndex) || childGeno.equals(affectedIndex + "");
                        boolean childHeterozygous = childGeno.length() == 3 && StringUtils.countMatches(childGeno, affectedIndex + "") == 1;
                        boolean fatherHomoOrHemizygous = false;
                        boolean fatherHeterozygous = false;
                        if (fatherGeno != null) {
                            fatherHomoOrHemizygous = fatherGeno.equals(affectedIndex + "/" + affectedIndex) || fatherGeno.equals(affectedIndex + "|" + affectedIndex) || fatherGeno.equals(affectedIndex + "");
                            fatherHeterozygous = fatherGeno.length() == 3 && StringUtils.countMatches(fatherGeno, affectedIndex + "") == 1;
                        }
                        boolean fatherReference = rlv.getParentsWithReferenceCalls().contains(dadId);
                        boolean motherHomoOrHemizygous = false;
                        boolean motherHeterozygous = false;
                        if (motherGeno != null) {
                            motherHomoOrHemizygous = motherGeno.equals(affectedIndex + "/" + affectedIndex) || motherGeno.equals(affectedIndex + "|" + affectedIndex) || motherGeno.equals(affectedIndex + "");
                            motherHeterozygous = motherGeno.length() == 3 && StringUtils.countMatches(motherGeno, affectedIndex + "") == 1;
                        }
                        boolean motherReference = rlv.getParentsWithReferenceCalls().contains(momId);
                        LOG.debug("[TrioFilter] Child {} has genotype {} mom: {}, dad: {}", sample, childGeno, motherReference ? "REFERENCE" : motherGeno, fatherReference ? "REFERENCE" : fatherGeno);
                        if (childHomoOrHemizygous && (fatherHomoOrHemizygous || motherHomoOrHemizygous)) {
                            LOG.debug("[TrioFilter] Child {} homozygous genotype {} with at least 1 homozygous parent, mom: {}, dad: {}", sample, childGeno, motherGeno, fatherGeno);
                            samplesToRemove.add(sample);
                            continue;
                        }
                        if (childHeterozygous && (fatherHeterozygous || motherHeterozygous || fatherHomoOrHemizygous || motherHomoOrHemizygous)) {
                            LOG.debug("[TrioFilter] Child {} heterozygous genotype {} with at least 1 heterozygous parent, mom: {}, dad: {}", sample, childGeno, motherGeno, fatherGeno);
                            samplesToRemove.add(sample);
                            continue;
                        }
                        if (childHomoOrHemizygous && (motherHeterozygous && fatherHeterozygous || motherHeterozygous && fatherGeno == null || motherGeno == null && fatherHeterozygous) || childHeterozygous && (fatherGeno == null && motherReference || motherGeno == null && fatherReference) || fatherGeno == null && motherGeno == null) continue;
                        if (childHomoOrHemizygous && (motherHeterozygous && fatherReference || fatherHeterozygous && motherReference || fatherReference && motherReference)) {
                            LOG.debug("[TrioFilter] De novo homozygous variant for child {} heterozygous genotype {}, mom: {}, dad: {}", sample, childGeno, motherReference ? "REFERENCE" : motherGeno, fatherReference ? "REFERENCE" : fatherGeno);
                            continue;
                        }
                        if (childHeterozygous && fatherReference && motherReference) {
                            LOG.debug("[TrioFilter] De novo heterozygous variant for child {} heterozygous genotype {}, mom: {}, dad: {}", sample, childGeno, motherReference ? "REFERENCE" : motherGeno, fatherReference ? "REFERENCE" : fatherGeno);
                            continue;
                        }
                        System.out.println("[TrioFilter] WARNING: Unexpected genotypes, please check: child " + sample + " has genotype " + childGeno + " mom: " + (motherReference ? "REFERENCE" : motherGeno) + ", dad: " + (fatherReference ? "REFERENCE" : fatherGeno));
                        continue;
                    }
                    LOG.debug("[TrioFilter] Sample not part of a trio: {}, ignoring", (Object)sample);
                }
                for (String sample : samplesToRemove) {
                    LOG.debug("[TrioFilter] Removing sample: {}", (Object)sample);
                    rlv.getSampleStatus().remove(sample);
                    rlv.getSampleGenotypes().remove(sample);
                }
            }
        }
    }
}

