/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.annotation.makervcf.genestream.impl;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import org.molgenis.data.annotation.makervcf.genestream.core.GeneStream;
import org.molgenis.data.annotation.makervcf.structs.GavinRecord;
import org.molgenis.data.annotation.makervcf.structs.Relevance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddGeneFDR
extends GeneStream {
    private static final Logger LOG = LoggerFactory.getLogger(AddGeneFDR.class);
    private Map<String, Double> affectedFrac = new HashMap<String, Double>();
    private Map<String, Double> carrierFrac = new HashMap<String, Double>();

    public AddGeneFDR(Iterator<GavinRecord> relevantVariants, File fdrFile) throws FileNotFoundException {
        super(relevantVariants);
        try (Scanner s = new Scanner(fdrFile);){
            s.nextLine();
            while (s.hasNextLine()) {
                String[] split = s.nextLine().split("\t", -1);
                this.affectedFrac.put(split[0], Double.parseDouble(split[3]));
                this.carrierFrac.put(split[0], Double.parseDouble(split[4]));
            }
        }
    }

    @Override
    public void perGene(String gene, List<GavinRecord> gavinRecords) {
        Double affectedFracForGene = this.affectedFrac.get(gene);
        Double carrierFracForGene = this.carrierFrac.get(gene);
        for (GavinRecord gavinRecord : gavinRecords) {
            if (!gavinRecord.isRelevant()) continue;
            for (Relevance rlv : gavinRecord.getRelevance()) {
                if (!rlv.getGene().equals(gene)) continue;
                String fdrInfo = affectedFracForGene + "," + carrierFracForGene;
                rlv.setFDR(fdrInfo);
                LOG.debug("[AddGeneFDR] Added FDR info '{}' to a variant for gene {}", (Object)fdrInfo, (Object)gene);
            }
        }
    }
}

