/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.annotation.makervcf;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import joptsimple.internal.Strings;
import org.molgenis.data.annotation.makervcf.structs.RVCF;
import org.molgenis.data.annotation.makervcf.structs.RVCFUtils;
import org.molgenis.data.annotation.makervcf.structs.Relevance;

public class RlvInfoMapper {
    private String infoField;

    public String map(List<Relevance> relevanceList, boolean splitRlvField) {
        if (!relevanceList.isEmpty()) {
            ArrayList<Object> rvcfList = new ArrayList<Object>();
            for (Relevance relevance : relevanceList) {
                Object rvcf = new RVCF();
                ((RVCF)rvcf).setGene(relevance.getGene());
                ((RVCF)rvcf).setFDR(relevance.getFDR());
                ((RVCF)rvcf).setAllele(relevance.getAllele());
                ((RVCF)rvcf).setAlleleFreq(String.valueOf(relevance.getAlleleFreq()));
                Optional<String> optional = relevance.getTranscript();
                ((RVCF)rvcf).setTranscript(optional.orElse(""));
                if (relevance.getCgdInfo() != null) {
                    ((RVCF)rvcf).setPhenotype(relevance.getCgdInfo().getCondition());
                    ((RVCF)rvcf).setPhenotypeInheritance(relevance.getCgdInfo().getGeneralizedInheritance().toString());
                    ((RVCF)rvcf).setPhenotypeOnset(relevance.getCgdInfo().getAge_group());
                    ((RVCF)rvcf).setPhenotypeDetails(relevance.getCgdInfo().getComments());
                    ((RVCF)rvcf).setPhenotypeGroup(null);
                }
                ((RVCF)rvcf).setVariantSignificance(relevance.getJudgment().getType());
                ((RVCF)rvcf).setVariantSignificanceSource(relevance.getJudgment().getSource());
                ((RVCF)rvcf).setVariantSignificanceJustification(relevance.getJudgment().getReason());
                ((RVCF)rvcf).setVariantMultiGenic(null);
                ((RVCF)rvcf).setVariantGroup(null);
                ((RVCF)rvcf).setSampleStatus(relevance.getSampleStatus());
                ((RVCF)rvcf).setSampleGenotype(relevance.getSampleGenotypes());
                ((RVCF)rvcf).setSamplePhenotype(null);
                ((RVCF)rvcf).setSampleGroup(null);
                rvcfList.add(rvcf);
            }
            if (splitRlvField) {
                Map<String, String> rvcfValues = new HashMap<String, String>();
                for (Object rvcf : rvcfList) {
                    rvcfValues = RVCFUtils.createRvcfValues((RVCF)rvcf, rvcfValues);
                }
                ArrayList<String> arrayList = new ArrayList<String>();
                for (Map.Entry entry : rvcfValues.entrySet()) {
                    arrayList.add((String)entry.getKey() + "=" + (String)entry.getValue());
                }
                this.infoField = Strings.join(arrayList, ";");
            } else {
                ArrayList<String> rvcfStringList = new ArrayList<String>();
                for (Object rvcf : rvcfList) {
                    rvcfStringList.add(RVCFUtils.getMergedFieldVcfString((RVCF)rvcf));
                }
                this.infoField = "RLV=" + Strings.join(rvcfStringList, ",");
            }
        } else {
            this.infoField = splitRlvField ? "RLV_PRESENT=FALSE" : "RLV=.";
        }
        return this.infoField;
    }
}

