/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.annotation.makervcf;

import java.io.File;
import java.util.Iterator;
import org.molgenis.data.annotation.makervcf.WriteToRVCF;
import org.molgenis.data.annotation.makervcf.genestream.core.ConvertBackToPositionalStream;
import org.molgenis.data.annotation.makervcf.genestream.core.ConvertToGeneStream;
import org.molgenis.data.annotation.makervcf.genestream.impl.AddGeneFDR;
import org.molgenis.data.annotation.makervcf.genestream.impl.AssignCompoundHet;
import org.molgenis.data.annotation.makervcf.genestream.impl.PhasingCompoundCheck;
import org.molgenis.data.annotation.makervcf.genestream.impl.TrioFilter;
import org.molgenis.data.annotation.makervcf.positionalstream.CleanupVariantsWithoutSamples;
import org.molgenis.data.annotation.makervcf.positionalstream.DiscoverRelevantVariants;
import org.molgenis.data.annotation.makervcf.positionalstream.MAFFilter;
import org.molgenis.data.annotation.makervcf.positionalstream.MatchVariantsToGenotypeAndInheritance;
import org.molgenis.data.annotation.makervcf.structs.GavinRecord;
import org.molgenis.data.annotation.makervcf.structs.TrioData;
import org.molgenis.data.annotation.makervcf.util.HandleMissingCaddScores;

public class Pipeline {
    private final String version;
    private final String cmdString;
    private final boolean splitRlvField;
    private final boolean keepAllVariants;
    private final HandleMissingCaddScores.Mode mode;
    private final File inputVcfFile;
    private final File gavinFile;
    private final File clinvarFile;
    private final File cgdFile;
    private final File caddFile;
    private final File FDRfile;
    private final File outputVcfFile;
    private final File labVariants;
    private final boolean includeSamples;

    public Pipeline(String version, String cmdString, boolean splitRlvField, boolean keepAllVariants, HandleMissingCaddScores.Mode mode, File inputVcfFile, File gavinFile, File clinvarFile, File cgdFile, File caddFile, File FDRfile, File outputVcfFile, File labVariants, boolean includeSamples) {
        this.version = version;
        this.cmdString = cmdString;
        this.splitRlvField = splitRlvField;
        this.keepAllVariants = keepAllVariants;
        this.mode = mode;
        this.inputVcfFile = inputVcfFile;
        this.gavinFile = gavinFile;
        this.clinvarFile = clinvarFile;
        this.cgdFile = cgdFile;
        this.caddFile = caddFile;
        this.FDRfile = FDRfile;
        this.outputVcfFile = outputVcfFile;
        this.labVariants = labVariants;
        this.includeSamples = includeSamples;
    }

    public void start() throws Exception {
        TrioData td = TrioFilter.getTrioData(this.inputVcfFile);
        DiscoverRelevantVariants discover = new DiscoverRelevantVariants(this.inputVcfFile, this.gavinFile, this.clinvarFile, this.caddFile, this.labVariants, this.mode, this.keepAllVariants);
        Iterator<GavinRecord> rv1 = discover.findRelevantVariants();
        Iterator<GavinRecord> rv2 = new MAFFilter(rv1, this.keepAllVariants).go();
        Iterator<GavinRecord> rv3 = new MatchVariantsToGenotypeAndInheritance(rv2, this.cgdFile, td.getParents()).go();
        ConvertToGeneStream gs = new ConvertToGeneStream(rv3);
        Iterator<GavinRecord> gsi = gs.go();
        Iterator<GavinRecord> rv4 = new AssignCompoundHet(gsi).go();
        TrioFilter tf = new TrioFilter(rv4, td);
        Iterator<GavinRecord> rv5 = tf.go();
        Iterator<GavinRecord> rv6 = new PhasingCompoundCheck(rv5).go();
        Iterator<GavinRecord> rv8 = new AddGeneFDR(rv6, this.FDRfile).go();
        Iterator<GavinRecord> rv9 = new ConvertBackToPositionalStream(rv8, gs.getPositionalOrder()).go();
        Iterator<GavinRecord> rv10 = new CleanupVariantsWithoutSamples(rv9, this.keepAllVariants).go();
        new WriteToRVCF().writeRVCF(rv10, this.outputVcfFile, this.inputVcfFile, this.version, this.cmdString, true, this.splitRlvField, this.includeSamples);
    }
}

