/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.io;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Scanner;
import java.util.Stack;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import net.sf.picard.PicardException;
import net.sf.picard.io.CustomGzipOutputStream;
import net.sf.picard.util.IterableOnceIterator;
import net.sf.samtools.Defaults;
import net.sf.samtools.util.CloserUtil;
import net.sf.samtools.util.CollectionUtil;
import net.sf.samtools.util.IOUtil;
import net.sf.samtools.util.Md5CalculatingOutputStream;
import net.sf.samtools.util.RuntimeIOException;
import org.apache.tools.bzip2.CBZip2InputStream;
import org.apache.tools.bzip2.CBZip2OutputStream;

public class IoUtil
extends IOUtil {
    public static void assertFileIsReadable(File file) {
        if (file == null) {
            throw new IllegalArgumentException("Cannot check readability of null file.");
        }
        if (!file.exists()) {
            throw new PicardException("Cannot read non-existent file: " + file.getAbsolutePath());
        }
        if (file.isDirectory()) {
            throw new PicardException("Cannot read file because it is a directory: " + file.getAbsolutePath());
        }
        if (!file.canRead()) {
            throw new PicardException("File exists but is not readable: " + file.getAbsolutePath());
        }
    }

    public static void assertFileIsWritable(File file) {
        if (file == null) {
            throw new IllegalArgumentException("Cannot check readability of null file.");
        }
        if (!file.exists()) {
            File file2 = file.getAbsoluteFile().getParentFile();
            if (!file2.exists()) {
                throw new PicardException("Cannot write file: " + file.getAbsolutePath() + ". " + "Neither file nor parent directory exist.");
            }
            if (!file2.isDirectory()) {
                throw new PicardException("Cannot write file: " + file.getAbsolutePath() + ". " + "File does not exist and parent is not a directory.");
            }
            if (!file2.canWrite()) {
                throw new PicardException("Cannot write file: " + file.getAbsolutePath() + ". " + "File does not exist and parent directory is not writable..");
            }
        } else {
            if (file.isDirectory()) {
                throw new PicardException("Cannot write file because it is a directory: " + file.getAbsolutePath());
            }
            if (!file.canWrite()) {
                throw new PicardException("File exists but is not writable: " + file.getAbsolutePath());
            }
        }
    }

    public static void assertDirectoryIsWritable(File file) {
        if (file == null) {
            throw new IllegalArgumentException("Cannot check readability of null file.");
        }
        if (!file.exists()) {
            throw new PicardException("Directory does not exist: " + file.getAbsolutePath());
        }
        if (!file.isDirectory()) {
            throw new PicardException("Cannot write to directory because it is not a directory: " + file.getAbsolutePath());
        }
        if (!file.canWrite()) {
            throw new PicardException("Directory exists but is not writable: " + file.getAbsolutePath());
        }
    }

    public static void assertDirectoryIsReadable(File file) {
        if (file == null) {
            throw new IllegalArgumentException("Cannot check readability of null file.");
        }
        if (!file.exists()) {
            throw new PicardException("Directory does not exist: " + file.getAbsolutePath());
        }
        if (!file.isDirectory()) {
            throw new PicardException("Cannot read from directory because it is not a directory: " + file.getAbsolutePath());
        }
        if (!file.canRead()) {
            throw new PicardException("Directory exists but is not readable: " + file.getAbsolutePath());
        }
    }

    public static void assertFilesEqual(File file, File file2) {
        try {
            int n;
            if (file.length() != file2.length()) {
                throw new PicardException("Files " + file + " and " + file2 + " are different lengths.");
            }
            FileInputStream fileInputStream = new FileInputStream(file);
            FileInputStream fileInputStream2 = new FileInputStream(file2);
            byte[] byArray = new byte[0x100000];
            byte[] byArray2 = new byte[0x100000];
            while ((n = fileInputStream.read(byArray)) != -1) {
                int n2 = fileInputStream2.read(byArray2);
                if (n != n2) {
                    throw new PicardException("Unexpected EOF comparing files that are supposed to be the same length.");
                }
                if (Arrays.equals(byArray, byArray2)) continue;
                throw new PicardException("Files " + file + " and " + file2 + " differ.");
            }
            fileInputStream.close();
            fileInputStream2.close();
        }
        catch (IOException iOException) {
            throw new PicardException("Exception comparing files " + file + " and " + file2, iOException);
        }
    }

    public static void assertFileSizeNonZero(File file) {
        if (file.length() == 0L) {
            throw new PicardException(file.getAbsolutePath() + " has length 0");
        }
    }

    public static InputStream openFileForReading(File file) {
        try {
            if (file.getName().endsWith(".bz2")) {
                return IoUtil.openBzipFileForReading(file);
            }
            if (file.getName().endsWith(".gz") || file.getName().endsWith(".bfq")) {
                return IoUtil.openGzipFileForReading(file);
            }
            return new FileInputStream(file);
        }
        catch (IOException iOException) {
            throw new PicardException("Error opening file: " + file.getName(), iOException);
        }
    }

    public static InputStream openGzipFileForReading(File file) {
        try {
            return new GZIPInputStream(new FileInputStream(file));
        }
        catch (IOException iOException) {
            throw new PicardException("Error opening file: " + file.getName(), iOException);
        }
    }

    public static InputStream openBzipFileForReading(File file) {
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            if (fileInputStream.read() != 66 || fileInputStream.read() != 90) {
                fileInputStream.close();
                throw new PicardException(file.getAbsolutePath() + " is not a BZIP file.");
            }
            return new CBZip2InputStream(fileInputStream);
        }
        catch (IOException iOException) {
            throw new PicardException("Error opening file: " + file.getName(), iOException);
        }
    }

    public static OutputStream openFileForWriting(File file) {
        return IoUtil.openFileForWriting(file, false);
    }

    public static OutputStream openFileForWriting(File file, boolean bl) {
        try {
            if (file.getName().endsWith(".bz2")) {
                return IoUtil.openBzipFileForWriting(file, bl);
            }
            if (file.getName().endsWith(".gz") || file.getName().endsWith(".bfq")) {
                return IoUtil.openGzipFileForWriting(file, bl);
            }
            return new FileOutputStream(file, bl);
        }
        catch (IOException iOException) {
            throw new PicardException("Error opening file for writing: " + file.getName(), iOException);
        }
    }

    public static BufferedWriter openFileForBufferedWriting(File file, boolean bl) {
        return new BufferedWriter(new OutputStreamWriter(IoUtil.openFileForWriting(file, bl)), Defaults.BUFFER_SIZE);
    }

    public static BufferedWriter openFileForBufferedWriting(File file) {
        return IoUtil.openFileForBufferedWriting(file, false);
    }

    public static BufferedWriter openFileForBufferedUtf8Writing(File file) {
        return new BufferedWriter(new OutputStreamWriter(IoUtil.openFileForWriting(file), Charset.forName("UTF-8")), Defaults.BUFFER_SIZE);
    }

    public static BufferedReader openFileForBufferedUtf8Reading(File file) {
        return new BufferedReader(new InputStreamReader(IoUtil.openFileForReading(file), Charset.forName("UTF-8")));
    }

    public static OutputStream openGzipFileForWriting(File file, boolean bl) {
        try {
            return new CustomGzipOutputStream((OutputStream)new FileOutputStream(file, bl), Defaults.BUFFER_SIZE, Defaults.COMPRESSION_LEVEL);
        }
        catch (IOException iOException) {
            throw new PicardException("Error opening file for writing: " + file.getName(), iOException);
        }
    }

    public static OutputStream openBzipFileForWriting(File file, boolean bl) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file, bl);
            fileOutputStream.write(66);
            fileOutputStream.write(90);
            return new BufferedOutputStream(new CBZip2OutputStream(fileOutputStream), Defaults.BUFFER_SIZE);
        }
        catch (IOException iOException) {
            throw new PicardException("Error opening file for writing: " + file.getName(), iOException);
        }
    }

    public static OutputStream openFileForMd5CalculatingWriting(File file) {
        return new Md5CalculatingOutputStream(IoUtil.openFileForWriting(file), new File(file.getAbsolutePath() + ".md5"));
    }

    public static void copyStream(InputStream inputStream, OutputStream outputStream) {
        try {
            byte[] byArray = new byte[Defaults.BUFFER_SIZE];
            int n = 0;
            while ((n = inputStream.read(byArray)) > 0) {
                outputStream.write(byArray, 0, n);
            }
        }
        catch (IOException iOException) {
            throw new PicardException("Exception copying stream", iOException);
        }
    }

    public static void copyFile(File file, File file2) {
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            IoUtil.copyStream(fileInputStream, fileOutputStream);
            ((OutputStream)fileOutputStream).close();
            ((InputStream)fileInputStream).close();
        }
        catch (IOException iOException) {
            throw new PicardException("Error copying " + file + " to " + file2, iOException);
        }
    }

    public static File[] getFilesMatchingRegexp(File file, String string) {
        Pattern pattern = Pattern.compile(string);
        return IoUtil.getFilesMatchingRegexp(file, pattern);
    }

    public static File[] getFilesMatchingRegexp(File file, final Pattern pattern) {
        return file.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                return pattern.matcher(string).matches();
            }
        });
    }

    public static boolean deleteDirectoryTree(File file) {
        boolean bl = true;
        if (file.isDirectory()) {
            for (File file2 : file.listFiles()) {
                bl = bl && IoUtil.deleteDirectoryTree(file2);
            }
        }
        bl = bl && file.delete();
        return bl;
    }

    public static long sizeOfTree(File file) {
        long l = file.length();
        if (file.isDirectory()) {
            for (File file2 : file.listFiles()) {
                l += IoUtil.sizeOfTree(file2);
            }
        }
        return l;
    }

    public static void copyDirectoryTree(File file, File file2) {
        if (file.isDirectory()) {
            file2.mkdir();
            for (File file3 : file.listFiles()) {
                File file4 = new File(file2.getPath(), file3.getName());
                if (file3.isDirectory()) {
                    IoUtil.copyDirectoryTree(file3, file4);
                    continue;
                }
                IoUtil.copyFile(file3, file4);
            }
        }
    }

    public static File createTempDir(String string, String string2) {
        try {
            File file = File.createTempFile(string, string2);
            if (!file.delete()) {
                throw new PicardException("Could not delete temporary file " + file);
            }
            if (!file.mkdir()) {
                throw new PicardException("Could not create temporary directory " + file);
            }
            return file;
        }
        catch (IOException iOException) {
            throw new PicardException("Exception creating temporary directory.", iOException);
        }
    }

    public static BufferedReader openFileForBufferedReading(File file) throws IOException {
        return new BufferedReader(new InputStreamReader(IoUtil.openFileForReading(file)), Defaults.BUFFER_SIZE);
    }

    public static String makeFileNameSafe(String string) {
        return string.trim().replaceAll("[\\s!\"#$%&'()*/:;<=>?@\\[\\]\\\\^`{|}~]", "_");
    }

    public static String basename(File file) {
        String string = file.getName();
        int n = string.lastIndexOf(".");
        if (n > 0 && n > string.lastIndexOf(File.separator)) {
            return string.substring(0, n);
        }
        return string;
    }

    public static String fileSuffix(File file) {
        String string = file.getName();
        int n = string.lastIndexOf(".");
        if (n > 0 && n > string.lastIndexOf(File.separator)) {
            return string.substring(n);
        }
        return null;
    }

    public static String getFullCanonicalPath(File file) {
        try {
            File file2 = file.getCanonicalFile();
            String string = "";
            while (file2 != null && !file2.getName().equals("")) {
                string = "/" + file2.getName() + string;
                if ((file2 = file2.getParentFile()) == null) continue;
                file2 = file2.getCanonicalFile();
            }
            return string;
        }
        catch (IOException iOException) {
            throw new RuntimeException("Error getting full canonical path for " + file + ": " + iOException.getMessage(), iOException);
        }
    }

    public static String readFully(InputStream inputStream) {
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream), Defaults.BUFFER_SIZE);
            StringBuilder stringBuilder = new StringBuilder(512);
            String string = null;
            while ((string = bufferedReader.readLine()) != null) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append('\n');
                }
                stringBuilder.append(string);
            }
            return stringBuilder.toString();
        }
        catch (IOException iOException) {
            throw new RuntimeIOException("Error reading stream", iOException);
        }
    }

    public static IterableOnceIterator<String> readLines(File file) {
        try {
            final BufferedReader bufferedReader = IoUtil.openFileForBufferedReading(file);
            return new IterableOnceIterator<String>(){
                private String next;
                {
                    this.next = bufferedReader.readLine();
                }

                @Override
                public boolean hasNext() {
                    return this.next != null;
                }

                @Override
                public String next() {
                    try {
                        String string = this.next;
                        this.next = bufferedReader.readLine();
                        if (this.next == null) {
                            bufferedReader.close();
                        }
                        return string;
                    }
                    catch (IOException iOException) {
                        throw new RuntimeIOException(iOException);
                    }
                }

                @Override
                public void close() throws IOException {
                    CloserUtil.close(bufferedReader);
                }
            };
        }
        catch (IOException iOException) {
            throw new RuntimeIOException(iOException);
        }
    }

    public static List<String> slurpLines(File file) throws FileNotFoundException {
        return IoUtil.slurpLines(new FileInputStream(file));
    }

    public static List<String> slurpLines(InputStream inputStream) throws FileNotFoundException {
        return IoUtil.tokenSlurp(inputStream, Charset.defaultCharset(), "\r\n|[\n\r\u2028\u2029\u0085]");
    }

    public static String slurp(File file) throws FileNotFoundException {
        return IoUtil.slurp(new FileInputStream(file));
    }

    public static String slurp(InputStream inputStream) {
        return IoUtil.slurp(inputStream, Charset.defaultCharset());
    }

    public static String slurp(InputStream inputStream, Charset charset) {
        List<String> list = IoUtil.tokenSlurp(inputStream, charset, "\\A");
        return list.isEmpty() ? "" : CollectionUtil.getSoleElement(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> tokenSlurp(InputStream inputStream, Charset charset, String string) {
        try {
            Scanner scanner = new Scanner(inputStream, charset.toString()).useDelimiter(string);
            LinkedList<String> linkedList = new LinkedList<String>();
            while (scanner.hasNext()) {
                linkedList.add(scanner.next());
            }
            LinkedList<String> linkedList2 = linkedList;
            return linkedList2;
        }
        finally {
            CloserUtil.close(inputStream);
        }
    }

    public static List<File> unrollFiles(Collection<File> collection, String ... stringArray) {
        if (stringArray.length < 1) {
            throw new IllegalArgumentException("Must provide at least one extension.");
        }
        Stack<File> stack = new Stack<File>();
        ArrayList<File> arrayList = new ArrayList<File>();
        stack.addAll(collection);
        HashSet hashSet = new HashSet();
        Collections.addAll(hashSet, stringArray);
        while (!stack.empty()) {
            File file = (File)stack.pop();
            String string = IoUtil.fileSuffix(file);
            if (hashSet.contains(string)) {
                arrayList.add(file);
                continue;
            }
            IoUtil.assertFileIsReadable(file);
            for (String string2 : IoUtil.readLines(file)) {
                if (string2.trim().isEmpty()) continue;
                stack.push(new File(string2.trim()));
            }
        }
        return arrayList;
    }
}

