// Decompiled by Jad v1.5.8e. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.geocities.com/kpdus/jad.html
// Decompiler options: packimports(3) 
// Source File Name:   Gamma.java

package cern.jet.stat;

import cern.jet.math.Constants;
import cern.jet.math.Polynomial;

public class Gamma extends Constants
{

    protected Gamma()
    {
    }

    public static double beta(double a, double b)
        throws ArithmeticException
    {
        double y = a + b;
        y = gamma(y);
        if(y == 0.0D)
            return 1.0D;
        if(a > b)
        {
            y = gamma(a) / y;
            y *= gamma(b);
        } else
        {
            y = gamma(b) / y;
            y *= gamma(a);
        }
        return y;
    }

    public static double gamma(double x)
        throws ArithmeticException
    {
        double P[] = {
            0.00016011952247675185D, 0.0011913514700658638D, 0.010421379756176158D, 0.047636780045713721D, 0.20744822764843598D, 0.49421482680149709D, 1.0D
        };
        double Q[] = {
            -2.3158187332412014E-05D, 0.00053960558049330335D, -0.0044564191385179728D, 0.011813978522206043D, 0.035823639860549865D, -0.23459179571824335D, 0.071430491703027302D, 1.0D
        };
        double q = Math.abs(x);
        double z;
        if(q > 33D)
            if(x < 0.0D)
            {
                double p = Math.floor(q);
                if(p == q)
                    throw new ArithmeticException("gamma: overflow");
                int i = (int)p;
                z = q - p;
                if(z > 0.5D)
                {
                    p++;
                    z = q - p;
                }
                z = q * Math.sin(3.1415926535897931D * z);
                if(z == 0.0D)
                {
                    throw new ArithmeticException("gamma: overflow");
                } else
                {
                    z = Math.abs(z);
                    z = 3.1415926535897931D / (z * stirlingFormula(q));
                    return -z;
                }
            } else
            {
                return stirlingFormula(x);
            }
        for(z = 1.0D; x >= 3D; z *= x)
            x--;

        for(; x < 0.0D; x++)
        {
            if(x == 0.0D)
                throw new ArithmeticException("gamma: singular");
            if(x > -1.0000000000000001E-09D)
                return z / ((1.0D + 0.57721566490153287D * x) * x);
            z /= x;
        }

        for(; x < 2D; x++)
        {
            if(x == 0.0D)
                throw new ArithmeticException("gamma: singular");
            if(x < 1.0000000000000001E-09D)
                return z / ((1.0D + 0.57721566490153287D * x) * x);
            z /= x;
        }

        if(x == 2D || x == 3D)
        {
            return z;
        } else
        {
            x -= 2D;
            double p = Polynomial.polevl(x, P, 6);
            q = Polynomial.polevl(x, Q, 7);
            return (z * p) / q;
        }
    }

    public static double incompleteBeta(double aa, double bb, double xx)
        throws ArithmeticException
    {
        if(aa <= 0.0D || bb <= 0.0D)
            throw new ArithmeticException("ibeta: Domain error!");
        if(xx <= 0.0D || xx >= 1.0D)
        {
            if(xx == 0.0D)
                return 0.0D;
            if(xx == 1.0D)
                return 1.0D;
            else
                throw new ArithmeticException("ibeta: Domain error!");
        }
        boolean flag = false;
        double t;
        if(bb * xx <= 1.0D && xx <= 0.94999999999999996D)
        {
            t = powerSeries(aa, bb, xx);
            return t;
        }
        double w = 1.0D - xx;
        double a;
        double b;
        double x;
        double xc;
        if(xx > aa / (aa + bb))
        {
            flag = true;
            a = bb;
            b = aa;
            xc = xx;
            x = w;
        } else
        {
            a = aa;
            b = bb;
            xc = w;
            x = xx;
        }
        if(flag && b * x <= 1.0D && x <= 0.94999999999999996D)
        {
            t = powerSeries(a, b, x);
            if(t <= 1.1102230246251565E-16D)
                t = 0.99999999999999989D;
            else
                t = 1.0D - t;
            return t;
        }
        double y = x * ((a + b) - 2D) - (a - 1.0D);
        if(y < 0.0D)
            w = incompleteBetaFraction1(a, b, x);
        else
            w = incompleteBetaFraction2(a, b, x) / xc;
        y = a * Math.log(x);
        t = b * Math.log(xc);
        if(a + b < 171.62437695630271D && Math.abs(y) < 709.78271289338397D && Math.abs(t) < 709.78271289338397D)
        {
            t = Math.pow(xc, b);
            t *= Math.pow(x, a);
            t /= a;
            t *= w;
            t *= gamma(a + b) / (gamma(a) * gamma(b));
            if(flag)
                if(t <= 1.1102230246251565E-16D)
                    t = 0.99999999999999989D;
                else
                    t = 1.0D - t;
            return t;
        }
        y += (t + logGamma(a + b)) - logGamma(a) - logGamma(b);
        y += Math.log(w / a);
        if(y < -745.13321910194122D)
            t = 0.0D;
        else
            t = Math.exp(y);
        if(flag)
            if(t <= 1.1102230246251565E-16D)
                t = 0.99999999999999989D;
            else
                t = 1.0D - t;
        return t;
    }

    static double incompleteBetaFraction1(double a, double b, double x)
        throws ArithmeticException
    {
        double k1 = a;
        double k2 = a + b;
        double k3 = a;
        double k4 = a + 1.0D;
        double k5 = 1.0D;
        double k6 = b - 1.0D;
        double k7 = k4;
        double k8 = a + 2D;
        double pkm2 = 0.0D;
        double qkm2 = 1.0D;
        double pkm1 = 1.0D;
        double qkm1 = 1.0D;
        double ans = 1.0D;
        double r = 1.0D;
        int n = 0;
        double thresh = 3.3306690738754696E-16D;
        do
        {
            double xk = -(x * k1 * k2) / (k3 * k4);
            double pk = pkm1 + pkm2 * xk;
            double qk = qkm1 + qkm2 * xk;
            pkm2 = pkm1;
            pkm1 = pk;
            qkm2 = qkm1;
            qkm1 = qk;
            xk = (x * k5 * k6) / (k7 * k8);
            pk = pkm1 + pkm2 * xk;
            qk = qkm1 + qkm2 * xk;
            pkm2 = pkm1;
            pkm1 = pk;
            qkm2 = qkm1;
            qkm1 = qk;
            if(qk != 0.0D)
                r = pk / qk;
            double t;
            if(r != 0.0D)
            {
                t = Math.abs((ans - r) / r);
                ans = r;
            } else
            {
                t = 1.0D;
            }
            if(t < thresh)
                return ans;
            k1++;
            k2++;
            k3 += 2D;
            k4 += 2D;
            k5++;
            k6--;
            k7 += 2D;
            k8 += 2D;
            if(Math.abs(qk) + Math.abs(pk) > 4503599627370496D)
            {
                pkm2 *= 2.2204460492503131E-16D;
                pkm1 *= 2.2204460492503131E-16D;
                qkm2 *= 2.2204460492503131E-16D;
                qkm1 *= 2.2204460492503131E-16D;
            }
            if(Math.abs(qk) < 2.2204460492503131E-16D || Math.abs(pk) < 2.2204460492503131E-16D)
            {
                pkm2 *= 4503599627370496D;
                pkm1 *= 4503599627370496D;
                qkm2 *= 4503599627370496D;
                qkm1 *= 4503599627370496D;
            }
        } while(++n < 300);
        return ans;
    }

    static double incompleteBetaFraction2(double a, double b, double x)
        throws ArithmeticException
    {
        double k1 = a;
        double k2 = b - 1.0D;
        double k3 = a;
        double k4 = a + 1.0D;
        double k5 = 1.0D;
        double k6 = a + b;
        double k7 = a + 1.0D;
        double k8 = a + 2D;
        double pkm2 = 0.0D;
        double qkm2 = 1.0D;
        double pkm1 = 1.0D;
        double qkm1 = 1.0D;
        double z = x / (1.0D - x);
        double ans = 1.0D;
        double r = 1.0D;
        int n = 0;
        double thresh = 3.3306690738754696E-16D;
        do
        {
            double xk = -(z * k1 * k2) / (k3 * k4);
            double pk = pkm1 + pkm2 * xk;
            double qk = qkm1 + qkm2 * xk;
            pkm2 = pkm1;
            pkm1 = pk;
            qkm2 = qkm1;
            qkm1 = qk;
            xk = (z * k5 * k6) / (k7 * k8);
            pk = pkm1 + pkm2 * xk;
            qk = qkm1 + qkm2 * xk;
            pkm2 = pkm1;
            pkm1 = pk;
            qkm2 = qkm1;
            qkm1 = qk;
            if(qk != 0.0D)
                r = pk / qk;
            double t;
            if(r != 0.0D)
            {
                t = Math.abs((ans - r) / r);
                ans = r;
            } else
            {
                t = 1.0D;
            }
            if(t < thresh)
                return ans;
            k1++;
            k2--;
            k3 += 2D;
            k4 += 2D;
            k5++;
            k6++;
            k7 += 2D;
            k8 += 2D;
            if(Math.abs(qk) + Math.abs(pk) > 4503599627370496D)
            {
                pkm2 *= 2.2204460492503131E-16D;
                pkm1 *= 2.2204460492503131E-16D;
                qkm2 *= 2.2204460492503131E-16D;
                qkm1 *= 2.2204460492503131E-16D;
            }
            if(Math.abs(qk) < 2.2204460492503131E-16D || Math.abs(pk) < 2.2204460492503131E-16D)
            {
                pkm2 *= 4503599627370496D;
                pkm1 *= 4503599627370496D;
                qkm2 *= 4503599627370496D;
                qkm1 *= 4503599627370496D;
            }
        } while(++n < 300);
        return ans;
    }

    public static double incompleteGamma(double a, double x)
        throws ArithmeticException
    {
        if(x <= 0.0D || a <= 0.0D)
            return 0.0D;
        if(x > 1.0D && x > a)
            return 1.0D - incompleteGammaComplement(a, x);
        double ax = a * Math.log(x) - x - logGamma(a);
        if(ax < -709.78271289338397D)
            return 0.0D;
        ax = Math.exp(ax);
        double r = a;
        double c = 1.0D;
        double ans = 1.0D;
        do
        {
            r++;
            c *= x / r;
            ans += c;
        } while(c / ans > 1.1102230246251565E-16D);
        return (ans * ax) / a;
    }

    public static double incompleteGammaComplement(double a, double x)
        throws ArithmeticException
    {
        if(x <= 0.0D || a <= 0.0D)
            return 1.0D;
        if(x < 1.0D || x < a)
            return 1.0D - incompleteGamma(a, x);
        double ax = a * Math.log(x) - x - logGamma(a);
        if(ax < -709.78271289338397D)
            return 0.0D;
        ax = Math.exp(ax);
        double y = 1.0D - a;
        double z = x + y + 1.0D;
        double c = 0.0D;
        double pkm2 = 1.0D;
        double qkm2 = x;
        double pkm1 = x + 1.0D;
        double qkm1 = z * x;
        double ans = pkm1 / qkm1;
        double t;
        do
        {
            c++;
            y++;
            z += 2D;
            double yc = y * c;
            double pk = pkm1 * z - pkm2 * yc;
            double qk = qkm1 * z - qkm2 * yc;
            if(qk != 0.0D)
            {
                double r = pk / qk;
                t = Math.abs((ans - r) / r);
                ans = r;
            } else
            {
                t = 1.0D;
            }
            pkm2 = pkm1;
            pkm1 = pk;
            qkm2 = qkm1;
            qkm1 = qk;
            if(Math.abs(pk) > 4503599627370496D)
            {
                pkm2 *= 2.2204460492503131E-16D;
                pkm1 *= 2.2204460492503131E-16D;
                qkm2 *= 2.2204460492503131E-16D;
                qkm1 *= 2.2204460492503131E-16D;
            }
        } while(t > 1.1102230246251565E-16D);
        return ans * ax;
    }

    public static double logGamma(double x)
        throws ArithmeticException
    {
        double A[] = {
            0.00081161416747050849D, -0.00059506190428430144D, 0.00079365034045771694D, -0.0027777777773009969D, 0.08333333333333319D
        };
        double B[] = {
            -1378.2515256912086D, -38801.631513463784D, -331612.99273887119D, -1162370.9749276231D, -1721737.0082083966D, -853555.66424576542D
        };
        double C[] = {
            -351.81570143652345D, -17064.210665188115D, -220528.59055385445D, -1139334.4436798252D, -2532523.0717758294D, -2018891.4143353277D
        };
        double p;
        double q;
        if(x < -34D)
        {
            q = -x;
            double w = logGamma(q);
            p = Math.floor(q);
            if(p == q)
                throw new ArithmeticException("lgam: Overflow");
            double z = q - p;
            if(z > 0.5D)
            {
                p++;
                z = p - q;
            }
            z = q * Math.sin(3.1415926535897931D * z);
            if(z == 0.0D)
            {
                throw new ArithmeticException("lgamma: Overflow");
            } else
            {
                z = 1.1447298858494002D - Math.log(z) - w;
                return z;
            }
        }
        if(x < 13D)
        {
            double z;
            for(z = 1.0D; x >= 3D; z *= x)
                x--;

            for(; x < 2D; x++)
            {
                if(x == 0.0D)
                    throw new ArithmeticException("lgamma: Overflow");
                z /= x;
            }

            if(z < 0.0D)
                z = -z;
            if(x == 2D)
            {
                return Math.log(z);
            } else
            {
                x -= 2D;
                p = (x * Polynomial.polevl(x, B, 5)) / Polynomial.p1evl(x, C, 6);
                return Math.log(z) + p;
            }
        }
        if(x > 2.5563479999999998E+305D)
            throw new ArithmeticException("lgamma: Overflow");
        q = ((x - 0.5D) * Math.log(x) - x) + 0.91893853320467278D;
        if(x > 100000000D)
            return q;
        p = 1.0D / (x * x);
        if(x >= 1000D)
            q += ((0.00079365079365079365D * p - 0.0027777777777777779D) * p + 0.083333333333333329D) / x;
        else
            q += Polynomial.polevl(p, A, 4) / x;
        return q;
    }

    static double powerSeries(double a, double b, double x)
        throws ArithmeticException
    {
        double ai = 1.0D / a;
        double u = (1.0D - b) * x;
        double v = u / (a + 1.0D);
        double t1 = v;
        double t = u;
        double n = 2D;
        double s = 0.0D;
        for(double z = 1.1102230246251565E-16D * ai; Math.abs(v) > z;)
        {
            u = ((n - b) * x) / n;
            t *= u;
            v = t / (a + n);
            s += v;
            n++;
        }

        s += t1;
        s += ai;
        u = a * Math.log(x);
        if(a + b < 171.62437695630271D && Math.abs(u) < 709.78271289338397D)
        {
            t = gamma(a + b) / (gamma(a) * gamma(b));
            s = s * t * Math.pow(x, a);
        } else
        {
            t = (logGamma(a + b) - logGamma(a) - logGamma(b)) + u + Math.log(s);
            if(t < -745.13321910194122D)
                s = 0.0D;
            else
                s = Math.exp(t);
        }
        return s;
    }

    static double stirlingFormula(double x)
        throws ArithmeticException
    {
        double STIR[] = {
            0.00078731139579309368D, -0.00022954996161337813D, -0.0026813261780578124D, 0.0034722222160545866D, 0.08333333333334822D
        };
        double MAXSTIR = 143.01607999999999D;
        double w = 1.0D / x;
        double y = Math.exp(x);
        w = 1.0D + w * Polynomial.polevl(w, STIR, 4);
        if(x > MAXSTIR)
        {
            double v = Math.pow(x, 0.5D * x - 0.25D);
            y = v * (v / y);
        } else
        {
            y = Math.pow(x, x - 0.5D) / y;
        }
        y = 2.5066282746310007D * y * w;
        return y;
    }
}
