/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.PhysicalBody;
import javax.media.j3d.PhysicalEnvironment;
import javax.media.j3d.Transform3D;
import javax.media.j3d.View;
import javax.media.j3d.ViewPlatform;
import javax.media.j3d.ViewPlatformRetained;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;

class ViewCache {
    View view;
    int viewAttachPolicy;
    Point3d leftEyePosInHead = new Point3d();
    Point3d rightEyePosInHead = new Point3d();
    Point3d leftEarPosInHead = new Point3d();
    Point3d rightEarPosInHead = new Point3d();
    double nominalEyeHeightFromGround;
    double nominalEyeOffsetFromNominalScreen;
    Transform3D headToHeadTracker = new Transform3D();
    Transform3D coexistenceToTrackerBase = new Transform3D();
    Transform3D headTrackerToTrackerBase = new Transform3D();
    Transform3D trackerBaseToHeadTracker = new Transform3D();
    boolean trackingAvailable;
    int headIndex;
    int coexistenceCenterInPworldPolicy;
    boolean compatibilityModeEnable;
    boolean coexistenceCenteringEnable;
    Point3d leftManualEyeInCoexistence = new Point3d();
    Point3d rightManualEyeInCoexistence = new Point3d();
    int viewPolicy;
    int projectionPolicy;
    int screenScalePolicy;
    double screenScale;
    int windowResizePolicy;
    int windowMovementPolicy;
    int windowEyepointPolicy;
    int monoscopicViewPolicy;
    double fieldOfView;
    double frontClipDistance;
    double backClipDistance;
    int frontClipPolicy;
    int backClipPolicy;
    ViewPlatformRetained vpRetained;
    int visibilityPolicy;
    boolean trackingEnable;
    boolean userHeadToVworldEnable;
    Transform3D compatVpcToEc = new Transform3D();
    Transform3D compatLeftProjection = new Transform3D();
    Transform3D compatRightProjection = new Transform3D();
    int vcDirtyMask = 0;
    private boolean doHeadTracking;
    Transform3D userHeadToVworld = new Transform3D();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void snapshot() {
        PhysicalBody physicalBody;
        PhysicalEnvironment physicalEnvironment;
        this.vcDirtyMask = this.view.vDirtyMask;
        this.view.vDirtyMask = 0;
        this.compatibilityModeEnable = this.view.compatibilityModeEnable;
        this.coexistenceCenteringEnable = this.view.coexistenceCenteringEnable;
        this.leftManualEyeInCoexistence.set((Tuple3d)this.view.leftManualEyeInCoexistence);
        this.rightManualEyeInCoexistence.set((Tuple3d)this.view.rightManualEyeInCoexistence);
        this.viewPolicy = this.view.viewPolicy;
        this.projectionPolicy = this.view.projectionPolicy;
        this.screenScalePolicy = this.view.screenScalePolicy;
        this.windowResizePolicy = this.view.windowResizePolicy;
        this.windowMovementPolicy = this.view.windowMovementPolicy;
        this.windowEyepointPolicy = this.view.windowEyepointPolicy;
        this.monoscopicViewPolicy = this.view.monoscopicViewPolicy;
        this.fieldOfView = this.view.fieldOfView;
        this.screenScale = this.view.screenScale;
        this.frontClipDistance = this.view.frontClipDistance;
        this.backClipDistance = this.view.backClipDistance;
        this.frontClipPolicy = this.view.frontClipPolicy;
        this.backClipPolicy = this.view.backClipPolicy;
        this.visibilityPolicy = this.view.visibilityPolicy;
        this.trackingEnable = this.view.trackingEnable;
        this.userHeadToVworldEnable = this.view.userHeadToVworldEnable;
        this.view.compatVpcToEc.getWithLock(this.compatVpcToEc);
        this.view.compatLeftProjection.getWithLock(this.compatLeftProjection);
        this.view.compatRightProjection.getWithLock(this.compatRightProjection);
        ViewPlatform viewPlatform = this.view.getViewPlatform();
        if (viewPlatform == null) {
            return;
        }
        ViewPlatformRetained viewPlatformRetained = this.vpRetained = (ViewPlatformRetained)viewPlatform.retained;
        synchronized (viewPlatformRetained) {
            this.vcDirtyMask |= this.vpRetained.vprDirtyMask;
            this.vpRetained.vprDirtyMask = 0;
            this.viewAttachPolicy = this.vpRetained.viewAttachPolicy;
        }
        PhysicalEnvironment physicalEnvironment2 = physicalEnvironment = this.view.getPhysicalEnvironment();
        synchronized (physicalEnvironment2) {
            this.vcDirtyMask |= physicalEnvironment.peDirtyMask;
            physicalEnvironment.peDirtyMask = 0;
            physicalEnvironment.coexistenceToTrackerBase.getWithLock(this.coexistenceToTrackerBase);
            this.trackingAvailable = physicalEnvironment.trackingAvailable;
            this.coexistenceCenterInPworldPolicy = physicalEnvironment.coexistenceCenterInPworldPolicy;
            boolean bl = this.doHeadTracking = this.trackingEnable && this.trackingAvailable;
            if (this.doHeadTracking) {
                this.headIndex = physicalEnvironment.getHeadIndex();
                physicalEnvironment.getSensor(this.headIndex).getRead(this.headTrackerToTrackerBase);
                this.vcDirtyMask |= 0x800;
            } else {
                this.headTrackerToTrackerBase.setIdentity();
            }
        }
        PhysicalBody physicalBody2 = physicalBody = this.view.getPhysicalBody();
        synchronized (physicalBody2) {
            this.vcDirtyMask |= physicalBody.pbDirtyMask;
            physicalBody.pbDirtyMask = 0;
            this.leftEyePosInHead.set((Tuple3d)physicalBody.leftEyePosition);
            this.rightEyePosInHead.set((Tuple3d)physicalBody.rightEyePosition);
            this.leftEarPosInHead.set((Tuple3d)physicalBody.leftEarPosition);
            this.rightEarPosInHead.set((Tuple3d)physicalBody.rightEarPosition);
            this.nominalEyeHeightFromGround = physicalBody.nominalEyeHeightFromGround;
            this.nominalEyeOffsetFromNominalScreen = physicalBody.nominalEyeOffsetFromNominalScreen;
        }
        physicalBody.headToHeadTracker.getWithLock(this.headToHeadTracker);
    }

    synchronized void computeDerivedData() {
        if (this.doHeadTracking) {
            this.trackerBaseToHeadTracker.invert(this.headTrackerToTrackerBase);
        } else {
            this.trackerBaseToHeadTracker.setIdentity();
        }
        this.userHeadToVworld.setIdentity();
    }

    boolean getDoHeadTracking() {
        return this.doHeadTracking;
    }

    ViewCache(View view) {
        this.view = view;
    }
}

