/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.interpreter.operations;

import java.io.DataInput;
import java.io.IOException;
import java.lang.reflect.Array;
import nl.tudelft.simulation.dsol.interpreter.LocalVariable;
import nl.tudelft.simulation.dsol.interpreter.OperandStack;
import nl.tudelft.simulation.dsol.interpreter.classfile.Constant;
import nl.tudelft.simulation.dsol.interpreter.operations.VoidOperation;

public class NEWARRAY
extends VoidOperation {
    public static final int OP = 188;
    private int atype = -1;

    public NEWARRAY(DataInput dataInput) throws IOException {
        this.atype = dataInput.readUnsignedByte();
    }

    public void execute(OperandStack stack, Constant[] constantPool, LocalVariable[] localVariables) {
        int length = (Integer)stack.pop();
        Class<Comparable<Boolean>> clazz = null;
        switch (this.atype) {
            case 4: {
                clazz = Boolean.TYPE;
                break;
            }
            case 5: {
                clazz = Character.TYPE;
                break;
            }
            case 6: {
                clazz = Float.TYPE;
                break;
            }
            case 7: {
                clazz = Double.TYPE;
                break;
            }
            case 8: {
                clazz = Byte.TYPE;
                break;
            }
            case 9: {
                clazz = Short.TYPE;
                break;
            }
            case 10: {
                clazz = Integer.TYPE;
                break;
            }
            case 11: {
                clazz = Long.TYPE;
                break;
            }
            default: {
                throw new RuntimeException("unknown atype in NEWARRAY");
            }
        }
        Object array = Array.newInstance(clazz, length);
        stack.push(array);
    }

    public int getByteLength() {
        return 2;
    }

    public int getOpcode() {
        return 188;
    }
}

