/*
 * Decompiled with CFR 0.152.
 */
package umcg.genetica.util;

public class SmoothSort {
    static final int[] LP = new int[]{1, 1, 3, 5, 9, 15, 25, 41, 67, 109, 177, 287, 465, 753, 1219, 1973, 3193, 5167, 8361, 13529, 21891, 35421, 57313, 92735, 150049, 242785, 392835, 635621, 1028457, 1664079, 2692537, 4356617, 7049155, 11405773, 0x1199991, 29860703, 48315633, 78176337, 126491971, 204668309, 331160281, 535828591, 866988873};

    public static <C extends Comparable<? super C>> void sort(C[] m) {
        SmoothSort.sortInternaly(m, (int)0, (int)(m.length - 1));
    }

    public static <C extends Comparable<? super C>> void sort(C[] m, int fromIndex, int toIndex) {
        SmoothSort.sortInternaly(m, (int)fromIndex, (int)(toIndex - 1));
    }

    private static <C extends Comparable<? super C>> void sortInternaly(C[] m, int lo, int hi) {
        int head;
        if (hi - lo > 7049156) {
            throw new IllegalArgumentException("Array to big to sort using this method");
        }
        int p = 1;
        int pshift = 1;
        for (head = lo; head < hi; ++head) {
            if ((p & 3) == 3) {
                SmoothSort.sift(m, (int)pshift, (int)head);
                p >>>= 2;
                pshift += 2;
            } else {
                if (LP[pshift - 1] >= hi - head) {
                    SmoothSort.trinkle(m, (int)p, (int)pshift, (int)head, (boolean)false);
                } else {
                    SmoothSort.sift(m, (int)pshift, (int)head);
                }
                if (pshift == 1) {
                    p <<= 1;
                    --pshift;
                } else {
                    p <<= pshift - 1;
                    pshift = 1;
                }
            }
            p |= 1;
        }
        SmoothSort.trinkle(m, (int)p, (int)pshift, (int)head, (boolean)false);
        while (pshift != 1 || p != 1) {
            if (pshift <= 1) {
                int trail = Integer.numberOfTrailingZeros(p & 0xFFFFFFFE);
                p >>>= trail;
                pshift += trail;
            } else {
                p <<= 2;
                SmoothSort.trinkle(m, (int)((p ^= 7) >>> 1), (int)((pshift -= 2) + 1), (int)(head - LP[pshift] - 1), (boolean)true);
                SmoothSort.trinkle(m, (int)p, (int)pshift, (int)(head - 1), (boolean)true);
            }
            --head;
        }
    }

    private static <C extends Comparable<? super C>> void sift(C[] m, int pshift, int head) {
        C val = m[head];
        while (pshift > 1) {
            int rt = head - 1;
            int lf = head - 1 - LP[pshift - 2];
            if (val.compareTo(m[lf]) >= 0 && val.compareTo(m[rt]) >= 0) break;
            if (m[lf].compareTo(m[rt]) >= 0) {
                m[head] = m[lf];
                head = lf;
                --pshift;
                continue;
            }
            m[head] = m[rt];
            head = rt;
            pshift -= 2;
        }
        m[head] = val;
    }

    private static <C extends Comparable<? super C>> void trinkle(C[] m, int p, int pshift, int head, boolean isTrusty) {
        int stepson;
        C val = m[head];
        while (p != 1 && m[stepson = head - LP[pshift]].compareTo(val) > 0) {
            if (!isTrusty && pshift > 1) {
                int rt = head - 1;
                int lf = head - 1 - LP[pshift - 2];
                if (m[rt].compareTo(m[stepson]) >= 0 || m[lf].compareTo(m[stepson]) >= 0) break;
            }
            m[head] = m[stepson];
            head = stepson;
            int trail = Integer.numberOfTrailingZeros(p & 0xFFFFFFFE);
            p >>>= trail;
            pshift += trail;
            isTrusty = false;
        }
        if (!isTrusty) {
            m[head] = val;
            SmoothSort.sift(m, (int)pshift, (int)head);
        }
    }
}

