/*
 * Decompiled with CFR 0.152.
 */
package umcg.genetica.util;

public class RunTimer {
    private long start = System.nanoTime();
    private long prevstart = this.start;
    private Granularity g = null;

    public RunTimer(Granularity g) {
        this.g = g;
    }

    public RunTimer() {
    }

    public String getTimeDesc() {
        long stopTime = System.nanoTime();
        long diff = stopTime - this.start;
        return this.getTimeDesc(diff);
    }

    public void start() {
        this.prevstart = System.nanoTime();
    }

    public String stop() {
        long currtime = System.nanoTime();
        long diff = currtime - this.prevstart;
        return this.getTimeDesc(diff);
    }

    public String getTimeDesc(long timeDiff) {
        String leftTime = "";
        String pastTime = "";
        double surplus = 0.0;
        if (this.g == null) {
            if (timeDiff < 1000L) {
                pastTime = timeDiff + " ns";
            } else if (timeDiff < 1000000L) {
                surplus = timeDiff % 1000000L;
                pastTime = (int)Math.floor((double)timeDiff / 1000000.0) + " micros " + (int)Math.floor(surplus /= 1000.0) + " ns";
            } else if (timeDiff < 1000000000L) {
                surplus = timeDiff % 1000000000L;
                pastTime = (int)Math.floor((double)timeDiff / 1.0E9) + " ms " + (int)Math.floor(surplus /= 1000000.0) + " micros";
            } else if (timeDiff > 1000000000L) {
                int time = (int)Math.ceil((double)timeDiff / 1.0E9);
                if (time < 60) {
                    pastTime = "" + (int)Math.floor(time) + "s";
                } else if (time >= 60 && time < 3600) {
                    surplus = time % 60;
                    pastTime = "" + (int)Math.floor(time /= 60) + "m " + (int)Math.floor(surplus) + " s";
                } else if (time >= 3600) {
                    surplus = time % 3600;
                    pastTime = "" + (int)Math.floor(time /= 3600) + "h " + (int)Math.floor(surplus /= 60.0) + " m";
                }
            }
        } else {
            switch (this.g) {
                case HOURS: {
                    break;
                }
                case MINS: {
                    break;
                }
                case SEC: {
                    break;
                }
                case MILLIS: {
                    break;
                }
            }
        }
        return pastTime;
    }

    public long getTimeDiff() {
        return System.nanoTime() - this.prevstart;
    }

    public static enum Granularity {
        MICROS,
        SEC,
        MILLIS,
        MINS,
        HOURS;

    }
}

