/*
 * Decompiled with CFR 0.152.
 */
package umcg.genetica.util;

import JSci.maths.ArrayMath;
import cern.colt.GenericSorting;
import cern.colt.Swapper;
import cern.colt.function.tint.IntComparator;
import java.util.HashSet;
import org.apache.commons.collections.primitives.ArrayDoubleList;

public class RankArray {
    public double[] xdouble = null;
    public int[] ydouble = null;
    public Swapper swapperdouble = new Swapper(){

        public void swap(int a, int b) {
            double t1 = RankArray.this.xdouble[a];
            RankArray.this.xdouble[a] = RankArray.this.xdouble[b];
            RankArray.this.xdouble[b] = t1;
            int t2 = RankArray.this.ydouble[a];
            RankArray.this.ydouble[a] = RankArray.this.ydouble[b];
            RankArray.this.ydouble[b] = t2;
        }
    };
    public IntComparator compdouble = new IntComparator(){

        public int compare(int a, int b) {
            return RankArray.this.xdouble[a] == RankArray.this.xdouble[b] ? 0 : (RankArray.this.xdouble[a] < RankArray.this.xdouble[b] ? -1 : 1);
        }
    };
    public float[] x = null;
    public int[] y = null;
    public Swapper swapper = new Swapper(){

        public void swap(int a, int b) {
            float t1 = RankArray.this.x[a];
            RankArray.this.x[a] = RankArray.this.x[b];
            RankArray.this.x[b] = t1;
            int t2 = RankArray.this.y[a];
            RankArray.this.y[a] = RankArray.this.y[b];
            RankArray.this.y[b] = t2;
        }
    };
    public IntComparator comp = new IntComparator(){

        public int compare(int a, int b) {
            return RankArray.this.x[a] == RankArray.this.x[b] ? 0 : (RankArray.this.x[a] < RankArray.this.x[b] ? -1 : 1);
        }
    };

    public double[] rank(double[] x, boolean giveTiesSameRank) {
        this.xdouble = (double[])x.clone();
        this.ydouble = new int[x.length];
        for (int v = 0; v < x.length; ++v) {
            this.ydouble[v] = v;
        }
        GenericSorting.quickSort((int)0, (int)x.length, (IntComparator)this.compdouble, (Swapper)this.swapperdouble);
        double[] rank = new double[x.length];
        for (int v = 0; v < x.length; ++v) {
            rank[this.ydouble[v]] = v;
        }
        if (!giveTiesSameRank) {
            return rank;
        }
        this.fixTiesDouble(rank, x);
        return rank;
    }

    public float[] rank(float[] x, boolean giveTiesSameRank) {
        this.x = (float[])x.clone();
        this.y = new int[x.length];
        for (int v = 0; v < x.length; ++v) {
            this.y[v] = v;
        }
        GenericSorting.quickSort((int)0, (int)x.length, (IntComparator)this.comp, (Swapper)this.swapper);
        float[] rank = new float[x.length];
        for (int v = 0; v < x.length; ++v) {
            rank[this.y[v]] = v;
        }
        if (!giveTiesSameRank) {
            return rank;
        }
        this.fixTiesFloat(rank, x);
        return rank;
    }

    private void fixTiesDouble(double[] rank, double[] x) {
        HashSet<Double> fixedValues = new HashSet<Double>();
        block0: for (int i = 0; i < x.length; ++i) {
            for (int j = i + 1; j < x.length; ++j) {
                if (x[i] != x[j] || fixedValues.contains(x[i])) continue;
                this.replaceRankDouble(x[i], i, j, rank, x);
                fixedValues.add(x[i]);
                continue block0;
            }
        }
    }

    private void replaceRankDouble(double d, int i, int j, double[] rank, double[] x) {
        double newRank;
        ArrayDoubleList t = new ArrayDoubleList();
        t.add(rank[i]);
        t.add(rank[j]);
        for (int k = j + 1; k < x.length; ++k) {
            if (x[k] != d) continue;
            t.add(rank[k]);
        }
        rank[i] = newRank = ArrayMath.mean((double[])t.toArray());
        rank[j] = newRank;
        for (int k = j + 1; k < x.length; ++k) {
            if (x[k] != d) continue;
            rank[k] = newRank;
        }
    }

    private void fixTiesFloat(float[] rank, float[] x) {
        HashSet<Float> fixedValues = new HashSet<Float>();
        block0: for (int i = 0; i < x.length; ++i) {
            for (int j = i + 1; j < x.length; ++j) {
                if (x[i] != x[j] || fixedValues.contains(Float.valueOf(x[i]))) continue;
                this.replaceRankFloat(x[i], i, j, rank, x);
                fixedValues.add(Float.valueOf(x[i]));
                continue block0;
            }
        }
    }

    private void replaceRankFloat(float f, int i, int j, float[] rank, float[] x) {
        ArrayDoubleList t = new ArrayDoubleList();
        t.add((double)rank[i]);
        t.add((double)rank[j]);
        for (int k = j + 1; k < x.length; ++k) {
            if (x[k] != f) continue;
            t.add((double)rank[k]);
        }
        double newRank = ArrayMath.mean((double[])t.toArray());
        rank[i] = (float)newRank;
        rank[j] = (float)newRank;
        for (int k = j + 1; k < x.length; ++k) {
            if (x[k] != f) continue;
            rank[k] = (float)newRank;
        }
    }
}

