/*
 * Decompiled with CFR 0.152.
 */
package umcg.genetica.ncbi.dbsnp;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import umcg.genetica.io.text.TextFile;
import umcg.genetica.text.Strings;

public class SNPAnnotation
implements Serializable {
    public HashMap<Integer, Integer> rsToChrPos = new HashMap();
    private HashSet<String> contigs;
    private HashMap<String, String> contigChr;
    private HashMap<String, String> contigOrientation;
    public HashMap<String, ArrayList<Integer>> chrToSNP = new HashMap();
    public HashMap<String, HashSet<Integer>> chrToUniquePositions = new HashMap();
    Integer[][] rsToRs = null;

    public SNPAnnotation(String contigInfoLoc, String snpInfoLoc) throws IOException {
        this.loadContigInfo(contigInfoLoc);
        this.loadSNPAnnotation(snpInfoLoc);
    }

    public SNPAnnotation(String contigInfoLoc, String snpInfoLoc, String ref) throws IOException {
        this.loadContigInfo(contigInfoLoc, ref);
        this.loadSNPAnnotation(snpInfoLoc);
    }

    private void loadContigInfo(String location) throws IOException {
        System.out.println("Loading contigs from: " + location);
        this.contigs = new HashSet();
        this.contigChr = new HashMap();
        this.contigOrientation = new HashMap();
        TextFile in = new TextFile(location, false);
        String[] elems = in.readLineElemsReturnObjects(TextFile.tab);
        boolean ctr = false;
        while (elems != null) {
            this.contigs.add(elems[0]);
            this.contigChr.put(elems[0], elems[5]);
            System.out.println(elems[0] + "\t" + elems[5]);
            this.contigOrientation.put(elems[0], elems[8]);
            elems = in.readLineElemsReturnObjects(TextFile.tab);
        }
        in.close();
    }

    private void loadContigInfo(String location, String buildString) throws IOException {
        System.out.println("Loading contigs from: " + location);
        this.contigs = new HashSet();
        this.contigChr = new HashMap();
        this.contigOrientation = new HashMap();
        TextFile in = new TextFile(location, false);
        String[] elems = in.readLineElemsReturnObjects(TextFile.tab);
        boolean ctr = false;
        while (elems != null) {
            if (elems[12].equals(buildString)) {
                this.contigs.add(elems[0]);
                this.contigChr.put(elems[0], elems[5]);
                System.out.println(elems[0] + "\t" + elems[5]);
                this.contigOrientation.put(elems[0], elems[8]);
            }
            elems = in.readLineElemsReturnObjects(TextFile.tab);
        }
        in.close();
    }

    private void loadSNPAnnotation(String loc) throws IOException {
        System.out.println("Loading SNP Annotation from: " + loc);
        int linecounter = 0;
        TextFile in = new TextFile(loc, false);
        boolean ctr = false;
        String[] elems = in.readLineElemsReturnObjects(TextFile.tab);
        while (elems != null) {
            String contig = elems[2];
            if (this.contigs.contains(contig)) {
                String chrStr = this.contigChr.get(contig);
                Integer chrPos = null;
                try {
                    chrPos = Integer.parseInt(elems[10]);
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    Integer RSnum = Integer.parseInt(elems[1]);
                    ArrayList<Integer> chrSNPs = this.chrToSNP.get(chrStr);
                    HashSet<Integer> uniquePositions = this.chrToUniquePositions.get(chrStr);
                    if (uniquePositions == null) {
                        uniquePositions = new HashSet();
                    }
                    if (chrSNPs == null) {
                        chrSNPs = new ArrayList();
                    }
                    chrSNPs.add(RSnum);
                    if (this.rsToChrPos.get(RSnum) != null) {
                        this.rsToChrPos.put(RSnum, -1);
                    } else {
                        this.rsToChrPos.put(RSnum, chrPos);
                    }
                    if (chrPos != null) {
                        uniquePositions.add(chrPos);
                    }
                    this.chrToUniquePositions.put(chrStr, uniquePositions);
                    this.chrToSNP.put(chrStr, chrSNPs);
                }
                catch (ArrayIndexOutOfBoundsException u) {
                    System.out.println(Strings.concat(elems, Strings.tab));
                }
            }
            ++linecounter;
            elems = in.readLineElemsReturnObjects(TextFile.tab);
        }
        in.close();
        int numTotalPositions = 0;
        Set<Map.Entry<String, HashSet<Integer>>> it = this.chrToUniquePositions.entrySet();
        for (Map.Entry<String, HashSet<Integer>> e : it) {
            if (e.getValue() == null) continue;
            numTotalPositions += e.getValue().size();
        }
        System.out.println(numTotalPositions + " positions loaded");
    }

    public HashSet<String> getContigs() {
        return this.contigs;
    }
}

