/*
 * Decompiled with CFR 0.152.
 */
package umcg.genetica.math.stats;

import java.util.Arrays;

public class WilcoxonMannWhitney {
    private double k;
    private double n;
    private double kn;
    private double auc;

    public double getAUC() {
        return this.auc;
    }

    private double abs(double value) {
        return Math.abs(value);
    }

    private double k_out_n(double k, double n) {
        this.k = k;
        this.n = n;
        this.kn = 1.0;
        while (k > 0.0) {
            this.kn *= (n -= 1.0) / (k -= 1.0);
        }
        return this.kn;
    }

    private double countSmallerRanks(double w, double sum, int m, int start, double[] rankList) {
        int i = 0;
        double temp = 0.0;
        double smaller = 0.0;
        int end = 0;
        int mminus1 = 0;
        if (sum > w) {
            return 0.0;
        }
        end = rankList.length - 1;
        if (m > 0) {
            mminus1 = m - 1;
            for (i = start; i <= end - m; ++i) {
                temp = sum + rankList[i];
                if (temp > w) {
                    return smaller;
                }
                smaller += this.countSmallerRanks(w, temp, mminus1, i + 1, rankList);
            }
        } else {
            if (sum + (double)end + 1.0 <= w) {
                return end - start + 1;
            }
            for (i = start; i <= end; ++i) {
                temp = sum + rankList[i];
                if (temp <= w) {
                    smaller += 1.0;
                    continue;
                }
                return smaller;
            }
        }
        return smaller;
    }

    private double normalZ(double z) {
        double t;
        double x = z;
        double[] b = new double[]{0.31938153, -0.356563782, 1.781477937, -1.821255978, 1.330274429};
        double p = 0.2316419;
        double fact = t = 1.0 / (1.0 + p * x);
        double sum = 0.0;
        for (int i = 0; i <= b.length - 1; ++i) {
            sum += b[i] * fact;
            fact *= t;
        }
        p = 2.0 * sum * Math.exp(-x * x / 2.0) / Math.sqrt(Math.PI * 2);
        return p;
    }

    public double returnWilcoxonMannWhitneyPValue(double[] A, double[] B) {
        Arrays.sort(A);
        Arrays.sort(B);
        double[] totalList = new double[A.length + B.length];
        for (int x = 0; x < A.length; ++x) {
            totalList[x] = A[x];
        }
        for (int y = 0; y < B.length; ++y) {
            totalList[y + A.length] = B[y];
        }
        Arrays.sort(totalList);
        double nA = A.length;
        double nB = B.length;
        double n = nA + nB;
        double maxSum = n * (n + 1.0) / 2.0;
        double h0 = maxSum / 2.0;
        double previous = Double.MIN_VALUE;
        int start = 0;
        double[] totalRank = new double[totalList.length];
        for (int i = 0; i < totalList.length; ++i) {
            if (totalList[i] == previous) {
                double meanRank = ((double)start + (double)i + 2.0) / 2.0;
                for (int j = start; j <= i; ++j) {
                    totalRank[j] = meanRank;
                }
                continue;
            }
            totalRank[i] = i + 1;
            previous = totalList[i];
            start = i;
        }
        double[] shortest = A;
        if (B.length < A.length) {
            shortest = B;
        }
        double nShortest = shortest.length;
        double w = 0.0;
        for (int a = 0; a < shortest.length; ++a) {
            int i;
            for (i = 0; i < totalList.length - 1 && shortest[a] != totalList[i]; ++i) {
            }
            w += totalRank[i];
        }
        double nZ = nShortest;
        if (w > h0) {
            nZ = n - nShortest;
        }
        if (w > h0) {
            w = maxSum - w;
        }
        double p = 0.0;
        double r1 = 0.0;
        int place = 0;
        block6: for (int i = 0; i < A.length; ++i) {
            for (int j = place; j < totalList.length; ++j) {
                if (A[i] != totalList[j]) continue;
                r1 += (double)(j + 1);
                place = j + 1;
                continue block6;
            }
        }
        double uA = r1 - nA * (nA + 1.0) / 2.0;
        this.auc = uA / (nA * nB);
        double permutations = this.k_out_n(nA, n);
        if (permutations >= 25000.0 || shortest.length >= 10) {
            double continuity = 0.5;
            if (w >= h0) {
                continuity = -0.5;
            }
            double z = Math.abs((w + continuity - nZ * (n + 1.0) / 2.0) / Math.sqrt(nA * nB * (n + 1.0) / 12.0));
            p = this.normalZ(z);
            return p;
        }
        return -1.0;
    }
}

