/*
 * Decompiled with CFR 0.152.
 */
package umcg.genetica.math.stats;

public class KolmogorovSmirnov {
    public static double getProbabilityKolmogorovSmirnov(double d, double n1, double n2) {
        double ne = n1 * n2 / (n1 + n1);
        double alam = (Math.sqrt(ne) + 0.12 + 0.11 / Math.sqrt(ne)) * d;
        double eps1 = 0.001;
        double eps2 = 1.0E-8;
        double a2 = -2.0 * alam * alam;
        double fac = 2.0;
        double probKS = 0.0;
        double termbf = 0.0;
        for (int j = 1; j <= 100; ++j) {
            double term = fac * Math.exp(a2 * (double)j * (double)j);
            probKS += term;
            if (Math.abs(term) <= eps1 * termbf || Math.abs(term) <= eps2 * probKS) {
                return probKS;
            }
            fac = -fac;
            termbf = Math.abs(term);
        }
        return 1.0;
    }

    public static double getKSP(double[] vals1, double[] vals2) {
        double z = KolmogorovSmirnov.getKSZ(vals1, vals2);
        return KolmogorovSmirnov.zToP(z);
    }

    public static double getKSZ(double[] vals1, double[] vals2) {
        int j1 = 0;
        int j2 = 0;
        double d = 0.0;
        double fn1 = 0.0;
        double fn2 = 0.0;
        double en1 = vals1.length;
        double en2 = vals2.length;
        while ((double)j1 < en1 && (double)j2 < en2) {
            double d2;
            double d3;
            double d4;
            if (Double.isNaN(vals1[j1]) || Double.isNaN(vals2[j2])) {
                throw new IllegalArgumentException("No NaNs allowed!");
            }
            double d1 = vals1[j1];
            double d22 = vals2[j2];
            if (d4 <= d3) {
                fn1 = (double)(++j1) / en1;
            }
            if (d22 <= d1) {
                fn2 = (double)(++j2) / en2;
            }
            double dt = Math.abs(fn2 - fn1);
            if (!(d2 > d)) continue;
            d = dt;
        }
        double z = Math.sqrt(en1 * en2 / (en1 + en2)) * d;
        return z;
    }

    public static double zToP(double z) {
        double EPS1 = 1.0E-6;
        double EPS2 = 1.0E-16;
        double fac = 2.0;
        double sum = 0.0;
        double termbf = 0.0;
        double a2 = -2.0 * z * z;
        for (int j = 1; j <= 100; ++j) {
            double term = fac * Math.exp(a2 * (double)j * (double)j);
            sum += term;
            if (Math.abs(term) <= EPS1 * termbf || Math.abs(term) <= EPS2 * sum) {
                return sum;
            }
            fac = -fac;
            termbf = Math.abs(term);
        }
        return 1.0;
    }
}

