/*
 * Decompiled with CFR 0.152.
 */
package umcg.genetica.math.stats;

public class FisherExactTest {
    private double left;
    private double right;
    private double twotail;
    private double sleft;
    private double sright;
    private double sless;
    private double slarg;
    private int sn11;
    private int sn1_;
    private int sn_1;
    private int sn;
    private double sprob;
    private int n11_;
    private int n12_;
    private int n21_;
    private int n22_;

    public double getFisherPValue(int n11, int n12, int n21, int n22) {
        this.n11_ = n11;
        this.n12_ = n12;
        this.n21_ = n21;
        this.n22_ = n22;
        if (this.n11_ < 0) {
            this.n11_ *= -1;
        }
        if (this.n12_ < 0) {
            this.n12_ *= -1;
        }
        if (this.n21_ < 0) {
            this.n21_ *= -1;
        }
        if (this.n22_ < 0) {
            this.n22_ *= -1;
        }
        int n1_ = this.n11_ + this.n12_;
        int n_1 = this.n11_ + this.n21_;
        int n = this.n11_ + this.n12_ + this.n21_ + this.n22_;
        this.exact(this.n11_, n1_, n_1, n);
        this.left = this.sless;
        this.right = this.slarg;
        this.twotail = this.sleft + this.sright;
        if (this.twotail > 1.0) {
            this.twotail = 1.0;
        }
        return this.twotail;
    }

    public double getFisherLeftTail() {
        return this.left;
    }

    public double getFisherRightTail() {
        return this.right;
    }

    public double calculateFisherTwoTail() {
        return this.twotail;
    }

    private static double lngamm(int z) {
        double x = 0.0;
        x += 1.659470187408462E-7 / (double)(z + 7);
        x += 9.934937113930748E-6 / (double)(z + 6);
        x -= 0.1385710331296526 / (double)(z + 5);
        x += 12.50734324009056 / (double)(z + 4);
        x -= 176.6150291498386 / (double)(z + 3);
        x += 771.3234287757674 / (double)(z + 2);
        x -= 1259.139216722289 / (double)(z + 1);
        x += 676.5203681218835 / (double)z;
        return Math.log(x += 0.9999999999995183) - 5.581061466795328 - (double)z + ((double)z - 0.5) * Math.log((double)z + 6.5);
    }

    private static double lnfact(int n) {
        if (n <= 1) {
            return 0.0;
        }
        return FisherExactTest.lngamm(n + 1);
    }

    private static double lnbico(int n, int k) {
        return FisherExactTest.lnfact(n) - FisherExactTest.lnfact(k) - FisherExactTest.lnfact(n - k);
    }

    private static double hyper_323(int n11, int n1_, int n_1, int n) {
        return Math.exp(FisherExactTest.lnbico(n1_, n11) + FisherExactTest.lnbico(n - n1_, n_1 - n11) - FisherExactTest.lnbico(n, n_1));
    }

    private double hyper(int n11) {
        return this.hyper0(n11, 0, 0, 0);
    }

    private double hyper0(int n11i, int n1_i, int n_1i, int ni) {
        if (n1_i == 0 & n_1i == 0 & ni == 0) {
            if (n11i % 10 != 0) {
                if (n11i == this.sn11 + 1) {
                    this.sprob = this.sprob * (((double)this.sn1_ - (double)this.sn11) / (double)n11i) * (((double)this.sn_1 - (double)this.sn11) / ((double)n11i + (double)this.sn - (double)this.sn1_ - (double)this.sn_1));
                    this.sn11 = n11i;
                    return this.sprob;
                }
                if (n11i == this.sn11 - 1) {
                    this.sprob = this.sprob * ((double)this.sn11 / ((double)this.sn1_ - (double)n11i)) * (((double)this.sn11 + (double)this.sn - (double)this.sn1_ - (double)this.sn_1) / ((double)this.sn_1 - (double)n11i));
                    this.sn11 = n11i;
                    return this.sprob;
                }
            }
            this.sn11 = n11i;
        } else {
            this.sn11 = n11i;
            this.sn1_ = n1_i;
            this.sn_1 = n_1i;
            this.sn = ni;
        }
        this.sprob = FisherExactTest.hyper_323(this.sn11, this.sn1_, this.sn_1, this.sn);
        return this.sprob;
    }

    private double exact(int n11, int n1_, int n_1, int n) {
        int min;
        int max = n1_;
        if (n_1 < max) {
            max = n_1;
        }
        if ((min = n1_ + n_1 - n) < 0) {
            min = 0;
        }
        if (min == max) {
            this.sless = 1.0;
            this.sright = 1.0;
            this.sleft = 1.0;
            this.slarg = 1.0;
            return 1.0;
        }
        double prob = this.hyper0(n11, n1_, n_1, n);
        this.sleft = 0.0;
        double p = this.hyper(min);
        int i = min + 1;
        while (p < 0.99999999 * prob) {
            this.sleft += p;
            p = this.hyper(i);
            ++i;
        }
        --i;
        if (p < 1.00000001 * prob) {
            this.sleft += p;
        } else {
            --i;
        }
        this.sright = 0.0;
        p = this.hyper(max);
        int j = max - 1;
        while (p < 0.99999999 * prob) {
            this.sright += p;
            p = this.hyper(j);
            --j;
        }
        ++j;
        if (p < 1.00000001 * prob) {
            this.sright += p;
        } else {
            ++j;
        }
        if (Math.abs(i - n11) < Math.abs(j - n11)) {
            this.sless = this.sleft;
            this.slarg = 1.0 - this.sleft + prob;
        } else {
            this.sless = 1.0 - this.sright + prob;
            this.slarg = this.sright;
        }
        return prob;
    }
}

