/*
 * Decompiled with CFR 0.152.
 */
package umcg.genetica.io.trityper.converters;

import java.io.IOException;
import java.util.HashSet;
import umcg.genetica.io.Gpio;
import umcg.genetica.io.text.TextFile;
import umcg.genetica.io.trityper.SNP;
import umcg.genetica.io.trityper.SNPLoader;
import umcg.genetica.io.trityper.TriTyperGenotypeData;
import umcg.genetica.io.trityper.util.BaseAnnot;

public class TriTyperToMachImputedTransposed {
    public static void main(String[] args) {
        try {
            TriTyperToMachImputedTransposed.convert("/Data/GeneticalGenomicsDatasets/BloodH8v2ImputeTriTyper/", "/Data/GeneticalGenomicsDatasets/BloodH8v2ImputeTriTyper/MachImputedTransposed.txt", "/Users/harmjan/Downloads/cis_SNPs.txt");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void convert(String trityperdataset, String output, String snplists) throws IOException {
        if (trityperdataset == null) {
            throw new IllegalArgumentException("Trityper folder should be set");
        }
        if (output == null) {
            throw new IllegalArgumentException("Output folder should be set");
        }
        String parentDir = Gpio.getParentDir(output);
        Gpio.createDir(parentDir);
        TriTyperGenotypeData tt = new TriTyperGenotypeData();
        tt.load(trityperdataset);
        HashSet<String> selectedSNPs = null;
        if (snplists != null) {
            selectedSNPs = new HashSet<String>();
            TextFile tf = new TextFile(snplists, false);
            selectedSNPs.addAll(tf.readAsArrayList());
            tf.close();
            System.out.println("About to export " + selectedSNPs.size() + " SNPs from " + snplists);
        }
        output = output + "ExportedSNPs-MachImputedTransposed.txt";
        TextFile outfile = new TextFile(output, true);
        SNPLoader l = tt.createSNPLoader();
        String[] snps = tt.getSNPs();
        String[] individuals = tt.getIndividuals();
        String header = "SNP\tCHR\tPOS\tAL1\tAL2\tFreq\tQual";
        for (int ind = 0; ind < individuals.length; ++ind) {
            if (!tt.getIsIncluded()[ind].booleanValue()) continue;
            header = header + "\t" + individuals[ind];
        }
        outfile.writeln(header);
        System.out.println("Exporting: ");
        int ctr = 0;
        for (int s = 0; s < snps.length; ++s) {
            if (selectedSNPs != null && !selectedSNPs.contains(snps[s])) continue;
            StringBuilder sb = new StringBuilder();
            sb.append(snps[s]).append("\t").append(tt.getChr(s)).append("\t").append(tt.getChrPos(s)).append("\t");
            SNP snpObj = tt.getSNPObject(s);
            l.loadGenotypes(snpObj);
            l.loadDosage(snpObj);
            sb.append(BaseAnnot.toString(snpObj.getAlleles()[0])).append("\t");
            sb.append(BaseAnnot.toString(snpObj.getAlleles()[1])).append("\t");
            if (snpObj.getMinorAllele() == snpObj.getAlleles()[0]) {
                sb.append(snpObj.getMAF()).append("\t");
            } else {
                sb.append(1.0 - snpObj.getMAF()).append("\t");
            }
            sb.append("1.0");
            for (int ind = 0; ind < individuals.length; ++ind) {
                if (!tt.getIsIncluded()[ind].booleanValue()) continue;
                sb.append("\t").append(snpObj.getDosageValues()[ind]);
            }
            outfile.writeln(sb.toString());
            snpObj.clearGenotypes();
            if (++ctr % 100 != 0) continue;
            System.out.println(ctr + "\texported");
        }
        outfile.close();
        System.out.println("Done exporting " + ctr + " SNPs ");
    }
}

