/*
 * Decompiled with CFR 0.152.
 */
package umcg.genetica.io.trityper.converters;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import umcg.genetica.io.Gpio;
import umcg.genetica.io.text.TextFile;
import umcg.genetica.io.trityper.WGAFileMatrixGenotype;
import umcg.genetica.io.trityper.WGAFileMatrixImputedDosage;

public class MachImputedToTriTyper {
    public MachImputedToTriTyper(String dir, String outputDir) throws IOException {
        Gpio.createDir(outputDir);
        HashMap<String, Integer> hashSNPs = new HashMap<String, Integer>();
        ArrayList<String> vecSNPs = new ArrayList<String>();
        System.out.println("Determining number of unique SNPs:");
        TextFile outSNPs = new TextFile(outputDir + "/SNPs.txt", true);
        String[] fileList = Gpio.getListOfFiles(dir, ".mlinfo");
        TextFile in = null;
        String[] str = null;
        for (String filename : fileList) {
            System.out.println("Processing file:\t" + filename);
            in = new TextFile(filename, false);
            str = in.readLineElemsReturnReference(TextFile.tab);
            while (str != null) {
                String snp = new String(str[0].getBytes());
                if (!hashSNPs.containsKey(snp)) {
                    hashSNPs.put(snp, vecSNPs.size());
                    vecSNPs.add(snp);
                }
                outSNPs.write(snp + "\n");
                str = in.readLineElemsReturnReference(TextFile.tab);
            }
            in.close();
            in = null;
        }
        outSNPs.close();
        System.out.println("Determining unique number of individuals:");
        HashMap<String, Integer> hashInds = new HashMap<String, Integer>();
        ArrayList<String> vecInds = new ArrayList<String>();
        for (String filename : fileList = Gpio.getListOfFiles(dir, ".mlgeno")) {
            in = new TextFile(filename, false);
            str = in.readLineElemsReturnReference(TextFile.space);
            while (str != null) {
                System.out.println(str[0]);
                if (!hashInds.containsKey(str[0])) {
                    hashInds.put(str[0], vecInds.size());
                    vecInds.add(str[0]);
                }
                str = in.readLineElemsReturnReference(TextFile.space);
            }
        }
        for (String filename : fileList = Gpio.getListOfFiles(dir, ".mldose")) {
            in = new TextFile(filename, false);
            str = in.readLineElemsReturnReference(TextFile.space);
            while (str != null) {
                System.out.println(str[0]);
                if (!hashInds.containsKey(str[0])) {
                    hashInds.put(str[0], vecInds.size());
                    vecInds.add(str[0]);
                }
                str = in.readLineElemsReturnReference(TextFile.space);
            }
            in.close();
        }
        TextFile outInds = new TextFile(outputDir + "/Individuals.txt", true);
        for (String ind : vecInds) {
            String individual = ind.split(">")[1];
            outInds.write(individual + "\n");
        }
        outInds.close();
        System.out.println("Number of unique SNPs:\t" + vecSNPs.size());
        System.out.println("Number of unique individuals:\t" + vecInds.size());
        System.out.println("Importing genotypes:");
        File fileGenotypeMatrix = new File(outputDir + "/GenotypeMatrix.dat");
        WGAFileMatrixGenotype matrixGenotype = new WGAFileMatrixGenotype(vecSNPs.size(), vecInds.size(), fileGenotypeMatrix, false);
        for (String filename : fileList = Gpio.getListOfFiles(dir, ".mlinfo")) {
            System.out.println("Processing " + filename);
            int[] snpIDArray = new int[1000000];
            in = new TextFile(filename, false);
            str = in.readLineElemsReturnReference(TextFile.tab);
            int counter = 0;
            while (str != null) {
                String snp = new String(str[0].getBytes());
                snpIDArray[counter] = (Integer)hashSNPs.get(snp);
                ++counter;
                str = in.readLineElemsReturnReference(TextFile.tab);
            }
            in.close();
            String genofilename = filename.substring(0, filename.length() - 7);
            genofilename = genofilename + ".mlgeno";
            in = new TextFile(genofilename, false);
            str = in.readLineElemsReturnReference(TextFile.space);
            while (str != null) {
                int indID = (Integer)hashInds.get(str[0]);
                for (int c = 2; c < str.length; ++c) {
                    int snpID = snpIDArray[c - 2];
                    byte[] allele1 = new byte[]{str[c].getBytes()[0]};
                    byte[] allele2 = new byte[]{str[c].getBytes()[2]};
                    matrixGenotype.setAllele1(snpID, indID, allele1);
                    matrixGenotype.setAllele2(snpID, indID, allele2);
                }
                str = in.readLineElemsReturnReference(TextFile.space);
            }
            in.close();
        }
        matrixGenotype.close();
        File fileImputedDosageMatrix = new File(outputDir + "/ImputedDosageMatrix.dat");
        WGAFileMatrixImputedDosage matrixImputedDosage = new WGAFileMatrixImputedDosage(vecSNPs.size(), vecInds.size(), fileImputedDosageMatrix, false);
        fileList = Gpio.getListOfFiles(dir, ".mlinfo");
        System.out.println("Importing dosage information:");
        for (String filename : fileList) {
            System.out.println("Processing " + filename);
            int[] snpIDArray = new int[1000000];
            in = new TextFile(filename, false);
            str = in.readLineElemsReturnReference(TextFile.tab);
            int counter = 0;
            while (str != null) {
                String snp = new String(str[0].getBytes());
                snpIDArray[counter] = (Integer)hashSNPs.get(snp);
                ++counter;
                str = in.readLineElemsReturnReference(TextFile.tab);
            }
            in.close();
            String genofilename = filename.substring(0, filename.length() - 7);
            genofilename = genofilename + ".mldose";
            in = new TextFile(genofilename, false);
            str = in.readLineElemsReturnReference(TextFile.space);
            while (str != null) {
                int indID = (Integer)hashInds.get(str[0]);
                for (int c = 2; c < str.length; ++c) {
                    int snpID = snpIDArray[c - 2];
                    int dosageInt = (int)Math.round(Double.parseDouble(str[c]) * 100.0);
                    if (dosageInt < 0 || dosageInt > 200) {
                        System.out.println("Warning, incorrect dosage!:\t" + dosageInt + "\t" + snpID + "\t" + str[c]);
                    }
                    byte dosageByte = (byte)(-128 + dosageInt);
                    byte[] dosage = new byte[]{dosageByte};
                    matrixImputedDosage.setDosage(snpID, indID, dosage);
                }
                System.out.println("Sample\t" + str[0] + "\thas been processed.");
            }
            in.close();
        }
        matrixImputedDosage.close();
        System.out.println("\n\n\n");
        System.out.println("MACH Imputed data has been imported.");
        System.out.println("\n\n\n");
    }
}

