/*
 * Decompiled with CFR 0.152.
 */
package umcg.genetica.io.trityper;

import java.io.File;
import java.io.IOException;
import umcg.genetica.io.bin.RandomAccessFile;

public class WGAFileMatrixRawData {
    public int nrSNPs = 0;
    public int nrInds = 0;
    private RandomAccessFile file = null;

    public WGAFileMatrixRawData(int nrSNPs, int nrInds, File fileName, boolean readOnly) throws IOException {
        this.nrSNPs = nrSNPs;
        this.nrInds = nrInds;
        this.file = readOnly ? new RandomAccessFile(fileName, "r") : new RandomAccessFile(fileName, "rw");
        long fileSize = 3L * (long)nrSNPs * (long)nrInds;
        if (!readOnly && this.file.length() != fileSize) {
            this.file.seek(0L);
            byte[] byteString = new byte[1000];
            for (int g = 0; g < 1000; ++g) {
                byteString[g] = 0;
            }
            for (long x = 0L; x < fileSize - 1000L; x += 1000L) {
                this.file.write(byteString);
            }
            long remainder = fileSize % 1000L;
            byte[] byteSingle = new byte[]{0};
            for (long x = 0L; x < remainder; ++x) {
                this.file.write(byteSingle);
            }
            System.out.println("Size matrix:\t" + fileSize + "\tFile size:\t" + this.file.length());
        }
    }

    private long getElement(int snp, int ind) {
        return 3L * (long)snp * (long)this.nrInds + (long)ind;
    }

    public void close() throws IOException {
        this.file.close();
    }

    public byte getGCScore(int snp, int ind) throws IOException {
        this.file.seek(this.getElement(snp, ind));
        return this.file.readByte();
    }

    public byte getR(int snp, int ind) throws IOException {
        this.file.seek(this.getElement(snp, ind) + (long)this.nrInds);
        return this.file.readByte();
    }

    public byte getTheta(int snp, int ind) throws IOException {
        this.file.seek(this.getElement(snp, ind) + (long)(this.nrInds * 2));
        return this.file.readByte();
    }

    public void setGCScore(int snp, int ind, byte[] value) throws IOException {
        this.file.seek(this.getElement(snp, ind));
        this.file.write(value);
    }

    public void setR(int snp, int ind, byte[] value) throws IOException {
        this.file.seek(this.getElement(snp, ind) + (long)this.nrInds);
        this.file.write(value);
    }

    public void setTheta(int snp, int ind, byte[] value) throws IOException {
        this.file.seek(this.getElement(snp, ind) + (long)(this.nrInds * 2));
        this.file.write(value);
    }
}

