/*
 * Decompiled with CFR 0.152.
 */
package umcg.genetica.io.trityper;

import gnu.trove.map.hash.THashMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import umcg.genetica.io.Gpio;
import umcg.genetica.io.text.TextFile;
import umcg.genetica.io.trityper.SNP;
import umcg.genetica.io.trityper.SNPLoader;
import umcg.genetica.io.trityper.util.ChrAnnotation;

public class TriTyperGenotypeData {
    private String[] SNPs;
    private Boolean[] isFemale;
    private Boolean[] isCase;
    private Boolean[] isIncluded;
    private String[] individuals;
    private THashMap<String, Integer> individualToId;
    private TObjectIntHashMap<String> snpToSNPId;
    private String genotypeFileName;
    private String dosageFileName;
    private byte[] chr;
    private int[] chrPos;

    public TriTyperGenotypeData(String loc) throws IOException {
        this.load(loc);
    }

    public TriTyperGenotypeData() {
    }

    public final void load(String loc) throws IOException {
        loc = Gpio.formatAsDirectory(loc);
        this.checkFiles(loc);
        TextFile t = new TextFile(loc + "Individuals.txt", false);
        String[] lineElems = t.readLineElemsReturnReference(TextFile.tab);
        ArrayList<String> alInd = new ArrayList<String>();
        int i = 0;
        this.individualToId = new THashMap();
        while (lineElems != null) {
            String individual = new String(lineElems[0].getBytes("UTF-8"));
            this.individualToId.put((Object)individual, (Object)i);
            alInd.add(individual);
            ++i;
            lineElems = t.readLineElemsReturnReference(TextFile.tab);
        }
        t.close();
        if (alInd.isEmpty()) {
            System.err.println("ERROR: your dataset does not contain any individuals.");
            System.exit(-1);
        }
        int numInds = this.individualToId.size();
        this.setIsFemale(new Boolean[numInds]);
        this.setIsCase(new Boolean[numInds]);
        this.setIsIncluded(new Boolean[numInds]);
        this.individuals = new String[numInds];
        for (i = 0; i < numInds; ++i) {
            this.getIsFemale()[i] = null;
            this.getIsCase()[i] = null;
            this.getIsIncluded()[i] = null;
            this.individuals[i] = (String)alInd.get(i);
        }
        alInd = null;
        t = new TextFile(loc + "PhenotypeInformation.txt", false);
        int numMales = 0;
        int numFemales = 0;
        int numCases = 0;
        int numControls = 0;
        int numIncluded = 0;
        lineElems = t.readLineElemsReturnReference(TextFile.tab);
        while (lineElems != null) {
            String ind = lineElems[0];
            Integer indId = (Integer)this.individualToId.get((Object)ind);
            if (indId != null) {
                if (lineElems[1].equals("control")) {
                    this.isCase[indId.intValue()] = false;
                    ++numControls;
                } else if (lineElems[1].equals("case")) {
                    this.isCase[indId.intValue()] = true;
                    ++numCases;
                } else {
                    System.err.println("Warning: case/control status unparseable for\t" + lineElems[1] + "\tfor\t" + indId);
                }
                if (lineElems[2].equals("exclude")) {
                    this.isIncluded[indId.intValue()] = false;
                } else if (lineElems[2].equals("include")) {
                    this.isIncluded[indId.intValue()] = true;
                    ++numIncluded;
                } else {
                    System.err.println("Warning: include/exclude status unparseable\t" + lineElems[2] + "\tfor\t" + indId);
                }
                if (lineElems[3].equals("male")) {
                    this.isFemale[indId.intValue()] = false;
                    ++numMales;
                } else if (lineElems[3].equals("female")) {
                    this.isFemale[indId.intValue()] = true;
                    ++numFemales;
                } else {
                    System.err.println("Warning: gender status unparseable\t" + lineElems[3] + "\tfor\t" + indId);
                }
            }
            lineElems = t.readLineElemsReturnReference(TextFile.tab);
        }
        t.close();
        System.out.println(numInds + " individuals detected, " + numMales + " males, " + numFemales + " females, " + numCases + " cases, " + numControls + " controls, " + numIncluded + " included");
        if (numIncluded == 0) {
            System.err.println("ERROR: None of the samples in your dataset will be included. Please check your PhenotypeInformation.txt");
            System.exit(-1);
        }
        if (Gpio.exists(loc + "SNPs.txt")) {
            t = new TextFile(loc + "SNPs.txt", false);
        } else if (Gpio.exists(loc + "SNPs.txt.gz")) {
            t = new TextFile(loc + "SNPs.txt.gz", false);
        } else {
            throw new FileNotFoundException("SNPs file not found");
        }
        String line = t.readLine();
        ArrayList<String> tmpSNP = new ArrayList<String>();
        while (line != null) {
            if (line.trim().length() > 0) {
                tmpSNP.add(line.intern());
            }
            line = t.readLine();
        }
        t.close();
        this.snpToSNPId = new TObjectIntHashMap(tmpSNP.size(), 0.85f, -9);
        int snpId = 0;
        for (String s : tmpSNP) {
            this.snpToSNPId.put((Object)s, snpId);
            ++snpId;
        }
        this.SNPs = tmpSNP.toArray(new String[0]);
        System.out.println(this.SNPs.length + " snps loaded");
        if (this.SNPs.length == 0) {
            System.err.println("ERROR: no SNPs have been detected. Please check your dataset.");
            System.exit(-1);
        }
        if (Gpio.exists(loc + "SNPMappings.txt")) {
            t = new TextFile(loc + "SNPMappings.txt", false);
        } else if (Gpio.exists(loc + "SNPMappings.txt.gz")) {
            t = new TextFile(loc + "SNPMappings.txt.gz", false);
        } else {
            throw new FileNotFoundException("SNPMappings not found");
        }
        lineElems = t.readLineElemsReturnReference(TextFile.tab);
        this.chr = new byte[this.SNPs.length];
        this.chrPos = new int[this.SNPs.length];
        int linenr = 0;
        int nrWoAnnotation = 0;
        while (lineElems != null) {
            if (lineElems.length > 2) {
                int snpNum = this.snpToSNPId.get((Object)lineElems[2]);
                boolean unknownchr = false;
                boolean unknownchrpos = false;
                if (snpNum != -9 && !"null".equals(lineElems[0]) && !"null".equals(lineElems[1])) {
                    if (lineElems[0].length() > 0 && !lineElems[0].equals("-1")) {
                        this.chr[snpNum] = ChrAnnotation.parseChr(lineElems[0]);
                    } else {
                        this.chr[snpNum] = -1;
                        unknownchr = true;
                    }
                    if (lineElems[1].length() > 0 && !lineElems[1].equals("-1")) {
                        this.chrPos[snpNum] = Integer.parseInt(lineElems[1]);
                    } else {
                        this.chrPos[snpNum] = -1;
                        unknownchrpos = true;
                    }
                    if (unknownchr || unknownchrpos) {
                        ++nrWoAnnotation;
                    }
                }
            }
            ++linenr;
            lineElems = t.readLineElemsReturnReference(TextFile.tab);
        }
        t.close();
        System.out.println("Nr of SNPs without annotation: " + nrWoAnnotation + " / " + this.snpToSNPId.size());
        this.setGenotypeFileName(loc + "GenotypeMatrix.dat");
        this.setDosageFileName(loc + "ImputedDosageMatrix.dat");
        this.checkFileSizes();
    }

    public Boolean[] getIsFemale() {
        return this.isFemale;
    }

    public void setIsFemale(Boolean[] isFemale) {
        this.isFemale = isFemale;
    }

    public Boolean[] getIsCase() {
        return this.isCase;
    }

    public void setIsCase(Boolean[] isCase) {
        this.isCase = isCase;
    }

    public Boolean[] getIsIncluded() {
        return this.isIncluded;
    }

    public void setIsIncluded(Boolean[] isIncluded) {
        this.isIncluded = isIncluded;
    }

    public THashMap<String, Integer> getIndividualToId() {
        return this.individualToId;
    }

    public void setIndividualToId(THashMap<String, Integer> individualToId) {
        this.individualToId = individualToId;
    }

    public TObjectIntHashMap<String> getSnpToSNPId() {
        return this.snpToSNPId;
    }

    public void setSnpToSNPObject(TObjectIntHashMap<String> snpToSNPObject) {
        this.snpToSNPId = snpToSNPObject;
    }

    public String getGenotypeFileName() {
        return this.genotypeFileName;
    }

    public void setGenotypeFileName(String genotypeFileName) {
        this.genotypeFileName = genotypeFileName;
    }

    public String getDosageFileName() {
        return this.dosageFileName;
    }

    public void setDosageFileName(String dosageFileName) {
        this.dosageFileName = dosageFileName;
    }

    public String[] getSNPs() {
        return this.SNPs;
    }

    public void setSNPs(String[] SNPs) {
        this.SNPs = SNPs;
    }

    public String[] getIndividuals() {
        return this.individuals;
    }

    private void checkFiles(String loc) throws IOException {
        if (!Gpio.exists(loc)) {
            throw new IOException("Error: Directory " + loc + " does not exist.");
        }
        if (!Gpio.exists(loc + "PhenotypeInformation.txt")) {
            throw new IOException("Error: Required file " + loc + "PhenotypeInformation.txt does not exist.");
        }
        if (!Gpio.exists(loc + "Individuals.txt")) {
            throw new IOException("Error: Required file " + loc + "Individuals.txt does not exist.");
        }
        if (!Gpio.exists(loc + "SNPMappings.txt") && !Gpio.exists(loc + "SNPMappings.txt.gz")) {
            throw new IOException("Error: Required file " + loc + "SNPMappings.txt (or SNPMappings.txt.gz) does not exist.");
        }
        if (!Gpio.exists(loc + "SNPs.txt") && !Gpio.exists(loc + "SNPs.txt.gz")) {
            throw new IOException("Error: Required file " + loc + "SNPs.txt (or SNPs.txt.gz) does not exist.");
        }
    }

    public Integer getIndividualId(String key) {
        return (Integer)this.individualToId.get((Object)key);
    }

    public Byte getChr(int s) {
        return this.chr[s];
    }

    public int getChrPos(int s) {
        return this.chrPos[s];
    }

    public SNP getSNPObject(int d) {
        SNP out = new SNP();
        out.setId(d);
        out.setChr(this.chr[d]);
        out.setChrPos(this.chrPos[d]);
        out.setName(this.SNPs[d]);
        return out;
    }

    public SNPLoader createSNPLoader() throws IOException {
        RandomAccessFile dosageHandle = null;
        RandomAccessFile genotypeHandle = new RandomAccessFile(this.genotypeFileName, "r");
        if (Gpio.exists(this.dosageFileName)) {
            dosageHandle = new RandomAccessFile(this.dosageFileName, "r");
        }
        SNPLoader s = new SNPLoader(genotypeHandle, dosageHandle, this.isIncluded, this.isFemale);
        s.setNumIndividuals(this.individuals.length);
        return s;
    }

    private void checkFileSizes() throws IOException {
        long detectedsize;
        long expectedfilesize;
        if (Gpio.exists(this.genotypeFileName)) {
            expectedfilesize = (long)(this.SNPs.length * 2) * (long)this.individuals.length;
            detectedsize = Gpio.getFileSize(this.genotypeFileName);
            if (expectedfilesize != detectedsize) {
                throw new IOException("Size of GenotypeMatrix.dat does not match size defined by Indivuals.txt and SNPs.txt. Expected size: " + expectedfilesize + " (" + Gpio.humanizeFileSize(expectedfilesize) + ")\tDetected size: " + detectedsize + " (" + Gpio.humanizeFileSize(detectedsize) + ")\tDiff: " + Math.abs(expectedfilesize - detectedsize));
            }
        } else {
            throw new IOException("GenotypeMatrix.dat not detected at location: " + this.genotypeFileName);
        }
        if (Gpio.exists(this.dosageFileName) && (expectedfilesize = (long)this.SNPs.length * (long)this.individuals.length) != (detectedsize = Gpio.getFileSize(this.dosageFileName))) {
            throw new IOException("Size of ImputedDosageMatrix.dat does not match size defined by Indivuals.txt and SNPs.txt. Expected size: " + expectedfilesize + " (" + Gpio.humanizeFileSize(expectedfilesize) + ")\tDetected size: " + detectedsize + " (" + Gpio.humanizeFileSize(detectedsize) + ")\tDiff: " + Math.abs(expectedfilesize - detectedsize));
        }
    }
}

