/*
 * Decompiled with CFR 0.152.
 */
package umcg.genetica.io.trityper;

import java.io.IOException;
import java.util.HashMap;
import umcg.genetica.io.text.TextFile;
import umcg.genetica.io.trityper.util.ChrAnnotation;

public final class ProbeAnnotation {
    private String[] probes;
    private int[] chrStart;
    private int[] chrEnd;
    private short[] chr;
    private String[] annotation;
    private HashMap<String, Integer> probeIndex;

    public ProbeAnnotation() {
    }

    public ProbeAnnotation(String loc) throws IOException {
        this.load(loc);
    }

    public void load(String loc) throws IOException {
        TextFile in = new TextFile(loc, false);
        int probeNum = in.countLines() - 1;
        this.probes = new String[probeNum];
        this.annotation = new String[probeNum];
        this.chr = new short[probeNum];
        this.chrStart = new int[probeNum];
        this.chrEnd = new int[probeNum];
        in.readLine();
        this.probeIndex = new HashMap();
        String[] elems = in.readLineElemsReturnReference(TextFile.tab);
        int i = 0;
        while (elems != null) {
            if (elems.length >= 6) {
                this.probes[i] = elems[1];
                this.annotation[i] = elems[2];
                this.chr[i] = ChrAnnotation.parseChr(elems[3]);
                if (this.chr[i] != -1) {
                    this.chrStart[i] = Integer.parseInt(elems[4]);
                    this.chrEnd[i] = Integer.parseInt(elems[5]);
                } else {
                    this.chrStart[i] = -1;
                    this.chrEnd[i] = -1;
                }
                this.probeIndex.put(this.probes[i], i);
                ++i;
            }
            elems = in.readLineElemsReturnReference(TextFile.tab);
        }
        in.close();
    }

    public String[] getProbes() {
        return this.probes;
    }

    public int[] getChrStart() {
        return this.chrStart;
    }

    public int[] getChrEnd() {
        return this.chrEnd;
    }

    public short[] getChr() {
        return this.chr;
    }

    public String[] getProbeAnnotation() {
        return this.annotation;
    }

    public HashMap<String, Integer> getProbeToProbeId() {
        return this.probeIndex;
    }

    public void setProbes(String[] probes) {
        this.probes = probes;
    }

    public void setChrStart(int[] chrStart) {
        this.chrStart = chrStart;
    }

    public void setChrEnd(int[] chrEnd) {
        this.chrEnd = chrEnd;
    }

    public void setChr(short[] chr) {
        this.chr = chr;
    }

    public void setProbeAnnotation(String[] probeAnnotation) {
        this.annotation = probeAnnotation;
    }

    public void setProbeToProbeId(HashMap<String, Integer> probeToProbeId) {
        this.probeIndex = probeToProbeId;
    }
}

