/*
 * Decompiled with CFR 0.152.
 */
package umcg.genetica.io.text;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import umcg.genetica.containers.Pair;
import umcg.genetica.containers.Triple;
import umcg.genetica.text.Strings;

public class TextFile
implements Iterable<String> {
    public static final int DEFAULT_BUFFER_SIZE = 4096;
    public static final Pattern tab = Pattern.compile("\\t");
    public static final Pattern space = Strings.space;
    public static final Pattern colon = Strings.colon;
    public static final Pattern semicolon = Strings.semicolon;
    public static final Pattern comma = Strings.comma;
    protected BufferedReader in;
    protected File file;
    public static final boolean W = true;
    public static final boolean R = false;
    protected BufferedWriter out;
    protected boolean writeable;
    protected static final String ENCODING = "ISO-8859-1";
    private boolean gzipped;
    private int buffersize;

    public TextFile(String file, boolean mode) throws IOException {
        this(new File(file), mode, 4096);
    }

    public TextFile(File file, boolean mode) throws IOException {
        this(file, mode, 4096);
    }

    public TextFile(File file, boolean mode, int buffersize) throws IOException {
        this.buffersize = buffersize;
        this.file = file;
        String loc = file.getAbsolutePath();
        if (loc.trim().length() == 0) {
            throw new IOException("Could not find file: no file specified");
        }
        this.writeable = mode;
        if (loc.endsWith(".gz")) {
            this.gzipped = true;
        }
        this.open();
    }

    public TextFile(String file, boolean mode, int buffersize) throws IOException {
        this(new File(file), mode, buffersize);
    }

    public final void open() throws IOException {
        if (!this.file.exists() && !this.writeable) {
            throw new IOException("Could not find file: " + this.file);
        }
        if (this.writeable) {
            if (this.gzipped) {
                GZIPOutputStream gzipOutputStream = new GZIPOutputStream(new FileOutputStream(this.file));
                this.out = new BufferedWriter(new OutputStreamWriter(gzipOutputStream), this.buffersize);
            } else {
                this.out = new BufferedWriter(new FileWriter(this.file), this.buffersize);
            }
        } else if (this.gzipped) {
            GZIPInputStream gzipInputStream = new GZIPInputStream(new FileInputStream(this.file));
            this.in = new BufferedReader(new InputStreamReader((InputStream)gzipInputStream, "US-ASCII"));
        } else {
            this.in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.file), ENCODING), 8096);
        }
    }

    public String readLine() throws IOException {
        return this.in.readLine();
    }

    public void write(String line) throws IOException {
        this.out.write(line);
    }

    public void close() throws IOException {
        if (this.writeable) {
            this.out.close();
        } else {
            this.in.close();
        }
    }

    public String[] readLineElems(Pattern p) throws IOException {
        return this.readLineElemsReturnReference(p);
    }

    private Iterator<String[]> readLineElemsIterator(Pattern p) throws IOException {
        return new TextFileIteratorElements(this, p);
    }

    public Iterable<String[]> readLineElemsIterable(Pattern p) {
        return new TextFileIterableElements(this, p);
    }

    public String[] readLineElemsReturnReference(Pattern p) throws IOException {
        if (this.in != null) {
            String ln = this.readLine();
            if (ln != null) {
                String[] elems = p.split(ln);
                ln = null;
                return elems;
            }
            return null;
        }
        return null;
    }

    public String[] readLineElemsReturnObjects(Pattern p) throws IOException {
        if (this.in != null) {
            String ln = this.readLine();
            if (ln != null) {
                String[] origelems = p.split(ln);
                String[] returnelems = new String[origelems.length];
                for (int i = 0; i < origelems.length; ++i) {
                    returnelems[i] = new String(origelems[i]);
                }
                ln = null;
                return returnelems;
            }
            return null;
        }
        return null;
    }

    public int countLines() throws IOException {
        String ln = this.readLine();
        int ct = 0;
        while (ln != null) {
            if (ln.trim().length() > 0) {
                ++ct;
            }
            ln = this.readLine();
        }
        this.close();
        this.open();
        return ct;
    }

    public int countCols(Pattern p) throws IOException {
        String ln = this.readLine();
        int ct = 0;
        if (ln != null) {
            String[] elems = p.split(ln);
            ct = elems.length;
        }
        this.close();
        this.open();
        return ct;
    }

    public String[] readAsArray() throws IOException {
        int numLines = this.countLines();
        String ln = this.readLine();
        if (ln == null) {
            return new String[0];
        }
        String[] data = new String[numLines];
        int i = 0;
        while (ln != null) {
            if (ln.trim().length() > 0) {
                data[i] = ln;
                ++i;
            }
            ln = this.in.readLine();
        }
        return data;
    }

    public String[] readAsArray(int col, Pattern p) throws IOException {
        int numLines = this.countLines();
        String[] data = new String[numLines];
        int i = 0;
        String[] elems = this.readLineElems(p);
        while (elems != null) {
            if (elems.length > col) {
                data[i] = elems[col];
            }
            ++i;
            elems = this.readLineElems(p);
        }
        return data;
    }

    public ArrayList<String> readAsArrayList() throws IOException {
        ArrayList<String> data = new ArrayList<String>();
        String ln = this.readLine();
        while (ln != null) {
            if (ln.trim().length() > 0) {
                data.add(ln);
            }
            ln = this.in.readLine();
        }
        return data;
    }

    public ArrayList<String> readAsArrayList(int col, Pattern p) throws IOException {
        ArrayList<String> data = new ArrayList<String>();
        String[] elems = this.readLineElems(p);
        while (elems != null) {
            if (elems.length > col) {
                data.add(elems[col]);
            }
            elems = this.readLineElems(p);
        }
        return data;
    }

    public void writeln(CharSequence csq) throws IOException {
        this.out.append(csq);
        this.out.append('\n');
    }

    public void writeln(String line) throws IOException {
        this.out.append(line);
        this.out.append('\n');
    }

    public void writeln() throws IOException {
        this.out.newLine();
    }

    public void append(char c) throws IOException {
        this.out.append(c);
    }

    public void append(CharSequence csq) throws IOException {
        this.out.append(csq);
    }

    public synchronized void writelnsynced(String str) throws IOException {
        this.writeln(str);
    }

    public void writelnTabDelimited(Object[] vals) throws IOException {
        String delim = "";
        for (Object val : vals) {
            this.out.write(delim);
            this.out.write(val.toString());
            delim = "\t";
        }
        this.writeln();
    }

    public void writelnDelimited(Object[] vals, Pattern p) throws IOException {
        String delim = "";
        for (Object val : vals) {
            this.out.write(delim);
            this.out.write(val.toString());
            delim = p.pattern();
        }
        this.writeln();
    }

    public Map<String, String> readAsHashMap(int col1, int col2) throws IOException {
        HashMap<String, String> output = new HashMap<String, String>();
        String[] elems = this.readLineElems(tab);
        while (elems != null) {
            if (elems.length > col1 && elems.length > col2) {
                output.put(elems[col1], elems[col2]);
            }
            elems = this.readLineElems(tab);
        }
        return output;
    }

    public Map<String, String> readAsHashMap(int col1, int col2, Pattern p) throws IOException {
        HashMap<String, String> output = new HashMap<String, String>();
        String[] elems = this.readLineElems(p);
        while (elems != null) {
            if (elems.length > col1 && elems.length > col2) {
                output.put(elems[col1], elems[col2]);
            }
            elems = this.readLineElems(p);
        }
        return output;
    }

    public Set<String> readAsSet(int col, Pattern p) throws IOException {
        HashSet<String> output = new HashSet<String>();
        String[] elems = this.readLineElems(p);
        while (elems != null) {
            if (elems.length > col) {
                output.add(elems[col]);
            }
            elems = this.readLineElems(p);
        }
        return output;
    }

    public void writeList(List l) throws IOException {
        for (Object e : l) {
            this.writeln(e.toString());
        }
    }

    public String getFileName() {
        return this.file.getAbsolutePath();
    }

    public HashSet<Pair<String, String>> readAsPairs(int A, int B) throws IOException {
        HashSet<Pair<String, String>> output = new HashSet<Pair<String, String>>();
        String[] elems = this.readLineElemsReturnObjects(tab);
        while (elems != null) {
            if (elems.length > A && elems.length > B) {
                output.add(new Pair<String, String>(elems[A], elems[B]));
            }
            elems = this.readLineElemsReturnObjects(tab);
        }
        return output;
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public HashSet<Triple<String, String, String>> readAsTriple(int A, int B, int C) throws IOException {
        HashSet<Triple<String, String, String>> output = new HashSet<Triple<String, String, String>>();
        String[] elems = this.readLineElemsReturnObjects(tab);
        while (elems != null) {
            if (elems.length > A && elems.length > B && elems.length > C) {
                output.add(new Triple<String, String, String>(elems[A], elems[B], elems[C]));
            }
            elems = this.readLineElemsReturnObjects(tab);
        }
        return output;
    }

    @Override
    public Iterator<String> iterator() {
        try {
            return new TextFileIterator(this);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static class TextFileIterableElements
    implements Iterable<String[]> {
        private final TextFile textFile;
        private final Pattern pattern;

        public TextFileIterableElements(TextFile textFile, Pattern pattern) {
            this.textFile = textFile;
            this.pattern = pattern;
        }

        @Override
        public Iterator<String[]> iterator() {
            try {
                return this.textFile.readLineElemsIterator(this.pattern);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    private static class TextFileIteratorElements
    implements Iterator<String[]> {
        private final TextFile textFile;
        private final Pattern pattern;
        String[] next;

        public TextFileIteratorElements(TextFile textFile, Pattern p) throws IOException {
            this.textFile = textFile;
            this.pattern = p;
            this.next = textFile.readLineElemsReturnObjects(this.pattern);
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public String[] next() {
            String[] current = this.next;
            try {
                this.next = this.textFile.readLineElemsReturnObjects(this.pattern);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
            return current;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    private static class TextFileIterator
    implements Iterator<String> {
        private final TextFile textFile;
        String next;

        public TextFileIterator(TextFile textFile) throws IOException {
            this.textFile = textFile;
            this.next = textFile.readLine();
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public String next() {
            String current = this.next;
            try {
                this.next = this.textFile.readLine();
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
            return current;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

