/*
 * Decompiled with CFR 0.152.
 */
package umcg.genetica.io.pileup;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import org.molgenis.genotype.Allele;
import umcg.genetica.io.pileup.PileupEntry;
import umcg.genetica.io.pileup.PileupParseException;

public class PileupFile
implements Iterable<PileupEntry> {
    File pileupFile;
    private static final Pattern TAB_PATTERN = Pattern.compile("\t");
    private final int minimumBaseQuality;

    public PileupFile(String pileupFilePath, int minimumBaseQuality) throws FileNotFoundException, IOException {
        this(new File(pileupFilePath), minimumBaseQuality);
    }

    public PileupFile(File pileupFile, int minimumBaseQuality) throws FileNotFoundException, IOException {
        this.pileupFile = pileupFile;
        this.minimumBaseQuality = minimumBaseQuality;
        if (!pileupFile.isFile()) {
            throw new FileNotFoundException("Cannot find pileup file at: " + pileupFile.getAbsolutePath());
        }
        if (!pileupFile.canRead()) {
            throw new IOException("Cannot read pileup file at: " + pileupFile.getAbsolutePath());
        }
    }

    public static PileupEntry parsePileupLine(String line, int minimumBaseQuality) throws PileupParseException {
        int depth;
        int pos;
        String[] elements = TAB_PATTERN.split(line);
        try {
            pos = Integer.parseInt(elements[1]);
        }
        catch (NumberFormatException ex) {
            throw new PileupParseException("Error parsing position: " + elements[1]);
        }
        try {
            depth = Integer.parseInt(elements[3]);
        }
        catch (NumberFormatException ex) {
            throw new PileupParseException("Error parsing position: " + elements[3]);
        }
        Allele allele = Allele.create((String)elements[2]);
        if (elements.length == 5) {
            return new PileupEntry(elements[0], pos, allele, depth, elements[4], minimumBaseQuality);
        }
        return new PileupEntry(elements[0], pos, allele, depth, elements[4], elements[5], minimumBaseQuality);
    }

    @Override
    public Iterator<PileupEntry> iterator() {
        BufferedReader reader = null;
        try {
            reader = this.pileupFile.getAbsolutePath().endsWith(".gz") ? new BufferedReader(new InputStreamReader((InputStream)new GZIPInputStream(new FileInputStream(this.pileupFile)), "UTF-8")) : new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.pileupFile), "UTF-8"));
            return new pileupFileIterator(reader);
        }
        catch (FileNotFoundException ex) {
            throw new RuntimeException(ex);
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public String getAbsolutePath() {
        return this.pileupFile.getAbsolutePath();
    }

    private class pileupFileIterator
    implements Iterator<PileupEntry> {
        private final BufferedReader reader;
        private PileupEntry next;

        public pileupFileIterator(BufferedReader reader) {
            this.reader = reader;
            try {
                String line = reader.readLine();
                this.next = line == null ? null : PileupFile.parsePileupLine(line, PileupFile.this.minimumBaseQuality);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
            catch (PileupParseException ex) {
                throw new RuntimeException(ex);
            }
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public PileupEntry next() {
            PileupEntry current = this.next;
            try {
                String line = this.reader.readLine();
                this.next = line == null ? null : PileupFile.parsePileupLine(line, PileupFile.this.minimumBaseQuality);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
            catch (PileupParseException ex) {
                throw new RuntimeException(ex);
            }
            return current;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported.");
        }
    }
}

