/*
 * Decompiled with CFR 0.152.
 */
package umcg.genetica.io.concurrent;

import java.util.Set;
import java.util.concurrent.Callable;
import java.util.regex.Pattern;
import umcg.genetica.containers.Triple;
import umcg.genetica.text.Strings;

public class DoubleParseTask
implements Callable<Triple<Integer, String, double[]>> {
    String stringData;
    int offset = 0;
    int row = 0;
    private final int[] columnIndex;
    private final Set hashRowsToInclude;
    private int nrColumnsToInclude;
    private Pattern separator;

    public DoubleParseTask(String d, int offset, int row, int[] columnIndex, Set hashProbesToInclude) {
        this.stringData = d;
        this.offset = offset;
        this.row = row;
        this.columnIndex = columnIndex;
        this.hashRowsToInclude = hashProbesToInclude;
        this.nrColumnsToInclude = columnIndex == null ? -1 : columnIndex.length;
    }

    public DoubleParseTask(String d, int offset, int row, int[] columnIndex, Set hashProbesToInclude, Pattern separator) {
        this.stringData = d;
        this.offset = offset;
        this.row = row;
        this.columnIndex = columnIndex;
        this.hashRowsToInclude = hashProbesToInclude;
        this.nrColumnsToInclude = columnIndex == null ? -1 : columnIndex.length;
        this.separator = separator;
    }

    @Override
    public Triple<Integer, String, double[]> call() throws Exception {
        if (this.stringData == null) {
            return new Triple<Integer, Object, Object>(-1, null, null);
        }
        if (this.separator == null) {
            this.separator = Strings.tab;
        }
        String[] splitData = this.separator.split(this.stringData);
        String rowname = new String(splitData[0].getBytes());
        if (this.nrColumnsToInclude == -1) {
            this.nrColumnsToInclude = splitData.length - 1;
        }
        if (this.hashRowsToInclude == null || this.hashRowsToInclude.contains(rowname)) {
            double[] output = new double[this.nrColumnsToInclude];
            for (int s = 0; s < this.nrColumnsToInclude; ++s) {
                int columnPositionInFile = s + this.offset;
                if (this.columnIndex != null) {
                    columnPositionInFile = this.columnIndex[s];
                }
                try {
                    output[s] = Double.parseDouble(splitData[columnPositionInFile]);
                    continue;
                }
                catch (NumberFormatException e) {
                    System.err.println("ERROR! Value is not a double: " + splitData[columnPositionInFile] + "\trow: " + this.row + "\tcol:" + columnPositionInFile + "\toffset: " + this.offset);
                    output[s] = Double.NaN;
                }
            }
            this.stringData = null;
            return new Triple<Integer, String, double[]>(this.row, rowname, output);
        }
        this.stringData = null;
        return new Triple<Integer, Object, Object>(-1, null, null);
    }
}

