/*
 * Decompiled with CFR 0.152.
 */
package umcg.genetica.gwas;

import JSci.maths.ArrayMath;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import umcg.genetica.containers.StringDoubleObject;
import umcg.genetica.io.text.TextFile;
import umcg.genetica.io.trityper.SNP;
import umcg.genetica.io.trityper.SNPLoader;
import umcg.genetica.io.trityper.TriTyperGenotypeData;
import umcg.genetica.io.trityper.util.DetermineLD;
import umcg.genetica.math.matrix.DoubleMatrixDataset;
import umcg.genetica.util.StringDoubleObjectSorterSortOnDouble;

public class Independifier {
    private static final Logger LOGGER = Logger.getLogger(Independifier.class.getName());
    TriTyperGenotypeData genotypeData;
    final SNPLoader snpLoader;
    Map<String, DoubleMatrixDataset<String, String>> permDatasets;

    public Independifier(String datadir) throws IOException {
        this.genotypeData = new TriTyperGenotypeData();
        this.genotypeData.load(datadir);
        this.snpLoader = this.genotypeData.createSNPLoader();
    }

    public Independifier(TriTyperGenotypeData genotypeData, SNPLoader snpLoader) throws IOException {
        this.genotypeData = genotypeData;
        this.snpLoader = snpLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectSNPsWithSimilarMAFsAsRealInputSNPs(String[] snps) throws IOException {
        TObjectIntHashMap<String> snpToSNPId = this.genotypeData.getSnpToSNPId();
        Vector<Double> vecMAFs = new Vector<Double>();
        for (int s = 0; s < snps.length; ++s) {
            if (snpToSNPId.get((Object)snps[s]) != -9) {
                int id = snpToSNPId.get((Object)snps[s]);
                SNP snp = this.genotypeData.getSNPObject(id);
                SNPLoader sNPLoader = this.snpLoader;
                synchronized (sNPLoader) {
                    this.snpLoader.loadGenotypes(snp);
                }
                Double maf = snp.getMAF();
                vecMAFs.add(maf);
                System.out.println(snp.getName() + "\t" + maf);
                continue;
            }
            System.out.println("Error! SNP " + snps[s] + " is not present in the genotype data!!!!!!");
        }
        double[] mafs = new double[vecMAFs.size()];
        for (int m = 0; m < mafs.length; ++m) {
            mafs[m] = (Double)vecMAFs.get(m);
        }
        double median = ArrayMath.median((double[])mafs);
        System.out.println("Median MAF:\t" + median);
        System.out.println("\n\n\n\n\n\n");
        int len = snpToSNPId.size();
        for (int snpId = 0; snpId < len; ++snpId) {
            SNP snp = this.genotypeData.getSNPObject(snpId);
            SNPLoader sNPLoader = this.snpLoader;
            synchronized (sNPLoader) {
                this.snpLoader.loadGenotypes(snp);
            }
            Double maf = snp.getMAF();
            System.out.println(snpId + "\t" + snp.getName() + "\t" + maf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] independify(String[] snps, double r2Threshold, int bpThreshold) throws IOException {
        double r2;
        int s;
        TObjectIntHashMap<String> snpToSNPId = this.genotypeData.getSnpToSNPId();
        Vector<String> vecSNPsPresentInGenotypeData = new Vector<String>();
        for (s = 0; s < snps.length; ++s) {
            if (snpToSNPId.get((Object)snps[s]) == -9) {
                vecSNPsPresentInGenotypeData.add(snps[s]);
                continue;
            }
            System.out.println("Error! SNP " + snps[s] + " is not present in the genotype data!!!!!!");
        }
        snps = new String[vecSNPsPresentInGenotypeData.size()];
        for (s = 0; s < snps.length; ++s) {
            snps[s] = (String)vecSNPsPresentInGenotypeData.get(s);
        }
        DetermineLD ldCalc = new DetermineLD();
        double[][] r2Matrix = new double[snps.length][snps.length];
        int[] snpsChr = new int[snps.length];
        int[] snpsChrPos = new int[snps.length];
        for (int s1 = 0; s1 < snps.length; ++s1) {
            Integer get = snpToSNPId.get((Object)snps[s1]);
            SNP snp1 = this.genotypeData.getSNPObject(get);
            SNPLoader sNPLoader = this.snpLoader;
            synchronized (sNPLoader) {
                this.snpLoader.loadGenotypes(snp1);
            }
            byte chr1 = snp1.getChr();
            int chrPos1 = snp1.getChrPos();
            snpsChr[s1] = chr1;
            snpsChrPos[s1] = chrPos1;
            for (int s2 = s1 + 1; s2 < snps.length; ++s2) {
                SNP snp2 = this.genotypeData.getSNPObject(snpToSNPId.get((Object)snps[s2]));
                if (s1 == s2 || chr1 != snp2.getChr() || Math.abs(chrPos1 - snp2.getChrPos()) >= bpThreshold) continue;
                SNPLoader sNPLoader2 = this.snpLoader;
                synchronized (sNPLoader2) {
                    this.snpLoader.loadGenotypes(snp2);
                }
                r2Matrix[s1][s2] = r2 = ldCalc.getRSquared(snp1, snp2, this.genotypeData, 4, 1, false);
                r2Matrix[s2][s1] = r2;
            }
        }
        int nrIndependifiedLeadSNPs = 0;
        int nrSNPsToUse = snps.length;
        System.out.println("Nr of SNPs with available genotype data in imputed dataset:\t" + nrSNPsToUse);
        int[] clusters = new int[snps.length];
        for (int s1 = 0; s1 < snps.length; ++s1) {
            clusters[s1] = -1;
        }
        int nrClusters = 0;
        for (int s1 = 0; s1 < nrSNPsToUse; ++s1) {
            boolean SNPInLDWithOtherSNP = false;
            for (int s2 = 0; s2 < nrSNPsToUse; ++s2) {
                if (s1 == s2 || snpsChr[s1] != snpsChr[s2] || Math.abs(snpsChrPos[s1] - snpsChrPos[s2]) >= bpThreshold || !((r2 = r2Matrix[s1][s2]) > r2Threshold)) continue;
                SNPInLDWithOtherSNP = true;
                if (clusters[s1] == -1 && clusters[s2] == -1) {
                    clusters[s1] = nrClusters;
                    clusters[s2] = nrClusters++;
                    continue;
                }
                if (clusters[s1] != -1 && clusters[s2] != -1) {
                    int previousClusterS1 = clusters[s1];
                    int previousClusterS2 = clusters[s2];
                    for (int q = 0; q < nrSNPsToUse; ++q) {
                        if (clusters[q] == previousClusterS1) {
                            clusters[q] = nrClusters;
                        }
                        if (clusters[q] != previousClusterS2) continue;
                        clusters[q] = nrClusters;
                    }
                    ++nrClusters;
                    continue;
                }
                if (clusters[s1] == -1) {
                    clusters[s1] = clusters[s2];
                }
                if (clusters[s2] != -1) continue;
                clusters[s2] = clusters[s1];
            }
            if (SNPInLDWithOtherSNP) continue;
            clusters[s1] = nrClusters++;
        }
        ArrayList<String> independifiedSNPs = new ArrayList<String>();
        nrIndependifiedLeadSNPs = 0;
        for (int c = 0; c < nrClusters; ++c) {
            boolean clusterContainsSNPs = false;
            for (int s1 = 0; s1 < nrSNPsToUse; ++s1) {
                if (clusters[s1] != c) continue;
                clusterContainsSNPs = true;
                break;
            }
            if (!clusterContainsSNPs) continue;
            ++nrIndependifiedLeadSNPs;
            String snpsThisCluster = "";
            String delim = "";
            for (int s1 = 0; s1 < nrSNPsToUse; ++s1) {
                if (clusters[s1] != c) continue;
                snpsThisCluster = snpsThisCluster + delim + snps[s1];
                delim = ";";
            }
            independifiedSNPs.add(snpsThisCluster);
        }
        return independifiedSNPs.toArray(new String[0]);
    }

    public String[] independify(String permutationDataset, int permutation, double pThreshold, double r2Threshold, int bpThreshold, int nrIndependentSNPsWanted) throws IOException {
        return this.independify(permutationDataset, permutation, pThreshold, r2Threshold, bpThreshold, nrIndependentSNPsWanted, null);
    }

    public void addPermutationDataset(String name, String filename) throws IOException {
        DoubleMatrixDataset permDataset = new DoubleMatrixDataset(filename);
        if (this.permDatasets == null) {
            this.permDatasets = new HashMap<String, DoubleMatrixDataset<String, String>>();
        }
        this.permDatasets.put(name, permDataset);
        if (filename.endsWith(".txt")) {
            permDataset.save(filename.replaceAll(".txt", ".binary"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] independify(String permutationDataset, int permutation, double pThreshold, double r2Threshold, int bpThreshold, int nrIndependentSNPsWanted, String outFile) throws IOException {
        DoubleMatrixDataset<String, String> permDataset = this.permDatasets.get(permutationDataset);
        if (permDataset == null) {
            throw new IllegalStateException("Dataset '" + permutationDataset + "' not set!");
        }
        TObjectIntHashMap<String> snpToSNPId = this.genotypeData.getSnpToSNPId();
        Vector<StringDoubleObject> vecTopResults = new Vector<StringDoubleObject>();
        for (int s = 0; s < permDataset.nrCols; ++s) {
            Byte chr;
            if (!(permDataset.rawData[permutation][s] < pThreshold) || snpToSNPId.get(permDataset.colObjects.get(s)) == -9 || (chr = this.genotypeData.getChr(s)) < 0 || chr > 23) continue;
            StringDoubleObject e = new StringDoubleObject((String)permDataset.colObjects.get(s), permDataset.rawData[permutation][s]);
            vecTopResults.add(e);
        }
        StringDoubleObjectSorterSortOnDouble sorter = new StringDoubleObjectSorterSortOnDouble();
        sorter.sort(vecTopResults);
        String[] snps = new String[vecTopResults.size()];
        for (int q = 0; q < vecTopResults.size(); ++q) {
            snps[q] = ((StringDoubleObject)vecTopResults.get((int)q)).stringValue;
        }
        LOGGER.log(Level.INFO, "Permutation {0}:\tUsing {1} SNPs, this will require {2} MB of memory", new Object[]{permutation, snps.length, (double)(4 * snps.length) * ((double)snps.length / 1024.0 / 1024.0)});
        DetermineLD ldCalc = new DetermineLD();
        float[][] r2Matrix = new float[snps.length][snps.length];
        int[] snpsChr = new int[snps.length];
        int[] snpsChrPos = new int[snps.length];
        for (int s1 = 0; s1 < snps.length; ++s1) {
            Integer get = snpToSNPId.get((Object)snps[s1]);
            SNP snp1 = this.genotypeData.getSNPObject(get);
            SNPLoader sNPLoader = this.snpLoader;
            synchronized (sNPLoader) {
                this.snpLoader.loadGenotypes(snp1);
            }
            byte chr1 = snp1.getChr();
            int chrPos1 = snp1.getChrPos();
            snpsChr[s1] = chr1;
            snpsChrPos[s1] = chrPos1;
            for (int s2 = s1 + 1; s2 < snps.length; ++s2) {
                SNP snp2 = this.genotypeData.getSNPObject(snpToSNPId.get((Object)snps[s2]));
                if (s1 != s2 && chr1 == snp2.getChr() && Math.abs(chrPos1 - snp2.getChrPos()) < bpThreshold) {
                    SNPLoader sNPLoader2 = this.snpLoader;
                    synchronized (sNPLoader2) {
                        this.snpLoader.loadGenotypes(snp2);
                    }
                    double r2 = ldCalc.getRSquared(snp1, snp2, this.genotypeData, 4, 1, false);
                    r2Matrix[s1][s2] = (float)r2;
                    r2Matrix[s2][s1] = (float)r2;
                }
                snp2.clearGenotypes();
            }
            snp1.clearGenotypes();
        }
        int nrIndependifiedLeadSNPs = 0;
        int nrSNPsToUse = snps.length;
        int lower = 0;
        int upper = snps.length;
        ArrayList<String> independifiedSNPs = new ArrayList<String>();
        while (nrIndependifiedLeadSNPs != nrIndependentSNPsWanted) {
            nrSNPsToUse = (upper + lower) / 2;
            int[] clusters = new int[snps.length];
            for (int s1 = 0; s1 < snps.length; ++s1) {
                clusters[s1] = -1;
            }
            int nrClusters = 0;
            for (int s1 = 0; s1 < nrSNPsToUse; ++s1) {
                boolean SNPInLDWithOtherSNP = false;
                for (int s2 = 0; s2 < nrSNPsToUse; ++s2) {
                    double r2;
                    if (s1 == s2 || snpsChr[s1] != snpsChr[s2] || Math.abs(snpsChrPos[s1] - snpsChrPos[s2]) >= bpThreshold || !((r2 = (double)r2Matrix[s1][s2]) > r2Threshold)) continue;
                    SNPInLDWithOtherSNP = true;
                    if (clusters[s1] == -1 && clusters[s2] == -1) {
                        clusters[s1] = nrClusters;
                        clusters[s2] = nrClusters++;
                        continue;
                    }
                    if (clusters[s1] != -1 && clusters[s2] != -1) {
                        int previousClusterS1 = clusters[s1];
                        int previousClusterS2 = clusters[s2];
                        for (int q = 0; q < nrSNPsToUse; ++q) {
                            if (clusters[q] == previousClusterS1) {
                                clusters[q] = nrClusters;
                            }
                            if (clusters[q] != previousClusterS2) continue;
                            clusters[q] = nrClusters;
                        }
                        ++nrClusters;
                        continue;
                    }
                    if (clusters[s1] == -1) {
                        clusters[s1] = clusters[s2];
                    }
                    if (clusters[s2] != -1) continue;
                    clusters[s2] = clusters[s1];
                }
                if (SNPInLDWithOtherSNP) continue;
                clusters[s1] = nrClusters++;
            }
            independifiedSNPs = new ArrayList();
            TextFile out = null;
            if (outFile != null && !outFile.isEmpty()) {
                out = new TextFile(outFile, true);
            }
            nrIndependifiedLeadSNPs = 0;
            for (int c = 0; c < nrClusters; ++c) {
                boolean clusterContainsSNPs = false;
                for (int s1 = 0; s1 < nrSNPsToUse; ++s1) {
                    if (clusters[s1] != c) continue;
                    clusterContainsSNPs = true;
                    break;
                }
                if (!clusterContainsSNPs) continue;
                ++nrIndependifiedLeadSNPs;
                if (out != null) {
                    out.write(c + "");
                }
                String snpsThisCluster = "";
                String delim = "";
                for (int s1 = 0; s1 < nrSNPsToUse; ++s1) {
                    if (clusters[s1] != c) continue;
                    snpsThisCluster = snpsThisCluster + delim + snps[s1];
                    delim = ";";
                    if (out == null) continue;
                    out.write("\t" + snps[s1]);
                }
                independifiedSNPs.add(snpsThisCluster);
                if (out == null) continue;
                out.writeln();
            }
            if (out != null) {
                out.close();
            }
            if (nrIndependifiedLeadSNPs != nrIndependentSNPsWanted) {
                if (nrIndependifiedLeadSNPs < nrIndependentSNPsWanted) {
                    lower = nrSNPsToUse;
                } else {
                    upper = nrSNPsToUse;
                }
            }
            if (upper - lower > 1) continue;
            break;
        }
        return independifiedSNPs.toArray(new String[0]);
    }
}

