/*
 * Decompiled with CFR 0.152.
 */
package umcg.genetica.graphics;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import umcg.genetica.containers.Pair;
import umcg.genetica.math.Goniometry;

public class VennDiagram {
    private int width = 0;
    private int height = 0;
    private int spacer = 50;
    private BufferedImage bimage;
    private Graphics2D g2d;
    private int requestedsize;

    public VennDiagram(int size) {
        this.requestedsize = size;
    }

    public void plot(double sizeSetA, double sizeSetB, double overlap, String setAName, String setBName) {
        int margin = 50;
        this.bimage = new BufferedImage(1, 1, 1);
        this.g2d = this.bimage.createGraphics();
        FontMetrics fontmetrics = this.g2d.getFontMetrics();
        this.width = margin * 2 + 10 + fontmetrics.stringWidth(setAName) + fontmetrics.stringWidth(setBName) + (this.requestedsize - margin * 2);
        this.height = this.width / 2;
        this.bimage = new BufferedImage(this.width, this.height, 1);
        this.g2d = this.bimage.createGraphics();
        this.g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.g2d.setColor(new Color(255, 255, 255));
        this.g2d.fillRect(0, 0, this.width, this.height);
        this.g2d.setColor(new Color(0, 0, 0));
        double d = this.getDistance(sizeSetA, sizeSetB, overlap);
        int widthofstringA = fontmetrics.stringWidth(setAName);
        int widthofstringB = fontmetrics.stringWidth(setBName);
        int meanwidthOfString = widthofstringA + widthofstringB;
        int maxCircleSize = (this.requestedsize - margin * 2) / 2;
        double width1radians = this.getR(sizeSetA) * 2.0;
        double width2radians = this.getR(sizeSetB) * 2.0;
        double maxwidth = width1radians;
        if (width2radians > width1radians) {
            maxwidth = width2radians;
        }
        int circle1sizepixels = (int)Math.ceil((double)maxCircleSize * (width1radians / maxwidth));
        int circle2sizepixels = (int)Math.ceil((double)maxCircleSize * (width2radians / maxwidth));
        int distancepixels = (int)Math.ceil((double)maxCircleSize * (d / maxwidth));
        double radius1 = (double)circle1sizepixels / 2.0;
        double radius2 = (double)circle2sizepixels / 2.0;
        Color black = new Color(137, 142, 216);
        Color grey = new Color(73, 78, 134, 125);
        int totaldistance = distancepixels + (int)Math.ceil(radius1) + (int)Math.floor(radius2);
        int remaining = this.width - totaldistance;
        int marginx = remaining / 2;
        this.g2d.setColor(black);
        this.g2d.fillOval(marginx, this.height / 2 - (int)Math.floor(radius1), circle1sizepixels, circle1sizepixels);
        int circle1origin = marginx + (int)Math.ceil(radius1);
        int circle2origin = circle1origin + distancepixels;
        int circle2start = circle2origin - (int)Math.ceil(radius2);
        this.g2d.setColor(grey);
        this.g2d.fillOval(circle2start, this.height / 2 - (int)Math.floor(radius2), circle2sizepixels, circle2sizepixels);
        this.g2d.setColor(black);
        this.g2d.drawOval(circle2start, this.height / 2 - (int)Math.floor(radius2), circle2sizepixels, circle2sizepixels);
        this.g2d.setStroke(new BasicStroke(2.0f));
        this.g2d.setColor(black);
        int originX1 = (int)Math.ceil((double)marginx + radius1);
        int originY1 = (int)Math.ceil((double)this.height / 2.0);
        int originX2 = (int)Math.ceil((double)circle2start + radius2);
        int originY2 = (int)Math.ceil(this.height / 2);
        int deg = 225;
        Pair<Integer, Integer> xy0 = Goniometry.calcPosOnCircle(radius1, 0.0, 0.0, deg);
        Pair<Integer, Integer> xy1 = Goniometry.calcPosOnCircle(radius1 + 10.0, 0.0, 0.0, deg);
        String setADesc = "(" + sizeSetA + ")";
        int setADescWidth = fontmetrics.stringWidth(setADesc);
        int descheight = fontmetrics.getHeight() * 2;
        this.g2d.drawString(setAName, originX1 + xy1.getLeft() - widthofstringA - 5, originY1 + xy1.getRight() - descheight / 2);
        this.g2d.drawString(setADesc, originX1 + xy1.getLeft() - setADescWidth - 5, originY1 + xy1.getRight() + fontmetrics.getHeight() - descheight / 2);
        deg = 315;
        xy0 = Goniometry.calcPosOnCircle(radius2, 0.0, 0.0, deg);
        xy1 = Goniometry.calcPosOnCircle(radius2 + 10.0, 0.0, 0.0, deg);
        String setBDesc = "(" + sizeSetB + ")";
        this.g2d.drawString(setBName, originX2 + xy1.getLeft() + 5, originY2 + xy1.getRight() - descheight / 2);
        this.g2d.drawString(setBDesc, originX2 + xy1.getLeft() + 5, originY2 + xy1.getRight() + fontmetrics.getHeight() - descheight / 2);
        String overlapstr = "Overlap";
        String overlapdesc = "(" + overlap + ")";
        int overlapstrwidth = fontmetrics.stringWidth(overlapstr);
        int overlapstrwidthhalway = overlapstrwidth / 2;
        int overlapdescstrwidth = fontmetrics.stringWidth(overlapdesc);
        int overlapdescstrwidthhalway = overlapdescstrwidth / 2;
        int dd2 = distancepixels - (int)Math.floor(radius1);
        int dd1 = distancepixels - (int)Math.floor(radius2);
        int ddx = distancepixels - dd1 - dd2;
        int overlapmid = marginx + (int)Math.floor(radius1) + dd1 + (int)Math.floor(ddx / 2);
        int halfmaxcircleheight = maxCircleSize / 2;
        this.g2d.drawString(overlapstr, overlapmid - overlapstrwidthhalway, this.height / 2 - halfmaxcircleheight - fontmetrics.getHeight() * 2);
        this.g2d.drawString(overlapdesc, overlapmid - overlapdescstrwidthhalway, this.height / 2 - halfmaxcircleheight - fontmetrics.getHeight());
    }

    public void draw(String loc) throws IOException {
        ImageIO.write((RenderedImage)this.bimage, "png", new File(loc));
    }

    private double calc_overlap(double r1, double r2, double d) {
        double alpha = 2.0 * Math.acos((Math.pow(d, 2.0) + Math.pow(r1, 2.0) - Math.pow(r2, 2.0)) / (2.0 * r1 * d));
        double beta = 2.0 * Math.acos((Math.pow(d, 2.0) + Math.pow(r2, 2.0) - Math.pow(r1, 2.0)) / (2.0 * r2 * d));
        double s = 0.5 * Math.pow(r1, 2.0) * (alpha - Math.sin(alpha)) + 0.5 * Math.pow(r2, 2.0) * (beta - Math.sin(beta));
        return s;
    }

    private double getR(double r) {
        return Math.sqrt(r / Math.PI);
    }

    private double getDistance(double sizeSetA, double sizeSetB, double overlap) {
        double maxOverlap;
        double r1 = this.getR(sizeSetA);
        double r2 = this.getR(sizeSetB);
        double minOverlap = Math.abs(r1 - r2);
        double upper = maxOverlap = r1 + r2;
        double lower = minOverlap;
        double testpos = 0.0;
        double circleOverlap = 0.0;
        double allowed_difference = overlap / 100.0;
        int i = 0;
        while (Math.abs(lower - upper) < 1.0E-7 && !(Math.abs((circleOverlap = this.calc_overlap(r1, r2, testpos = (lower + upper) / 2.0)) - overlap) <= allowed_difference)) {
            if (circleOverlap > overlap) {
                lower = testpos;
            } else {
                upper = testpos;
            }
            if (i == 100) break;
            ++i;
        }
        return testpos;
    }
}

