/*
 * Decompiled with CFR 0.152.
 */
package umcg.genetica.graphics;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.font.TextLayout;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Locale;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import umcg.genetica.graphics.Heatmap;
import umcg.genetica.io.trityper.util.ChrAnnotation;

public class ForestPlot {
    private String[] geneNames;
    private static final Font LARGE_FONT = new Font("Verdana", 0, 14);
    private static final Font LARGE_FONT_BOLD = new Font("Verdana", 1, 14);
    private static final Font SMALL_FONT = new Font("Verdana", 0, 10);
    private static final int upMaxR = 108;
    private static final int upMaxG = 189;
    private static final int upMaxB = 69;
    private static final int downMaxR = 0;
    private static final int downMaxG = 174;
    private static final int downMaxB = 239;
    private static final float downMaxH = 0.54444444f;
    private static final float downMaxS = 1.0f;
    private static final float downMaxBr = 0.93f;
    private static final float upMaxH = 0.2777778f;
    private static final float upMaxS = 0.63f;
    private static final float upMaxBr = 0.74f;
    private static final Color red1Color = new Color(242, 101, 94, 50);
    private static final Color red2Color = new Color(242, 101, 94, 25);
    private static final Color gray1Color = new Color(237, 237, 237);
    private static final Color gray2Color = new Color(247, 247, 247);
    private static final Logger LOGGER = Logger.getLogger(Heatmap.class.getName());
    private static final Stroke dashed = new BasicStroke(1.0f, 1, 1, 0.0f, new float[]{4.0f}, 0.0f);
    private static final Stroke line2pt = new BasicStroke(2.0f, 1, 1);
    private static final Stroke line = new BasicStroke(1.0f, 1, 1);

    public void drawForrestPlot(String xAxisName, String[] yAxisNames, Double[] xValues, String filename, Output output, double[] significanceThresholds, Double minX, Double maxX, int[] weights, byte[] chr, int[] chrpos, int metaRow) throws IOException, DocumentException {
        Double[][] workvalues = new Double[1][xValues.length];
        System.arraycopy(xValues, 0, workvalues[0], 0, xValues.length);
        this.drawMultiForrestPlot(xAxisName, yAxisNames, workvalues, filename, output, significanceThresholds, minX, maxX, weights, chr, chrpos, metaRow);
    }

    public void setGeneNames(String[] geneNames) {
        this.geneNames = geneNames;
    }

    public void drawMultiForrestPlot(String xAxisName, String[] yAxisNames, Double[][] xValues, String filename, Output output, double[] significanceThresholds, Double minX, Double maxX, int[] weights, byte[] chr, int[] chrpos, int metaRow) throws IOException, DocumentException {
        if (yAxisNames.length != xValues[0].length) {
            throw new IllegalArgumentException("Data length and number of row headers differ!");
        }
        Locale defaultLocale = Locale.getDefault();
        Locale.setDefault(Locale.US);
        Graphics2D g2d = null;
        Document document = null;
        PdfWriter writer = null;
        BufferedImage bi = null;
        int width = 1;
        int height = 1;
        bi = new BufferedImage(1, 1, 1);
        g2d = bi.createGraphics();
        g2d.setFont(LARGE_FONT);
        FontMetrics fontmetrics = g2d.getFontMetrics();
        int leftMargin = 10;
        int maxStringSize = 0;
        for (String s : yAxisNames) {
            maxStringSize = Math.max(maxStringSize, fontmetrics.stringWidth(s));
        }
        int topMargin = 10;
        int plotwidth = 100;
        int plotspacer = 20;
        int nrPlots = xValues.length;
        width = plotwidth * nrPlots + nrPlots * plotspacer + maxStringSize + leftMargin * 3;
        System.out.println(width);
        int textpadding = 5;
        int maxBoxSize = 20;
        int minBoxSize = 5;
        int fontheight = fontmetrics.getHeight();
        int geneNameMargin = 0;
        int geneBoxHeight = 15;
        if (this.geneNames != null) {
            geneNameMargin = leftMargin * 2 + geneBoxHeight + fontheight * 3;
        }
        height = yAxisNames.length * textpadding + 2 * textpadding + fontheight * yAxisNames.length + topMargin * 2 + geneNameMargin + fontheight + topMargin;
        System.out.println(height);
        PdfContentByte cb = null;
        if (output == Output.PDF) {
            Rectangle rectangle = new Rectangle((float)width, (float)height);
            document = new Document(rectangle);
            writer = PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(filename));
            document.open();
            cb = writer.getDirectContent();
            cb.saveState();
            g2d = cb.createGraphics((float)width, (float)height);
        } else {
            bi = new BufferedImage(width, height, 1);
            g2d = bi.createGraphics();
        }
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setColor(Color.white);
        g2d.fillRect(0, 0, width, height);
        g2d.setStroke(line);
        g2d.setColor(Color.gray);
        for (int row = 0; row < yAxisNames.length; ++row) {
            int textStartY = topMargin + fontheight + (row * fontheight + row * textpadding) + geneNameMargin;
            g2d.setFont(LARGE_FONT);
            g2d.drawString(yAxisNames[row], leftMargin, textStartY);
        }
        g2d.setColor(Color.black);
        for (int plotNr = 0; plotNr < nrPlots; ++plotNr) {
            int i;
            Double[] workValues = xValues[plotNr];
            double min = Double.MAX_VALUE;
            double max = Double.MIN_VALUE;
            if (maxX != null && minX != null) {
                max = maxX;
                min = minX;
            } else {
                for (int d = 0; d < workValues.length; ++d) {
                    if (workValues[d] == null) continue;
                    if (workValues[d] > max) {
                        max = workValues[d];
                    }
                    if (!(workValues[d] < min)) continue;
                    min = workValues[d];
                }
            }
            double origMin = min;
            double origMax = max;
            double absmin = 0.0;
            boolean correctValues = false;
            if (min < 0.0) {
                absmin = Math.abs(min);
                correctValues = true;
            }
            System.out.println("");
            if (correctValues) {
                min += absmin;
                max += absmin;
            } else {
                min -= absmin;
                max -= absmin;
            }
            Double[] correctedValues = new Double[workValues.length];
            for (int i2 = 0; i2 < correctedValues.length; ++i2) {
                if (workValues[i2] == null) continue;
                System.out.println(i2 + "\t" + workValues[i2]);
                correctedValues[i2] = correctValues ? Double.valueOf(workValues[i2] + absmin) : Double.valueOf(workValues[i2] - absmin);
                System.out.println(i2 + "\t" + correctedValues[i2]);
                Double[] doubleArray = correctedValues;
                int n = i2;
                Double.valueOf(doubleArray[n] / max);
                System.out.println(i2 + "\t" + correctedValues[i2]);
            }
            int plotStartX = leftMargin + maxStringSize + leftMargin + plotNr * plotspacer + plotNr * plotwidth;
            int plotStopX = plotStartX + plotwidth;
            int plotStartY = topMargin + geneNameMargin;
            int plotStopY = height - 2 * topMargin - fontheight;
            DecimalFormat df = new DecimalFormat("#.##");
            g2d.setColor(Color.gray);
            g2d.setFont(SMALL_FONT);
            int strWidth = this.getWidth(df.format(origMin), LARGE_FONT);
            g2d.drawString(df.format(origMin), plotStartX, plotStopY + 2 * leftMargin);
            strWidth = this.getWidth(df.format(origMax), LARGE_FONT);
            g2d.drawString(df.format(origMax), plotStopX - strWidth + 2, plotStopY + 2 * leftMargin);
            strWidth = this.getWidth(df.format(0.0), LARGE_FONT);
            g2d.drawString(df.format(0.0), plotStopX - plotwidth / 2 - strWidth + 3, plotStopY + 2 * leftMargin);
            g2d.setFont(LARGE_FONT);
            if (this.geneNames != null) {
                int geneBoxStartY = plotStartY - leftMargin * 2 - geneBoxHeight - fontheight * 3;
                g2d.setColor(Color.gray);
                double metaZ = workValues[metaRow];
                double upperSignificance = significanceThresholds[significanceThresholds.length - 1];
                int alpha = 255;
                if (Math.abs(metaZ) <= Math.abs(upperSignificance)) {
                    alpha = 126;
                }
                if (metaZ > 0.0) {
                    g2d.setColor(new Color(108, 189, 69, alpha));
                } else {
                    g2d.setColor(new Color(0, 174, 239, alpha));
                }
                Object c = null;
                g2d.fillRect(plotStartX, geneBoxStartY, plotwidth, geneBoxHeight);
                int textStartY = geneBoxStartY + geneBoxHeight + leftMargin + leftMargin;
                Rectangle2D pos = fontmetrics.getStringBounds(this.geneNames[plotNr], g2d);
                g2d.setColor(Color.gray);
                String chrStr = "Chr: " + ChrAnnotation.parseByte(chr[plotNr]);
                DecimalFormat df2 = new DecimalFormat("###,###,###,###,###");
                String chrPos = "Pos: " + df2.format(chrpos[plotNr]);
                g2d.setFont(LARGE_FONT_BOLD);
                g2d.drawString(this.geneNames[plotNr], plotStartX, textStartY);
                g2d.setFont(SMALL_FONT);
                g2d.drawString(chrStr, plotStartX, textStartY + fontheight);
                g2d.drawString(chrPos, plotStartX, textStartY + fontheight * 2);
                g2d.setFont(LARGE_FONT);
            }
            System.out.println("Min " + min + "\tmax " + max);
            g2d.setColor(Color.gray);
            int plotheight = plotStopY - plotStartY;
            g2d.setColor(gray1Color);
            g2d.fillRect(plotStartX, plotStartY, plotwidth, plotheight);
            g2d.setColor(Color.black);
            System.out.println("plot height: " + plotheight);
            System.out.println("plot width: " + plotwidth);
            System.out.println("start " + plotStartX);
            System.out.println("");
            if (significanceThresholds != null) {
                Color[] colors = new Color[]{new Color(120, 120, 120, 128), new Color(138, 138, 138, 128), new Color(197, 197, 197, 128), new Color(249, 249, 249, 128)};
                Arrays.sort(significanceThresholds);
                g2d.setStroke(dashed);
                for (int i3 = significanceThresholds.length - 1; i3 > -1; --i3) {
                    double val = significanceThresholds[i3];
                    System.out.println(i3 + "\t" + val);
                    val = correctValues ? (val += absmin) : (val -= absmin);
                    System.out.println(i3 + "\tminmax " + val);
                    System.out.println("Perc: " + (val /= max));
                    int nrPixels1 = (int)Math.floor(val * (double)plotwidth);
                    int nrPixels2 = plotwidth - nrPixels1;
                    System.out.println(i3 + "\tdivmax " + nrPixels1);
                    System.out.println(i3 + "\tdivmax " + nrPixels2);
                    int startX = plotStartX + nrPixels1;
                    int stopX = plotStartX + nrPixels2;
                    int startY = plotStartY;
                    int stopY = plotStopY;
                    int boxwidth = startX - stopX;
                    Color selected = null;
                    selected = i3 > colors.length ? colors[0] : colors[i3];
                    g2d.setColor(selected);
                    if (i3 > significanceThresholds.length - 2) {
                        g2d.setStroke(line2pt);
                        g2d.setColor(red1Color);
                    } else {
                        g2d.setStroke(dashed);
                        g2d.setColor(red2Color);
                    }
                    g2d.drawLine(startX, startY, startX, stopY);
                    g2d.drawLine(stopX, startY, stopX, stopY);
                    System.out.println(startX);
                    System.out.println(startY);
                    System.out.println(boxwidth);
                    System.out.println(plotheight);
                }
                g2d.setColor(Color.black);
            }
            g2d.setStroke(line);
            double[] sqrtwghts = new double[weights.length];
            double maxWght = 0.0;
            int nrTotalSamples = 0;
            for (i = 0; i < metaRow; ++i) {
                if (workValues[i] == null) continue;
                nrTotalSamples += weights[i];
            }
            sqrtwghts[metaRow] = Math.sqrt(nrTotalSamples);
            System.out.println("total samples: " + nrTotalSamples);
            maxWght = sqrtwghts[metaRow];
            for (i = 0; i < metaRow; ++i) {
                sqrtwghts[i] = Math.sqrt(weights[i]);
            }
            for (i = metaRow + 1; i < weights.length; ++i) {
                sqrtwghts[i] = Math.sqrt(weights[i]);
            }
            for (i = 0; i < correctedValues.length; ++i) {
                float br;
                float s;
                Double val = correctedValues[i];
                if (val == null) continue;
                int posX = plotStartX + (int)Math.floor(val * (double)plotwidth);
                int posY = topMargin + fontheight + fontheight * i + i * textpadding - textpadding / 2 + geneNameMargin;
                System.out.println(i + "\t" + val + "\t" + posX + "\t" + posY);
                double relativeWeight = sqrtwghts[i] / maxWght;
                double range = maxBoxSize - minBoxSize;
                System.out.println("rel. weight: " + weights.length + "\t" + sqrtwghts[i] + "\t" + relativeWeight);
                int boxSize = minBoxSize + (int)Math.ceil(range * relativeWeight);
                int halfbox = boxSize / 2;
                int x = posX - halfbox;
                int y = posY - halfbox;
                double realZ = Math.abs(workValues[i]);
                double percOfMax = realZ / origMax;
                int minAlpha = 75;
                int maxAlpha = 255;
                int actualAlpha = minAlpha + (int)Math.ceil((double)(maxAlpha - minAlpha) * percOfMax);
                Color c = null;
                float minBr = 0.5f;
                if (workValues[i] >= 0.0) {
                    System.out.println(yAxisNames[i] + "\tUp color: " + realZ);
                    s = (float)((double)0.63f * percOfMax);
                    br = minBr + (float)((double)0.74f * percOfMax);
                    if (br > 0.74f) {
                        br = 0.74f;
                    }
                    c = Color.getHSBColor(0.2777778f, s, br);
                } else {
                    s = (float)(1.0 * percOfMax);
                    br = minBr + (float)((double)0.93f * percOfMax);
                    if (br > 0.93f) {
                        br = 0.93f;
                    }
                    c = Color.getHSBColor(0.54444444f, s, br);
                }
                g2d.setColor(c);
                if (i == metaRow) {
                    g2d.fill(this.drawDiamond(x, y, boxSize, boxSize));
                } else {
                    g2d.fillRect(x, y, boxSize, boxSize);
                }
                g2d.setColor(Color.black);
            }
            g2d.setColor(Color.gray);
            g2d.setStroke(line2pt);
            g2d.drawLine(plotStartX + plotwidth / 2, plotStartY, plotStartX + plotwidth / 2, plotStopY);
            g2d.setStroke(line);
            g2d.setColor(Color.black);
        }
        g2d.dispose();
        if (output == Output.PDF) {
            g2d.dispose();
            cb.restoreState();
            document.close();
            writer.close();
        } else {
            bi.flush();
            ImageIO.write((RenderedImage)bi, output.toString().toLowerCase(), new File(filename));
        }
        Locale.setDefault(defaultLocale);
    }

    public int getWidth(String text, Font font) {
        Graphics2D g2d = new BufferedImage(1, 1, 2).createGraphics();
        TextLayout tL = new TextLayout(text, font, g2d.getFontRenderContext());
        return (int)tL.getBounds().getWidth();
    }

    public GeneralPath drawDiamond(int x, int y, int width, int height) {
        GeneralPath diamond = new GeneralPath(0, 4);
        diamond.moveTo(x += width / 2, y);
        diamond.lineTo(x += width / 2, y += height / 2);
        diamond.lineTo(x -= width / 2, y += height / 2);
        diamond.lineTo(x -= width / 2, y -= height / 2);
        return diamond;
    }

    public static enum Output {
        PDF,
        PNG;

    }
}

