/*
 * Decompiled with CFR 0.152.
 */
package umcg.genetica.genomicboundaries;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import umcg.genetica.genomicboundaries.GenomicBoundary;

public class GenomicBoundariesSimple {
    private HashMap<String, ArrayList<GenomicBoundary>> genomicsBoundaries = new HashMap();
    private static final Pattern TAB_PATTERN = Pattern.compile("\\t");
    private static final Pattern CHR_PATTERN = Pattern.compile("^chr(.*)$", 2);
    private int margin = 0;

    public GenomicBoundariesSimple(String genomicsBoundarysFilePath) throws FileNotFoundException, IOException {
        String line;
        BufferedReader genomicsBoundarysReader = new BufferedReader(new FileReader(genomicsBoundarysFilePath));
        while ((line = genomicsBoundarysReader.readLine()) != null) {
            ArrayList<Object> chromosomeBoundaries;
            String[] cells = TAB_PATTERN.split(line);
            String chromosme = GenomicBoundariesSimple.removeChr(cells[0]);
            Integer beginPoint = Integer.valueOf(cells[1]);
            int endPoint = Integer.parseInt(cells[2]);
            if (!this.genomicsBoundaries.containsKey(chromosme)) {
                chromosomeBoundaries = new ArrayList();
                this.genomicsBoundaries.put(chromosme, chromosomeBoundaries);
            } else {
                chromosomeBoundaries = this.genomicsBoundaries.get(chromosme);
            }
            GenomicBoundary genomicBoundary = new GenomicBoundary(chromosme, beginPoint, endPoint);
            chromosomeBoundaries.add(genomicBoundary);
        }
    }

    public GenomicBoundariesSimple(String genomicsBoundarysFilePath, int margin) throws FileNotFoundException, IOException {
        this(genomicsBoundarysFilePath);
        this.margin = margin;
    }

    public boolean isChromosomeInBoundary(String chromosome) {
        return this.genomicsBoundaries.containsKey(chromosome);
    }

    public Set<String> getChromosomes() {
        return this.genomicsBoundaries.keySet();
    }

    public boolean isInBoundary(String chromosome, int position) {
        return this.getBoundary(chromosome, position) != null;
    }

    public GenomicBoundary getBoundary(String chromosome, int position) {
        if (this.isChromosomeInBoundary(chromosome)) {
            for (GenomicBoundary boundary : this.genomicsBoundaries.get(chromosome)) {
                if (!boundary.isInBoundarie(position, this.margin)) continue;
                return boundary;
            }
            return null;
        }
        return null;
    }

    private static String removeChr(String chromosome) {
        Matcher chrMatcher = CHR_PATTERN.matcher(chromosome);
        if (chrMatcher.find()) {
            return chrMatcher.group(1);
        }
        return chromosome;
    }
}

