/*
 * Decompiled with CFR 0.152.
 */
package umcg.genetica.collections;

import com.google.common.collect.Iterators;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.HashMap;
import java.util.Iterator;

public class ChrPosMap<E>
implements Iterable<E> {
    private final HashMap<String, TIntObjectMap<E>> data = new HashMap();

    public void put(String chr, int pos, E element) {
        TIntObjectHashMap chrElements = this.data.get(chr);
        if (chrElements == null) {
            chrElements = new TIntObjectHashMap();
            this.data.put(chr, (TIntObjectMap<E>)chrElements);
        }
        chrElements.put(pos, element);
    }

    public E get(String chr, int pos) {
        TIntObjectMap<E> chrElements = this.data.get(chr);
        if (chrElements == null) {
            return null;
        }
        return (E)chrElements.get(pos);
    }

    public E remove(String chr, int pos) {
        TIntObjectMap<E> chrElements = this.data.get(chr);
        if (chrElements == null) {
            return null;
        }
        return (E)chrElements.remove(pos);
    }

    public Iterator<E> chrIterator(String chr) {
        TIntObjectMap<E> chrElements = this.data.get(chr);
        if (chrElements == null) {
            return null;
        }
        return chrElements.valueCollection().iterator();
    }

    @Override
    public Iterator<E> iterator() {
        Iterator[] chrIterators = new Iterator[this.data.size()];
        int i = 0;
        for (TIntObjectMap<E> chrData : this.data.values()) {
            chrIterators[i] = chrData.valueCollection().iterator();
            ++i;
        }
        return Iterators.concat((Iterator[])chrIterators);
    }

    public int size() {
        int count = 0;
        for (TIntObjectMap<E> chrResults : this.data.values()) {
            count += chrResults.size();
        }
        return count;
    }
}

