/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.random.tdouble;

import cern.jet.math.tdouble.DoubleArithmetic;
import cern.jet.random.tdouble.AbstractDiscreteDistribution;
import cern.jet.random.tdouble.engine.DoubleRandomEngine;

public class HyperGeometric
extends AbstractDiscreteDistribution {
    private static final long serialVersionUID = 1L;
    protected int my_N;
    protected int my_s;
    protected int my_n;
    private int N_last = -1;
    private int M_last = -1;
    private int n_last = -1;
    private int N_Mn;
    private int m;
    private int mp;
    private int b;
    private double Mp;
    private double np;
    private double fm;
    private int k2;
    private int k4;
    private int k1;
    private int k5;
    private double dl;
    private double dr;
    private double r1;
    private double r2;
    private double r4;
    private double r5;
    private double ll;
    private double lr;
    private double c_pm;
    private double f1;
    private double f2;
    private double f4;
    private double f5;
    private double p1;
    private double p2;
    private double p3;
    private double p4;
    private double p5;
    private double p6;
    protected static HyperGeometric shared = new HyperGeometric(1, 1, 1, HyperGeometric.makeDefaultGenerator());

    public HyperGeometric(int N, int s, int n, DoubleRandomEngine randomGenerator) {
        this.setRandomGenerator(randomGenerator);
        this.setState(N, s, n);
    }

    private static double fc_lnpk(int k, int N_Mn, int M, int n) {
        return DoubleArithmetic.logFactorial(k) + DoubleArithmetic.logFactorial(M - k) + DoubleArithmetic.logFactorial(n - k) + DoubleArithmetic.logFactorial(N_Mn + k);
    }

    protected int hmdu(int N, int M, int n, DoubleRandomEngine randomGenerator) {
        if (N != this.N_last || M != this.M_last || n != this.n_last) {
            this.N_last = N;
            this.M_last = M;
            this.n_last = n;
            this.Mp = M + 1;
            this.np = n + 1;
            this.N_Mn = N - M - n;
            double p = this.Mp / ((double)N + 2.0);
            double nu = this.np * p;
            this.m = (int)nu;
            this.mp = (double)this.m == nu && p == 0.5 ? this.m-- : this.m + 1;
            this.fm = Math.exp(DoubleArithmetic.logFactorial(N - M) - DoubleArithmetic.logFactorial(this.N_Mn + this.m) - DoubleArithmetic.logFactorial(n - this.m) + DoubleArithmetic.logFactorial(M) - DoubleArithmetic.logFactorial(M - this.m) - DoubleArithmetic.logFactorial(this.m) - DoubleArithmetic.logFactorial(N) + DoubleArithmetic.logFactorial(N - n) + DoubleArithmetic.logFactorial(n));
            this.b = (int)(nu + 11.0 * Math.sqrt(nu * (1.0 - p) * (1.0 - (double)n / (double)N) + 1.0));
            if (this.b > n) {
                this.b = n;
            }
        }
        block0: while (true) {
            int K;
            double d;
            double d2;
            double U = randomGenerator.raw() - this.fm;
            if (d2 <= 0.0) {
                return this.m;
            }
            double c = d = this.fm;
            for (int I = 1; I <= this.m; ++I) {
                double d3;
                double d4;
                K = this.mp - I;
                U -= (c *= (double)K / (this.np - (double)K) * ((double)(this.N_Mn + K) / (this.Mp - (double)K)));
                if (d4 <= 0.0) {
                    return K - 1;
                }
                K = this.m + I;
                U -= (d *= (this.np - (double)K) / (double)K * ((this.Mp - (double)K) / (double)(this.N_Mn + K)));
                if (!(d3 <= 0.0)) continue;
                return K;
            }
            K = this.mp + this.m;
            while (true) {
                double d5;
                if (K > this.b) continue block0;
                U -= (d *= (this.np - (double)K) / (double)K * ((this.Mp - (double)K) / (double)(this.N_Mn + K)));
                if (d5 <= 0.0) {
                    return K;
                }
                ++K;
            }
            break;
        }
    }

    protected int hprs(int N, int M, int n, DoubleRandomEngine randomGenerator) {
        int X;
        double U;
        if (N != this.N_last || M != this.M_last || n != this.n_last) {
            this.N_last = N;
            this.M_last = M;
            this.n_last = n;
            double Mp = M + 1;
            double np = n + 1;
            this.N_Mn = N - M - n;
            double p = Mp / ((double)N + 2.0);
            double nu = np * p;
            U = Math.sqrt(nu * (1.0 - p) * (1.0 - ((double)n + 2.0) / ((double)N + 3.0)) + 0.25);
            this.m = (int)nu;
            this.k2 = (int)Math.ceil(nu - 0.5 - U);
            if (this.k2 >= this.m) {
                this.k2 = this.m - 1;
            }
            this.k4 = (int)(nu - 0.5 + U);
            this.k1 = this.k2 + this.k2 - this.m + 1;
            this.k5 = this.k4 + this.k4 - this.m;
            this.dl = this.k2 - this.k1;
            this.dr = this.k5 - this.k4;
            this.r1 = (np / (double)this.k1 - 1.0) * (Mp - (double)this.k1) / (double)(this.N_Mn + this.k1);
            this.r2 = (np / (double)this.k2 - 1.0) * (Mp - (double)this.k2) / (double)(this.N_Mn + this.k2);
            this.r4 = (np / (double)(this.k4 + 1) - 1.0) * (double)(M - this.k4) / (double)(this.N_Mn + this.k4 + 1);
            this.r5 = (np / (double)(this.k5 + 1) - 1.0) * (double)(M - this.k5) / (double)(this.N_Mn + this.k5 + 1);
            this.ll = Math.log(this.r1);
            this.lr = -Math.log(this.r5);
            this.c_pm = HyperGeometric.fc_lnpk(this.m, this.N_Mn, M, n);
            this.f2 = Math.exp(this.c_pm - HyperGeometric.fc_lnpk(this.k2, this.N_Mn, M, n));
            this.f4 = Math.exp(this.c_pm - HyperGeometric.fc_lnpk(this.k4, this.N_Mn, M, n));
            this.f1 = Math.exp(this.c_pm - HyperGeometric.fc_lnpk(this.k1, this.N_Mn, M, n));
            this.f5 = Math.exp(this.c_pm - HyperGeometric.fc_lnpk(this.k5, this.N_Mn, M, n));
            this.p1 = this.f2 * (this.dl + 1.0);
            this.p2 = this.f2 * this.dl + this.p1;
            this.p3 = this.f4 * (this.dr + 1.0) + this.p2;
            this.p4 = this.f4 * this.dr + this.p3;
            this.p5 = this.f1 / this.ll + this.p4;
            this.p6 = this.f5 / this.lr + this.p5;
        }
        while (true) {
            int V;
            int Dk;
            double Y;
            double W;
            double d;
            U = randomGenerator.raw() * this.p6;
            if (d < this.p2) {
                double d2;
                double d3;
                double d4;
                W = U - this.p1;
                if (d4 < 0.0) {
                    return this.k2 + (int)(U / this.f2);
                }
                Y = W / this.dl;
                if (d3 < this.f1) {
                    return this.k1 + (int)(W / this.f1);
                }
                Dk = (int)(this.dl * randomGenerator.raw()) + 1;
                if (Y <= this.f2 - (double)Dk * (this.f2 - this.f2 / this.r2)) {
                    return this.k2 - Dk;
                }
                W = this.f2 + this.f2 - Y;
                if (d2 < 1.0) {
                    V = this.k2 + Dk;
                    if (W <= this.f2 + (double)Dk * (1.0 - this.f2) / (this.dl + 1.0)) {
                        return V;
                    }
                    if (Math.log(W) <= this.c_pm - HyperGeometric.fc_lnpk(V, this.N_Mn, M, n)) {
                        return V;
                    }
                }
                X = this.k2 - Dk;
            } else if (U < this.p4) {
                double d5;
                double d6;
                double d7;
                W = U - this.p3;
                if (d7 < 0.0) {
                    return this.k4 - (int)((U - this.p2) / this.f4);
                }
                Y = W / this.dr;
                if (d6 < this.f5) {
                    return this.k5 - (int)(W / this.f5);
                }
                Dk = (int)(this.dr * randomGenerator.raw()) + 1;
                if (Y <= this.f4 - (double)Dk * (this.f4 - this.f4 * this.r4)) {
                    return this.k4 + Dk;
                }
                W = this.f4 + this.f4 - Y;
                if (d5 < 1.0) {
                    V = this.k4 - Dk;
                    if (W <= this.f4 + (double)Dk * (1.0 - this.f4) / this.dr) {
                        return V;
                    }
                    if (Math.log(W) <= this.c_pm - HyperGeometric.fc_lnpk(V, this.N_Mn, M, n)) {
                        return V;
                    }
                }
                X = this.k4 + Dk;
            } else {
                Y = randomGenerator.raw();
                if (U < this.p5) {
                    Dk = (int)(1.0 - Math.log(Y) / this.ll);
                    X = this.k1 - Dk;
                    if (X < 0) continue;
                    if ((Y *= (U - this.p4) * this.ll) <= this.f1 - (double)Dk * (this.f1 - this.f1 / this.r1)) {
                        return X;
                    }
                } else {
                    Dk = (int)(1.0 - Math.log(Y) / this.lr);
                    X = this.k5 + Dk;
                    if (X > n) continue;
                    if ((Y *= (U - this.p5) * this.lr) <= this.f5 - (double)Dk * (this.f5 - this.f5 * this.r5)) {
                        return X;
                    }
                }
            }
            if (Math.log(Y) <= this.c_pm - HyperGeometric.fc_lnpk(X, this.N_Mn, M, n)) break;
        }
        return X;
    }

    public int nextInt() {
        return this.nextInt(this.my_N, this.my_s, this.my_n, this.randomGenerator);
    }

    public int nextInt(int N, int s, int n) {
        return this.nextInt(N, s, n, this.randomGenerator);
    }

    protected int nextInt(int N, int M, int n, DoubleRandomEngine randomGenerator) {
        int K;
        int M_le_Nhalf;
        int Nhalf = N / 2;
        int n_le_Nhalf = n <= Nhalf ? n : N - n;
        int n2 = M_le_Nhalf = M <= Nhalf ? M : N - M;
        if (n * M / N < 10) {
            K = n_le_Nhalf <= M_le_Nhalf ? this.hmdu(N, M_le_Nhalf, n_le_Nhalf, randomGenerator) : this.hmdu(N, n_le_Nhalf, M_le_Nhalf, randomGenerator);
        } else {
            int n3 = K = n_le_Nhalf <= M_le_Nhalf ? this.hprs(N, M_le_Nhalf, n_le_Nhalf, randomGenerator) : this.hprs(N, n_le_Nhalf, M_le_Nhalf, randomGenerator);
        }
        if (n <= Nhalf) {
            return M <= Nhalf ? K : n - K;
        }
        return M <= Nhalf ? M - K : n - N + M + K;
    }

    public double pdf(int k) {
        return DoubleArithmetic.binomial(this.my_s, (long)k) * DoubleArithmetic.binomial(this.my_N - this.my_s, (long)(this.my_n - k)) / DoubleArithmetic.binomial(this.my_N, (long)this.my_n);
    }

    public void setState(int N, int s, int n) {
        this.my_N = N;
        this.my_s = s;
        this.my_n = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double staticNextInt(int N, int M, int n) {
        HyperGeometric hyperGeometric = shared;
        synchronized (hyperGeometric) {
            return shared.nextInt(N, M, n);
        }
    }

    public String toString() {
        return this.getClass().getName() + "(" + this.my_N + "," + this.my_s + "," + this.my_n + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void xstaticSetRandomGenerator(DoubleRandomEngine randomGenerator) {
        HyperGeometric hyperGeometric = shared;
        synchronized (hyperGeometric) {
            shared.setRandomGenerator(randomGenerator);
        }
    }
}

