/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.random.engine;

import cern.colt.Timer;
import cern.jet.random.tdouble.engine.DRand;
import cern.jet.random.tdouble.engine.DoubleMersenneTwister;
import cern.jet.random.tdouble.engine.DoubleRandomEngine;
import cern.jet.random.tdouble.engine.MersenneTwister64;
import java.util.Random;

public class Benchmark {
    protected Benchmark() {
        throw new RuntimeException("Non instantiable");
    }

    public static void benchmark(int times) {
        Timer timer = new Timer();
        timer.reset().start();
        int i = times;
        while (--i >= 0) {
        }
        timer.stop().display();
        double emptyLoop = timer.elapsedTime();
        System.out.println("empty loop timing done.");
        DoubleRandomEngine gen = new DoubleMersenneTwister();
        System.out.println("\n MersenneTwister:");
        timer.reset().start();
        int i2 = times;
        while (--i2 >= 0) {
            gen.raw();
        }
        timer.stop().display();
        System.out.println((double)times / (timer.elapsedTime() - emptyLoop) + " numbers per second.");
        gen = new MersenneTwister64();
        System.out.println("\n MersenneTwister64:");
        timer.reset().start();
        i2 = times;
        while (--i2 >= 0) {
            gen.raw();
        }
        timer.stop().display();
        System.out.println((double)times / (timer.elapsedTime() - emptyLoop) + " numbers per second.");
        gen = new DRand();
        System.out.println("\nDRand:");
        timer.reset().start();
        i2 = times;
        while (--i2 >= 0) {
            gen.raw();
        }
        timer.stop().display();
        System.out.println((double)times / (timer.elapsedTime() - emptyLoop) + " numbers per second.");
        Random javaGen = new Random();
        System.out.println("\njava.util.Random.nextFloat():");
        timer.reset().start();
        int i3 = times;
        while (--i3 >= 0) {
            javaGen.nextFloat();
        }
        timer.stop().display();
        System.out.println((double)times / (timer.elapsedTime() - emptyLoop) + " numbers per second.");
        System.out.println("\nGood bye.\n");
    }

    public static void main(String[] args) {
        long from = Long.parseLong(args[0]);
        long to = Long.parseLong(args[1]);
        int times = Integer.parseInt(args[2]);
        int runs = Integer.parseInt(args[3]);
        for (int i = 0; i < runs; ++i) {
            Benchmark.benchmark(times);
        }
    }

    public static void test(int size, DoubleRandomEngine randomEngine) {
        System.out.println("\n\nint():");
        DoubleRandomEngine random = (DoubleRandomEngine)randomEngine.clone();
        int j = 0;
        int i = size;
        while (--i >= 0) {
            System.out.print(" " + random.nextInt());
            if (j % 8 == 7) {
                System.out.println();
            }
            ++j;
        }
        System.out.println("\n\nGood bye.\n");
    }

    private static void xtestRandomFromTo(long from, long to, int times) {
        System.out.println("from=" + from + ", to=" + to);
        Random randomJava = new Random();
        DoubleMersenneTwister random = new DoubleMersenneTwister();
        int _from = (int)from;
        int _to = (int)to;
        Timer timer = new Timer().start();
        int j = 0;
        int i = times;
        while (--i >= 0) {
            System.out.print(" " + random.raw());
            if (j % 8 == 7) {
                System.out.println();
            }
            ++j;
        }
        timer.stop().display();
        System.out.println("Good bye.\n");
    }
}

