/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.math.tfloat;

import cern.colt.Timer;
import cern.colt.function.tfloat.FloatFloatFunction;
import cern.colt.function.tfloat.FloatFloatProcedure;
import cern.colt.function.tfloat.FloatFunction;
import cern.colt.function.tfloat.FloatProcedure;
import cern.jet.math.tfloat.FloatMult;
import cern.jet.math.tfloat.FloatPlusMultFirst;
import cern.jet.math.tfloat.FloatPlusMultSecond;

public class FloatFunctions {
    public static final FloatFunctions functions = new FloatFunctions();
    public static final FloatFunction abs = new FloatFunction(){

        public final float apply(float a) {
            return Math.abs(a);
        }
    };
    public static final FloatFunction acos = new FloatFunction(){

        public final float apply(float a) {
            return (float)Math.acos(a);
        }
    };
    public static final FloatFunction asin = new FloatFunction(){

        public final float apply(float a) {
            return (float)Math.asin(a);
        }
    };
    public static final FloatFunction atan = new FloatFunction(){

        public final float apply(float a) {
            return (float)Math.atan(a);
        }
    };
    public static final FloatFunction ceil = new FloatFunction(){

        public final float apply(float a) {
            return (float)Math.ceil(a);
        }
    };
    public static final FloatFunction cos = new FloatFunction(){

        public final float apply(float a) {
            return (float)Math.cos(a);
        }
    };
    public static final FloatFunction exp = new FloatFunction(){

        public final float apply(float a) {
            return (float)Math.exp(a);
        }
    };
    public static final FloatFunction floor = new FloatFunction(){

        public final float apply(float a) {
            return (float)Math.floor(a);
        }
    };
    public static final FloatFunction identity = new FloatFunction(){

        public final float apply(float a) {
            return a;
        }
    };
    public static final FloatFunction inv = new FloatFunction(){

        public final float apply(float a) {
            return (float)(1.0 / (double)a);
        }
    };
    public static final FloatFunction log = new FloatFunction(){

        public final float apply(float a) {
            return (float)Math.log(a);
        }
    };
    public static final FloatFunction log2 = new FloatFunction(){

        public final float apply(float a) {
            return (float)(Math.log(a) * 1.4426950408889634);
        }
    };
    public static final FloatFunction neg = new FloatFunction(){

        public final float apply(float a) {
            return -a;
        }
    };
    public static final FloatFunction rint = new FloatFunction(){

        public final float apply(float a) {
            return (float)Math.rint(a);
        }
    };
    public static final FloatFunction sign = new FloatFunction(){

        public final float apply(float a) {
            return a < 0.0f ? -1.0f : (a > 0.0f ? 1.0f : 0.0f);
        }
    };
    public static final FloatFunction sin = new FloatFunction(){

        public final float apply(float a) {
            return (float)Math.sin(a);
        }
    };
    public static final FloatFunction sqrt = new FloatFunction(){

        public final float apply(float a) {
            return (float)Math.sqrt(a);
        }
    };
    public static final FloatFunction square = new FloatFunction(){

        public final float apply(float a) {
            return a * a;
        }
    };
    public static final FloatFunction tan = new FloatFunction(){

        public final float apply(float a) {
            return (float)Math.tan(a);
        }
    };
    public static final FloatFloatFunction atan2 = new FloatFloatFunction(){

        public final float apply(float a, float b) {
            return (float)Math.atan2(a, b);
        }
    };
    public static final FloatFloatFunction compare = new FloatFloatFunction(){

        public final float apply(float a, float b) {
            return a < b ? -1.0f : (a > b ? 1.0f : 0.0f);
        }
    };
    public static final FloatFloatFunction div = new FloatFloatFunction(){

        public final float apply(float a, float b) {
            return a / b;
        }
    };
    public static final FloatFloatFunction divNeg = new FloatFloatFunction(){

        public final float apply(float a, float b) {
            return -(a / b);
        }
    };
    public static final FloatFloatFunction equals = new FloatFloatFunction(){

        public final float apply(float a, float b) {
            return a == b ? 1.0f : 0.0f;
        }
    };
    public static final FloatFloatFunction greater = new FloatFloatFunction(){

        public final float apply(float a, float b) {
            return a > b ? 1.0f : 0.0f;
        }
    };
    public static final FloatFloatFunction IEEEremainder = new FloatFloatFunction(){

        public final float apply(float a, float b) {
            return (float)Math.IEEEremainder(a, b);
        }
    };
    public static final FloatFloatProcedure isEqual = new FloatFloatProcedure(){

        public final boolean apply(float a, float b) {
            return a == b;
        }
    };
    public static final FloatFloatProcedure isLess = new FloatFloatProcedure(){

        public final boolean apply(float a, float b) {
            return a < b;
        }
    };
    public static final FloatFloatProcedure isGreater = new FloatFloatProcedure(){

        public final boolean apply(float a, float b) {
            return a > b;
        }
    };
    public static final FloatFloatFunction less = new FloatFloatFunction(){

        public final float apply(float a, float b) {
            return a < b ? 1.0f : 0.0f;
        }
    };
    public static final FloatFloatFunction lg = new FloatFloatFunction(){

        public final float apply(float a, float b) {
            return (float)(Math.log(a) / Math.log(b));
        }
    };
    public static final FloatFloatFunction max = new FloatFloatFunction(){

        public final float apply(float a, float b) {
            return Math.max(a, b);
        }
    };
    public static final FloatFloatFunction min = new FloatFloatFunction(){

        public final float apply(float a, float b) {
            return Math.min(a, b);
        }
    };
    public static final FloatFloatFunction minus = FloatFunctions.plusMultSecond(-1.0f);
    public static final FloatFloatFunction mod = new FloatFloatFunction(){

        public final float apply(float a, float b) {
            return a % b;
        }
    };
    public static final FloatFloatFunction mult = new FloatFloatFunction(){

        public final float apply(float a, float b) {
            return a * b;
        }
    };
    public static final FloatFloatFunction multNeg = new FloatFloatFunction(){

        public final float apply(float a, float b) {
            return -(a * b);
        }
    };
    public static final FloatFloatFunction multSquare = new FloatFloatFunction(){

        public final float apply(float a, float b) {
            return a * b * b;
        }
    };
    public static final FloatFloatFunction plus = FloatFunctions.plusMultSecond(1.0f);
    public static final FloatFloatFunction plusAbs = new FloatFloatFunction(){

        public final float apply(float a, float b) {
            return Math.abs(a) + Math.abs(b);
        }
    };
    public static final FloatFloatFunction pow = new FloatFloatFunction(){

        public final float apply(float a, float b) {
            return (float)Math.pow(a, b);
        }
    };

    protected FloatFunctions() {
    }

    public static FloatFunction between(final float from, final float to) {
        return new FloatFunction(){

            public final float apply(float a) {
                return from <= a && a <= to ? 1.0f : 0.0f;
            }
        };
    }

    public static FloatFunction bindArg1(final FloatFloatFunction function, final float c) {
        return new FloatFunction(){

            public final float apply(float var) {
                return function.apply(c, var);
            }
        };
    }

    public static FloatFunction bindArg2(final FloatFloatFunction function, final float c) {
        return new FloatFunction(){

            public final float apply(float var) {
                return function.apply(var, c);
            }
        };
    }

    public static FloatFloatFunction chain(final FloatFloatFunction f, final FloatFunction g, final FloatFunction h) {
        return new FloatFloatFunction(){

            public final float apply(float a, float b) {
                return f.apply(g.apply(a), h.apply(b));
            }
        };
    }

    public static FloatFloatFunction chain(final FloatFunction g, final FloatFloatFunction h) {
        return new FloatFloatFunction(){

            public final float apply(float a, float b) {
                return g.apply(h.apply(a, b));
            }
        };
    }

    public static FloatFunction chain(final FloatFunction g, final FloatFunction h) {
        return new FloatFunction(){

            public final float apply(float a) {
                return g.apply(h.apply(a));
            }
        };
    }

    public static FloatFunction compare(final float b) {
        return new FloatFunction(){

            public final float apply(float a) {
                return a < b ? -1.0f : (a > b ? 1.0f : 0.0f);
            }
        };
    }

    public static FloatFunction constant(final float c) {
        return new FloatFunction(){

            public final float apply(float a) {
                return c;
            }
        };
    }

    public static void demo1() {
        FloatFunctions F = functions;
        float a = 0.5f;
        float b = 0.2f;
        float v = (float)(Math.sin(a) + Math.pow(Math.cos(b), 2.0));
        System.out.println(v);
        FloatFloatFunction f = FloatFunctions.chain(plus, sin, FloatFunctions.chain(square, cos));
        System.out.println(f.apply(a, b));
        FloatFloatFunction g = new FloatFloatFunction(){

            public final float apply(float x, float y) {
                return (float)(Math.sin(x) + Math.pow(Math.cos(y), 2.0));
            }
        };
        System.out.println(g.apply(a, b));
        FloatFunction m = FloatFunctions.plus(3.0f);
        FloatFunction n = FloatFunctions.plus(4.0f);
        System.out.println(m.apply(0.0f));
        System.out.println(n.apply(0.0f));
    }

    public static void demo2(int size) {
        FloatFunctions F = functions;
        System.out.println("\n\n");
        float a = 0.0f;
        float b = 0.0f;
        float v = (float)Math.abs(Math.sin(a) + Math.pow(Math.cos(b), 2.0));
        System.out.println(v);
        FloatFloatFunction f = FloatFunctions.chain(abs, FloatFunctions.chain(plus, sin, FloatFunctions.chain(square, cos)));
        System.out.println(f.apply(a, b));
        FloatFloatFunction g = new FloatFloatFunction(){

            public final float apply(float x, float y) {
                return (float)Math.abs(Math.sin(x) + Math.pow(Math.cos(y), 2.0));
            }
        };
        System.out.println(g.apply(a, b));
        Timer emptyLoop = new Timer().start();
        a = 0.0f;
        b = 0.0f;
        float sum = 0.0f;
        int i = size;
        while (--i >= 0) {
            sum += a;
            a += 1.0f;
            b += 1.0f;
        }
        emptyLoop.stop().display();
        System.out.println("empty sum=" + sum);
        Timer timer = new Timer().start();
        a = 0.0f;
        b = 0.0f;
        sum = 0.0f;
        int i2 = size;
        while (--i2 >= 0) {
            sum = (float)((double)sum + Math.abs(Math.sin(a) + Math.pow(Math.cos(b), 2.0)));
            a += 1.0f;
            b += 1.0f;
        }
        timer.stop().display();
        System.out.println("evals / sec = " + (double)size / timer.minus(emptyLoop).seconds());
        System.out.println("sum=" + sum);
        timer.reset().start();
        a = 0.0f;
        b = 0.0f;
        sum = 0.0f;
        i2 = size;
        while (--i2 >= 0) {
            sum += f.apply(a, b);
            a += 1.0f;
            b += 1.0f;
        }
        timer.stop().display();
        System.out.println("evals / sec = " + (double)size / timer.minus(emptyLoop).seconds());
        System.out.println("sum=" + sum);
        timer.reset().start();
        a = 0.0f;
        b = 0.0f;
        sum = 0.0f;
        i2 = size;
        while (--i2 >= 0) {
            sum += g.apply(a, b);
            a += 1.0f;
            b += 1.0f;
        }
        timer.stop().display();
        System.out.println("evals / sec = " + (double)size / timer.minus(emptyLoop).seconds());
        System.out.println("sum=" + sum);
    }

    public static FloatFunction div(float b) {
        return FloatFunctions.mult(1.0f / b);
    }

    public static FloatFunction equals(final float b) {
        return new FloatFunction(){

            public final float apply(float a) {
                return a == b ? 1.0f : 0.0f;
            }
        };
    }

    public static FloatFunction greater(final float b) {
        return new FloatFunction(){

            public final float apply(float a) {
                return a > b ? 1.0f : 0.0f;
            }
        };
    }

    public static FloatFunction IEEEremainder(final float b) {
        return new FloatFunction(){

            public final float apply(float a) {
                return (float)Math.IEEEremainder(a, b);
            }
        };
    }

    public static FloatProcedure isBetween(final float from, final float to) {
        return new FloatProcedure(){

            public final boolean apply(float a) {
                return from <= a && a <= to;
            }
        };
    }

    public static FloatProcedure isEqual(final float b) {
        return new FloatProcedure(){

            public final boolean apply(float a) {
                return a == b;
            }
        };
    }

    public static FloatProcedure isGreater(final float b) {
        return new FloatProcedure(){

            public final boolean apply(float a) {
                return a > b;
            }
        };
    }

    public static FloatProcedure isLess(final float b) {
        return new FloatProcedure(){

            public final boolean apply(float a) {
                return a < b;
            }
        };
    }

    public static FloatFunction less(final float b) {
        return new FloatFunction(){

            public final float apply(float a) {
                return a < b ? 1.0f : 0.0f;
            }
        };
    }

    public static FloatFunction lg(final float b) {
        return new FloatFunction(){
            private final double logInv;
            {
                this.logInv = 1.0 / Math.log(b);
            }

            public final float apply(float a) {
                return (float)(Math.log(a) * this.logInv);
            }
        };
    }

    protected static void main(String[] args) {
        int size = Integer.parseInt(args[0]);
        FloatFunctions.demo2(size);
    }

    public static FloatFunction max(final float b) {
        return new FloatFunction(){

            public final float apply(float a) {
                return Math.max(a, b);
            }
        };
    }

    public static FloatFunction min(final float b) {
        return new FloatFunction(){

            public final float apply(float a) {
                return Math.min(a, b);
            }
        };
    }

    public static FloatFunction minus(float b) {
        return FloatFunctions.plus(-b);
    }

    public static FloatFloatFunction minusMult(float constant) {
        return FloatFunctions.plusMultSecond(-constant);
    }

    public static FloatFunction mod(final float b) {
        return new FloatFunction(){

            public final float apply(float a) {
                return a % b;
            }
        };
    }

    public static FloatFunction mult(float b) {
        return new FloatMult(b);
    }

    public static FloatFunction plus(final float b) {
        return new FloatFunction(){

            public final float apply(float a) {
                return a + b;
            }
        };
    }

    public static FloatFloatFunction multSecond(final float constant) {
        return new FloatFloatFunction(){

            public final float apply(float a, float b) {
                return b * constant;
            }
        };
    }

    public static FloatFloatFunction plusMultSecond(float constant) {
        return new FloatPlusMultSecond(constant);
    }

    public static FloatFloatFunction plusMultFirst(float constant) {
        return new FloatPlusMultFirst(constant);
    }

    public static FloatFunction pow(final float b) {
        return new FloatFunction(){

            public final float apply(float a) {
                return (float)Math.pow(a, b);
            }
        };
    }

    public static FloatFunction random() {
        return new RandomFloatFunction();
    }

    public static FloatFunction round(final float precision) {
        return new FloatFunction(){

            public final float apply(float a) {
                return (float)(Math.rint(a / precision) * (double)precision);
            }
        };
    }

    public static FloatFloatFunction swapArgs(final FloatFloatFunction function) {
        return new FloatFloatFunction(){

            public final float apply(float a, float b) {
                return function.apply(b, a);
            }
        };
    }

    private static class RandomFloatFunction
    implements FloatFunction {
        private RandomFloatFunction() {
        }

        public float apply(float argument) {
            return (float)Math.random();
        }
    }
}

