/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tint.impl;

import cern.colt.matrix.tint.IntMatrix1D;
import cern.colt.matrix.tint.IntMatrix2D;
import cern.colt.matrix.tint.impl.DenseIntMatrix1D;
import cern.colt.matrix.tint.impl.WrapperIntMatrix2D;

public class DenseLargeIntMatrix2D
extends WrapperIntMatrix2D {
    private static final long serialVersionUID = 1L;
    private int[][] elements;

    public DenseLargeIntMatrix2D(int rows, int columns) {
        block2: {
            super(null);
            try {
                this.setUp(rows, columns);
            }
            catch (IllegalArgumentException exc) {
                if ("matrix too large".equals(exc.getMessage())) break block2;
                throw exc;
            }
        }
        this.elements = new int[rows][columns];
        this.content = this;
    }

    public int getQuick(int row, int column) {
        return this.elements[row][column];
    }

    public void setQuick(int row, int column, int value) {
        this.elements[row][column] = value;
    }

    public int[][] elements() {
        return this.elements;
    }

    protected IntMatrix2D getContent() {
        return this;
    }

    public IntMatrix2D like(int rows, int columns) {
        return new DenseLargeIntMatrix2D(rows, columns);
    }

    public IntMatrix1D like1D(int size) {
        return new DenseIntMatrix1D(size);
    }
}

