/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tint;

import cern.colt.PersistentObject;
import cern.colt.list.tint.AbstractIntList;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.tint.IntMatrix1D;
import cern.colt.matrix.tint.impl.DenseIntMatrix1D;
import cern.colt.matrix.tint.impl.SparseIntMatrix1D;
import cern.jet.math.tint.IntFunctions;
import cern.jet.random.tdouble.engine.DoubleMersenneTwister;
import cern.jet.random.tdouble.sampling.DoubleRandomSamplingAssistant;

public class IntFactory1D
extends PersistentObject {
    private static final long serialVersionUID = 1L;
    public static final IntFactory1D dense = new IntFactory1D();
    public static final IntFactory1D sparse = new IntFactory1D();

    protected IntFactory1D() {
    }

    public IntMatrix1D append(IntMatrix1D A, IntMatrix1D B) {
        IntMatrix1D matrix = this.make((int)(A.size() + B.size()));
        matrix.viewPart(0, (int)A.size()).assign(A);
        matrix.viewPart((int)A.size(), (int)B.size()).assign(B);
        return matrix;
    }

    public IntMatrix1D ascending(int size) {
        IntFunctions F = IntFunctions.intFunctions;
        return this.descending(size).assign(IntFunctions.chain(IntFunctions.neg, IntFunctions.minus(size)));
    }

    public IntMatrix1D descending(int size) {
        IntMatrix1D matrix = this.make(size);
        int v = 0;
        int i = size;
        while (--i >= 0) {
            matrix.setQuick(i, v++);
        }
        return matrix;
    }

    public IntMatrix1D make(int[] values) {
        if (this == sparse) {
            return new SparseIntMatrix1D(values);
        }
        return new DenseIntMatrix1D(values);
    }

    public IntMatrix1D make(IntMatrix1D[] parts) {
        if (parts.length == 0) {
            return this.make(0);
        }
        int size = 0;
        for (int i = 0; i < parts.length; ++i) {
            size = (int)((long)size + parts[i].size());
        }
        IntMatrix1D vector = this.make(size);
        size = 0;
        for (int i = 0; i < parts.length; ++i) {
            vector.viewPart(size, (int)parts[i].size()).assign(parts[i]);
            size = (int)((long)size + parts[i].size());
        }
        return vector;
    }

    public IntMatrix1D make(int size) {
        if (this == sparse) {
            return new SparseIntMatrix1D(size);
        }
        return new DenseIntMatrix1D(size);
    }

    public IntMatrix1D make(int size, int initialValue) {
        return this.make(size).assign(initialValue);
    }

    public IntMatrix1D make(AbstractIntList values) {
        int size = values.size();
        IntMatrix1D vector = this.make(size);
        int i = size;
        while (--i >= 0) {
            vector.set(i, values.get(i));
        }
        return vector;
    }

    public IntMatrix1D random(int size) {
        return this.make(size).assign(IntFunctions.random());
    }

    public IntMatrix1D repeat(IntMatrix1D A, int repeat) {
        int size = (int)A.size();
        IntMatrix1D matrix = this.make(repeat * size);
        int i = repeat;
        while (--i >= 0) {
            matrix.viewPart(size * i, size).assign(A);
        }
        return matrix;
    }

    public IntMatrix1D sample(int size, int value, int nonZeroFraction) {
        double epsilon = 1.0E-9;
        if ((double)nonZeroFraction < 0.0 - epsilon || (double)nonZeroFraction > 1.0 + epsilon) {
            throw new IllegalArgumentException();
        }
        if (nonZeroFraction < 0) {
            nonZeroFraction = 0;
        }
        if (nonZeroFraction > 1) {
            nonZeroFraction = 1;
        }
        IntMatrix1D matrix = this.make(size);
        int n = Math.round(size * nonZeroFraction);
        if (n == 0) {
            return matrix;
        }
        DoubleRandomSamplingAssistant sampler = new DoubleRandomSamplingAssistant(n, size, new DoubleMersenneTwister());
        int i = size;
        while (--i >= 0) {
            if (!sampler.sampleNextElement()) continue;
            matrix.set(i, value);
        }
        return matrix;
    }

    public IntArrayList toList(IntMatrix1D values) {
        int size = (int)values.size();
        IntArrayList list = new IntArrayList(size);
        list.setSize(size);
        int i = size;
        while (--i >= 0) {
            list.set(i, values.get(i));
        }
        return list;
    }
}

