/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.algo.solver;

import cern.colt.matrix.Norm;
import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.algo.DenseFloatAlgebra;
import cern.colt.matrix.tfloat.algo.solver.FloatIterationMonitor;
import cern.colt.matrix.tfloat.algo.solver.FloatIterationReporter;
import cern.colt.matrix.tfloat.algo.solver.IterativeSolverFloatNotConvergedException;
import cern.colt.matrix.tfloat.algo.solver.NoFloatIterationReporter;

public abstract class AbstractFloatIterationMonitor
implements FloatIterationMonitor {
    protected int iter;
    protected Norm normType = Norm.Two;
    protected FloatIterationReporter reporter = new NoFloatIterationReporter();
    protected float residual;

    public void setFirst() {
        this.iter = 0;
    }

    public boolean isFirst() {
        return this.iter == 0;
    }

    public void next() {
        ++this.iter;
    }

    public int iterations() {
        return this.iter;
    }

    public boolean converged(FloatMatrix1D r, FloatMatrix1D x) throws IterativeSolverFloatNotConvergedException {
        return this.converged(DenseFloatAlgebra.DEFAULT.norm(r, this.normType), x);
    }

    public boolean converged(float r, FloatMatrix1D x) throws IterativeSolverFloatNotConvergedException {
        this.reporter.monitor(r, x, this.iter);
        this.residual = r;
        return this.convergedI(r, x);
    }

    public boolean converged(float r) throws IterativeSolverFloatNotConvergedException {
        this.reporter.monitor(r, this.iter);
        this.residual = r;
        return this.convergedI(r);
    }

    protected abstract boolean convergedI(float var1, FloatMatrix1D var2) throws IterativeSolverFloatNotConvergedException;

    protected abstract boolean convergedI(float var1) throws IterativeSolverFloatNotConvergedException;

    public boolean converged(FloatMatrix1D r) throws IterativeSolverFloatNotConvergedException {
        return this.converged(DenseFloatAlgebra.DEFAULT.norm(r, this.normType));
    }

    public Norm getNormType() {
        return this.normType;
    }

    public void setNormType(Norm normType) {
        this.normType = normType;
    }

    public FloatIterationReporter getIterationReporter() {
        return this.reporter;
    }

    public void setIterationReporter(FloatIterationReporter monitor) {
        this.reporter = monitor;
    }

    public float residual() {
        return this.residual;
    }
}

