/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.algo;

import cern.colt.GenericSorting;
import cern.colt.PersistentObject;
import cern.colt.Swapper;
import cern.colt.function.tint.IntComparator;
import cern.colt.list.tobject.ObjectArrayList;
import cern.colt.matrix.AbstractFormatter;
import cern.colt.matrix.tfloat.FloatFactory2D;
import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.FloatMatrix3D;
import cern.colt.matrix.tfloat.algo.DenseFloatAlgebra;
import cern.colt.matrix.tfloat.impl.DenseColumnFloatMatrix2D;
import cern.colt.matrix.tfloat.impl.DenseFloatMatrix1D;
import cern.colt.matrix.tfloat.impl.DenseFloatMatrix2D;
import cern.colt.matrix.tfloat.impl.SparseCCFloatMatrix2D;
import cern.colt.matrix.tfloat.impl.SparseFloatMatrix1D;
import cern.colt.matrix.tfloat.impl.SparseRCFloatMatrix2D;
import cern.jet.math.tfloat.FloatFunctions;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class FloatProperty
extends PersistentObject {
    private static final long serialVersionUID = 1L;
    public static final FloatProperty DEFAULT = new FloatProperty(1.0E-5f);
    public static final FloatProperty ZERO = new FloatProperty(0.0f);
    public static final FloatProperty SEVEN = new FloatProperty(1.0E-7f);
    protected float tolerance;

    private FloatProperty() {
        this(1.0E-5f);
    }

    public FloatProperty(float newTolerance) {
        this.tolerance = Math.abs(newTolerance);
    }

    protected static String blanks(int length) {
        if (length < 0) {
            length = 0;
        }
        StringBuffer buf = new StringBuffer(length);
        for (int k = 0; k < length; ++k) {
            buf.append(' ');
        }
        return buf.toString();
    }

    public void checkRectangular(FloatMatrix2D A) {
        if (A.rows() < A.columns()) {
            throw new IllegalArgumentException("Matrix must be rectangular: " + AbstractFormatter.shape(A));
        }
    }

    public void checkSquare(FloatMatrix2D A) {
        if (A.rows() != A.columns()) {
            throw new IllegalArgumentException("Matrix must be square: " + AbstractFormatter.shape(A));
        }
    }

    public void checkDense(FloatMatrix2D A) {
        if (!(A instanceof DenseFloatMatrix2D) && !(A instanceof DenseColumnFloatMatrix2D)) {
            throw new IllegalArgumentException("Matrix must be dense");
        }
    }

    public void checkDense(FloatMatrix1D A) {
        if (!(A instanceof DenseFloatMatrix1D)) {
            throw new IllegalArgumentException("Matrix must be dense");
        }
    }

    public void checkSparse(FloatMatrix1D A) {
        if (!(A instanceof SparseFloatMatrix1D)) {
            throw new IllegalArgumentException("Matrix must be sparse");
        }
    }

    public void checkSparse(FloatMatrix2D A) {
        if (!(A instanceof SparseCCFloatMatrix2D) && !(A instanceof SparseRCFloatMatrix2D)) {
            throw new IllegalArgumentException("Matrix must be sparse");
        }
    }

    public float density(FloatMatrix2D A) {
        return (float)A.cardinality() / (float)A.size();
    }

    public boolean equals(final FloatMatrix1D A, final float value) {
        if (A == null) {
            return false;
        }
        int size = (int)A.size();
        final float epsilon = this.tolerance();
        boolean result = false;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            int j;
            nthreads = Math.min(nthreads, size);
            Future[] futures = new Future[nthreads];
            Boolean[] results = new Boolean[nthreads];
            int k = size / nthreads;
            for (j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        for (int i = firstIdx; i < lastIdx; ++i) {
                            float x = A.getQuick(i);
                            float diff = Math.abs(value - x);
                            if (diff != diff && (value != value && x != x || value == x)) {
                                diff = 0.0f;
                            }
                            if (diff <= epsilon) continue;
                            return false;
                        }
                        return true;
                    }
                });
            }
            try {
                for (j = 0; j < nthreads; ++j) {
                    results[j] = (Boolean)futures[j].get();
                }
                result = results[0];
                for (j = 1; j < nthreads; ++j) {
                    result = result && results[j] != false;
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            return result;
        }
        for (int i = 0; i < size; ++i) {
            float x = A.getQuick(i);
            float diff = Math.abs(value - x);
            if (diff != diff && (value != value && x != x || value == x)) {
                diff = 0.0f;
            }
            if (diff <= epsilon) continue;
            return false;
        }
        return true;
    }

    public boolean equals(final FloatMatrix1D A, final FloatMatrix1D B) {
        if (A == B) {
            return true;
        }
        if (A == null || B == null) {
            return false;
        }
        int size = (int)A.size();
        if ((long)size != B.size()) {
            return false;
        }
        final float epsilon = this.tolerance();
        boolean result = false;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            int j;
            nthreads = Math.min(nthreads, size);
            Future[] futures = new Future[nthreads];
            Boolean[] results = new Boolean[nthreads];
            int k = size / nthreads;
            for (j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        for (int i = firstIdx; i < lastIdx; ++i) {
                            float x = A.getQuick(i);
                            float value = B.getQuick(i);
                            float diff = Math.abs(value - x);
                            if (diff != diff && (value != value && x != x || value == x)) {
                                diff = 0.0f;
                            }
                            if (diff <= epsilon) continue;
                            return false;
                        }
                        return true;
                    }
                });
            }
            try {
                for (j = 0; j < nthreads; ++j) {
                    results[j] = (Boolean)futures[j].get();
                }
                result = results[0];
                for (j = 1; j < nthreads; ++j) {
                    result = result && results[j] != false;
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            return result;
        }
        for (int i = 0; i < size; ++i) {
            float x = A.getQuick(i);
            float value = B.getQuick(i);
            float diff = Math.abs(value - x);
            if (diff != diff && (value != value && x != x || value == x)) {
                diff = 0.0f;
            }
            if (diff <= epsilon) continue;
            return false;
        }
        return true;
    }

    public boolean equals(final FloatMatrix2D A, final float value) {
        if (A == null) {
            return false;
        }
        int rows = A.rows();
        final int columns = A.columns();
        boolean result = false;
        final float epsilon = this.tolerance();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && A.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            int j;
            nthreads = Math.min(nthreads, A.rows());
            Future[] futures = new Future[nthreads];
            Boolean[] results = new Boolean[nthreads];
            int k = A.rows() / nthreads;
            for (j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? A.rows() : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        for (int r = firstRow; r < lastRow; ++r) {
                            for (int c = 0; c < columns; ++c) {
                                float x = A.getQuick(r, c);
                                float diff = Math.abs(value - x);
                                if (diff != diff && (value != value && x != x || value == x)) {
                                    diff = 0.0f;
                                }
                                if (diff <= epsilon) continue;
                                return false;
                            }
                        }
                        return true;
                    }
                });
            }
            try {
                for (j = 0; j < nthreads; ++j) {
                    results[j] = (Boolean)futures[j].get();
                }
                result = results[0];
                for (j = 1; j < nthreads; ++j) {
                    result = result && results[j] != false;
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            return result;
        }
        for (int r = 0; r < rows; ++r) {
            for (int c = 0; c < columns; ++c) {
                float x = A.getQuick(r, c);
                float diff = Math.abs(value - x);
                if (diff != diff && (value != value && x != x || value == x)) {
                    diff = 0.0f;
                }
                if (diff <= epsilon) continue;
                return false;
            }
        }
        return true;
    }

    public boolean equals(final FloatMatrix2D A, final FloatMatrix2D B) {
        if (A == B) {
            return true;
        }
        if (A == null || B == null) {
            return false;
        }
        int rows = A.rows();
        final int columns = A.columns();
        if (columns != B.columns() || rows != B.rows()) {
            return false;
        }
        boolean result = false;
        final float epsilon = this.tolerance();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && A.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            int j;
            nthreads = Math.min(nthreads, A.rows());
            Future[] futures = new Future[nthreads];
            Boolean[] results = new Boolean[nthreads];
            int k = A.rows() / nthreads;
            for (j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? A.rows() : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        for (int r = firstRow; r < lastRow; ++r) {
                            for (int c = 0; c < columns; ++c) {
                                float x = A.getQuick(r, c);
                                float value = B.getQuick(r, c);
                                float diff = Math.abs(value - x);
                                if (diff != diff && (value != value && x != x || value == x)) {
                                    diff = 0.0f;
                                }
                                if (diff <= epsilon) continue;
                                return false;
                            }
                        }
                        return true;
                    }
                });
            }
            try {
                for (j = 0; j < nthreads; ++j) {
                    results[j] = (Boolean)futures[j].get();
                }
                result = results[0];
                for (j = 1; j < nthreads; ++j) {
                    result = result && results[j] != false;
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            return result;
        }
        for (int r = 0; r < rows; ++r) {
            for (int c = 0; c < columns; ++c) {
                float x = A.getQuick(r, c);
                float value = B.getQuick(r, c);
                float diff = Math.abs(value - x);
                if (diff != diff && (value != value && x != x || value == x)) {
                    diff = 0.0f;
                }
                if (diff <= epsilon) continue;
                return false;
            }
        }
        return true;
    }

    public boolean equals(final FloatMatrix3D A, final float value) {
        if (A == null) {
            return false;
        }
        int slices = A.slices();
        final int rows = A.rows();
        final int columns = A.columns();
        boolean result = false;
        final float epsilon = this.tolerance();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && A.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            int j;
            nthreads = Math.min(nthreads, slices);
            Future[] futures = new Future[nthreads];
            Boolean[] results = new Boolean[nthreads];
            int k = slices / nthreads;
            for (j = 0; j < nthreads; ++j) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            for (int r = 0; r < rows; ++r) {
                                for (int c = 0; c < columns; ++c) {
                                    float x = A.getQuick(s, r, c);
                                    float diff = Math.abs(value - x);
                                    if (diff != diff && (value != value && x != x || value == x)) {
                                        diff = 0.0f;
                                    }
                                    if (diff <= epsilon) continue;
                                    return false;
                                }
                            }
                        }
                        return true;
                    }
                });
            }
            try {
                for (j = 0; j < nthreads; ++j) {
                    results[j] = (Boolean)futures[j].get();
                }
                result = results[0];
                for (j = 1; j < nthreads; ++j) {
                    result = result && results[j] != false;
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            return result;
        }
        for (int s = 0; s < slices; ++s) {
            for (int r = 0; r < rows; ++r) {
                for (int c = 0; c < columns; ++c) {
                    float x = A.getQuick(s, r, c);
                    float diff = Math.abs(value - x);
                    if (diff != diff && (value != value && x != x || value == x)) {
                        diff = 0.0f;
                    }
                    if (diff <= epsilon) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public boolean equals(final FloatMatrix3D A, final FloatMatrix3D B) {
        if (A == B) {
            return true;
        }
        if (A == null || B == null) {
            return false;
        }
        int slices = A.slices();
        final int rows = A.rows();
        final int columns = A.columns();
        if (columns != B.columns() || rows != B.rows() || slices != B.slices()) {
            return false;
        }
        boolean result = false;
        final float epsilon = this.tolerance();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && A.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            int j;
            nthreads = Math.min(nthreads, slices);
            Future[] futures = new Future[nthreads];
            Boolean[] results = new Boolean[nthreads];
            int k = slices / nthreads;
            for (j = 0; j < nthreads; ++j) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            for (int r = 0; r < rows; ++r) {
                                for (int c = 0; c < columns; ++c) {
                                    float x = A.getQuick(s, r, c);
                                    float value = B.getQuick(s, r, c);
                                    float diff = Math.abs(value - x);
                                    if (diff != diff && (value != value && x != x || value == x)) {
                                        diff = 0.0f;
                                    }
                                    if (diff <= epsilon) continue;
                                    return false;
                                }
                            }
                        }
                        return true;
                    }
                });
            }
            try {
                for (j = 0; j < nthreads; ++j) {
                    results[j] = (Boolean)futures[j].get();
                }
                result = results[0];
                for (j = 1; j < nthreads; ++j) {
                    result = result && results[j] != false;
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            return result;
        }
        for (int s = 0; s < slices; ++s) {
            for (int r = 0; r < rows; ++r) {
                for (int c = 0; c < columns; ++c) {
                    float x = A.getQuick(s, r, c);
                    float value = B.getQuick(s, r, c);
                    float diff = Math.abs(value - x);
                    if (diff != diff && (value != value && x != x || value == x)) {
                        diff = 0.0f;
                    }
                    if (diff <= epsilon) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public void generateNonSingular(FloatMatrix2D A) {
        int min;
        this.checkSquare(A);
        FloatFunctions F = FloatFunctions.functions;
        int i = min = Math.min(A.rows(), A.columns());
        while (--i >= 0) {
            A.setQuick(i, i, 0.0f);
        }
        i = min;
        while (--i >= 0) {
            float rowSum = A.viewRow(i).aggregate(FloatFunctions.plus, FloatFunctions.abs);
            float colSum = A.viewColumn(i).aggregate(FloatFunctions.plus, FloatFunctions.abs);
            A.setQuick(i, i, Math.max(rowSum, colSum) + (float)i + 1.0f);
        }
    }

    protected static String get(ObjectArrayList list, int index) {
        return (String)list.get(index);
    }

    public boolean isDiagonal(FloatMatrix2D A) {
        float epsilon = this.tolerance();
        int rows = A.rows();
        int columns = A.columns();
        int row = rows;
        while (--row >= 0) {
            int column = columns;
            while (--column >= 0) {
                if (row == column || Math.abs(A.getQuick(row, column)) <= epsilon) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isDiagonallyDominantByColumn(FloatMatrix2D A) {
        int min;
        FloatFunctions F = FloatFunctions.functions;
        int i = min = Math.min(A.rows(), A.columns());
        while (--i >= 0) {
            float diag = Math.abs(A.getQuick(i, i));
            if (!((diag += diag) <= A.viewColumn(i).aggregate(FloatFunctions.plus, FloatFunctions.abs))) continue;
            return false;
        }
        return true;
    }

    public boolean isDiagonallyDominantByRow(FloatMatrix2D A) {
        int min;
        FloatFunctions F = FloatFunctions.functions;
        int i = min = Math.min(A.rows(), A.columns());
        while (--i >= 0) {
            float diag = Math.abs(A.getQuick(i, i));
            if (!((diag += diag) <= A.viewRow(i).aggregate(FloatFunctions.plus, FloatFunctions.abs))) continue;
            return false;
        }
        return true;
    }

    public boolean isIdentity(FloatMatrix2D A) {
        float epsilon = this.tolerance();
        int rows = A.rows();
        int columns = A.columns();
        int row = rows;
        while (--row >= 0) {
            int column = columns;
            while (--column >= 0) {
                float v = A.getQuick(row, column);
                if (!(row == column ? !(Math.abs(1.0f - v) < epsilon) : !(Math.abs(v) <= epsilon))) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isLowerBidiagonal(FloatMatrix2D A) {
        float epsilon = this.tolerance();
        int rows = A.rows();
        int columns = A.columns();
        int row = rows;
        while (--row >= 0) {
            int column = columns;
            while (--column >= 0) {
                if (row == column || row == column + 1 || Math.abs(A.getQuick(row, column)) <= epsilon) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isLowerTriangular(FloatMatrix2D A) {
        int columns;
        float epsilon = this.tolerance();
        int rows = A.rows();
        int column = columns = A.columns();
        while (--column >= 0) {
            int row = Math.min(column, rows);
            while (--row >= 0) {
                if (Math.abs(A.getQuick(row, column)) <= epsilon) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isNonNegative(FloatMatrix2D A) {
        int rows = A.rows();
        int columns = A.columns();
        int row = rows;
        while (--row >= 0) {
            int column = columns;
            while (--column >= 0) {
                if (A.getQuick(row, column) >= 0.0f) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isOrthogonal(FloatMatrix2D A) {
        this.checkSquare(A);
        return this.equals(A.zMult(A, null, 1.0f, 0.0f, false, true), FloatFactory2D.dense.identity(A.rows()));
    }

    public boolean isPositive(FloatMatrix2D A) {
        int rows = A.rows();
        int columns = A.columns();
        int row = rows;
        while (--row >= 0) {
            int column = columns;
            while (--column >= 0) {
                if (A.getQuick(row, column) > 0.0f) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isSingular(FloatMatrix2D A) {
        return !(Math.abs(DenseFloatAlgebra.DEFAULT.det(A)) >= this.tolerance());
    }

    public boolean isSkewSymmetric(FloatMatrix2D A) {
        int rows;
        this.checkSquare(A);
        float epsilon = this.tolerance();
        int row = rows = A.rows();
        while (--row >= 0) {
            int column = rows;
            while (--column >= 0) {
                if (Math.abs(A.getQuick(row, column) + A.getQuick(column, row)) <= epsilon) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isSquare(FloatMatrix2D A) {
        return A.rows() == A.columns();
    }

    public boolean isStrictlyLowerTriangular(FloatMatrix2D A) {
        int columns;
        float epsilon = this.tolerance();
        int rows = A.rows();
        int column = columns = A.columns();
        while (--column >= 0) {
            int row = Math.min(rows, column + 1);
            while (--row >= 0) {
                if (Math.abs(A.getQuick(row, column)) <= epsilon) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isStrictlyTriangular(FloatMatrix2D A) {
        if (!this.isTriangular(A)) {
            return false;
        }
        float epsilon = this.tolerance();
        int i = Math.min(A.rows(), A.columns());
        while (--i >= 0) {
            if (Math.abs(A.getQuick(i, i)) <= epsilon) continue;
            return false;
        }
        return true;
    }

    public boolean isStrictlyUpperTriangular(FloatMatrix2D A) {
        int columns;
        float epsilon = this.tolerance();
        int rows = A.rows();
        int column = columns = A.columns();
        while (--column >= 0) {
            int row = rows;
            while (--row >= column) {
                if (Math.abs(A.getQuick(row, column)) <= epsilon) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isSymmetric(FloatMatrix2D A) {
        this.checkSquare(A);
        return this.equals(A, A.viewDice());
    }

    public boolean isTriangular(FloatMatrix2D A) {
        return this.isLowerTriangular(A) || this.isUpperTriangular(A);
    }

    public boolean isTridiagonal(FloatMatrix2D A) {
        float epsilon = this.tolerance();
        int rows = A.rows();
        int columns = A.columns();
        int row = rows;
        while (--row >= 0) {
            int column = columns;
            while (--column >= 0) {
                if (Math.abs(row - column) <= 1 || Math.abs(A.getQuick(row, column)) <= epsilon) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isUnitTriangular(FloatMatrix2D A) {
        if (!this.isTriangular(A)) {
            return false;
        }
        float epsilon = this.tolerance();
        int i = Math.min(A.rows(), A.columns());
        while (--i >= 0) {
            if (Math.abs(1.0f - A.getQuick(i, i)) <= epsilon) continue;
            return false;
        }
        return true;
    }

    public boolean isUpperBidiagonal(FloatMatrix2D A) {
        float epsilon = this.tolerance();
        int rows = A.rows();
        int columns = A.columns();
        int row = rows;
        while (--row >= 0) {
            int column = columns;
            while (--column >= 0) {
                if (row == column || row == column - 1 || Math.abs(A.getQuick(row, column)) <= epsilon) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isUpperTriangular(FloatMatrix2D A) {
        int columns;
        float epsilon = this.tolerance();
        int rows = A.rows();
        int column = columns = A.columns();
        while (--column >= 0) {
            int row = rows;
            while (--row > column) {
                if (Math.abs(A.getQuick(row, column)) <= epsilon) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isZero(FloatMatrix2D A) {
        return this.equals(A, 0.0f);
    }

    public int lowerBandwidth(FloatMatrix2D A) {
        int rows;
        this.checkSquare(A);
        float epsilon = this.tolerance();
        int k = rows = A.rows();
        while (--k >= 0) {
            int i = rows - k;
            while (--i >= 0) {
                int j = i + k;
                if (Math.abs(A.getQuick(j, i)) <= epsilon) continue;
                return k;
            }
        }
        return 0;
    }

    public int semiBandwidth(FloatMatrix2D A) {
        int rows;
        this.checkSquare(A);
        float epsilon = this.tolerance();
        int k = rows = A.rows();
        while (--k >= 0) {
            int i = rows - k;
            while (--i >= 0) {
                int j = i + k;
                if (!(Math.abs(A.getQuick(j, i)) <= epsilon)) {
                    return k + 1;
                }
                if (Math.abs(A.getQuick(i, j)) <= epsilon) continue;
                return k + 1;
            }
        }
        return 1;
    }

    public void setTolerance(float newTolerance) {
        if (this == DEFAULT || this == ZERO || this == SEVEN) {
            throw new IllegalArgumentException("Attempted to modify immutable object.");
        }
        this.tolerance = Math.abs(newTolerance);
    }

    public float tolerance() {
        return this.tolerance;
    }

    public String toString(FloatMatrix2D A) {
        final ObjectArrayList names = new ObjectArrayList();
        final ObjectArrayList values = new ObjectArrayList();
        String unknown = "Illegal operation or error: ";
        names.add("density");
        try {
            values.add(String.valueOf(this.density(A)));
        }
        catch (IllegalArgumentException exc) {
            values.add(unknown + exc.getMessage());
        }
        names.add("isDiagonal");
        try {
            values.add(String.valueOf(this.isDiagonal(A)));
        }
        catch (IllegalArgumentException exc) {
            values.add(unknown + exc.getMessage());
        }
        names.add("isDiagonallyDominantByRow");
        try {
            values.add(String.valueOf(this.isDiagonallyDominantByRow(A)));
        }
        catch (IllegalArgumentException exc) {
            values.add(unknown + exc.getMessage());
        }
        names.add("isDiagonallyDominantByColumn");
        try {
            values.add(String.valueOf(this.isDiagonallyDominantByColumn(A)));
        }
        catch (IllegalArgumentException exc) {
            values.add(unknown + exc.getMessage());
        }
        names.add("isIdentity");
        try {
            values.add(String.valueOf(this.isIdentity(A)));
        }
        catch (IllegalArgumentException exc) {
            values.add(unknown + exc.getMessage());
        }
        names.add("isLowerBidiagonal");
        try {
            values.add(String.valueOf(this.isLowerBidiagonal(A)));
        }
        catch (IllegalArgumentException exc) {
            values.add(unknown + exc.getMessage());
        }
        names.add("isLowerTriangular");
        try {
            values.add(String.valueOf(this.isLowerTriangular(A)));
        }
        catch (IllegalArgumentException exc) {
            values.add(unknown + exc.getMessage());
        }
        names.add("isNonNegative");
        try {
            values.add(String.valueOf(this.isNonNegative(A)));
        }
        catch (IllegalArgumentException exc) {
            values.add(unknown + exc.getMessage());
        }
        names.add("isOrthogonal");
        try {
            values.add(String.valueOf(this.isOrthogonal(A)));
        }
        catch (IllegalArgumentException exc) {
            values.add(unknown + exc.getMessage());
        }
        names.add("isPositive");
        try {
            values.add(String.valueOf(this.isPositive(A)));
        }
        catch (IllegalArgumentException exc) {
            values.add(unknown + exc.getMessage());
        }
        names.add("isSingular");
        try {
            values.add(String.valueOf(this.isSingular(A)));
        }
        catch (IllegalArgumentException exc) {
            values.add(unknown + exc.getMessage());
        }
        names.add("isSkewSymmetric");
        try {
            values.add(String.valueOf(this.isSkewSymmetric(A)));
        }
        catch (IllegalArgumentException exc) {
            values.add(unknown + exc.getMessage());
        }
        names.add("isSquare");
        try {
            values.add(String.valueOf(this.isSquare(A)));
        }
        catch (IllegalArgumentException exc) {
            values.add(unknown + exc.getMessage());
        }
        names.add("isStrictlyLowerTriangular");
        try {
            values.add(String.valueOf(this.isStrictlyLowerTriangular(A)));
        }
        catch (IllegalArgumentException exc) {
            values.add(unknown + exc.getMessage());
        }
        names.add("isStrictlyTriangular");
        try {
            values.add(String.valueOf(this.isStrictlyTriangular(A)));
        }
        catch (IllegalArgumentException exc) {
            values.add(unknown + exc.getMessage());
        }
        names.add("isStrictlyUpperTriangular");
        try {
            values.add(String.valueOf(this.isStrictlyUpperTriangular(A)));
        }
        catch (IllegalArgumentException exc) {
            values.add(unknown + exc.getMessage());
        }
        names.add("isSymmetric");
        try {
            values.add(String.valueOf(this.isSymmetric(A)));
        }
        catch (IllegalArgumentException exc) {
            values.add(unknown + exc.getMessage());
        }
        names.add("isTriangular");
        try {
            values.add(String.valueOf(this.isTriangular(A)));
        }
        catch (IllegalArgumentException exc) {
            values.add(unknown + exc.getMessage());
        }
        names.add("isTridiagonal");
        try {
            values.add(String.valueOf(this.isTridiagonal(A)));
        }
        catch (IllegalArgumentException exc) {
            values.add(unknown + exc.getMessage());
        }
        names.add("isUnitTriangular");
        try {
            values.add(String.valueOf(this.isUnitTriangular(A)));
        }
        catch (IllegalArgumentException exc) {
            values.add(unknown + exc.getMessage());
        }
        names.add("isUpperBidiagonal");
        try {
            values.add(String.valueOf(this.isUpperBidiagonal(A)));
        }
        catch (IllegalArgumentException exc) {
            values.add(unknown + exc.getMessage());
        }
        names.add("isUpperTriangular");
        try {
            values.add(String.valueOf(this.isUpperTriangular(A)));
        }
        catch (IllegalArgumentException exc) {
            values.add(unknown + exc.getMessage());
        }
        names.add("isZero");
        try {
            values.add(String.valueOf(this.isZero(A)));
        }
        catch (IllegalArgumentException exc) {
            values.add(unknown + exc.getMessage());
        }
        names.add("lowerBandwidth");
        try {
            values.add(String.valueOf(this.lowerBandwidth(A)));
        }
        catch (IllegalArgumentException exc) {
            values.add(unknown + exc.getMessage());
        }
        names.add("semiBandwidth");
        try {
            values.add(String.valueOf(this.semiBandwidth(A)));
        }
        catch (IllegalArgumentException exc) {
            values.add(unknown + exc.getMessage());
        }
        names.add("upperBandwidth");
        try {
            values.add(String.valueOf(this.upperBandwidth(A)));
        }
        catch (IllegalArgumentException exc) {
            values.add(unknown + exc.getMessage());
        }
        IntComparator comp = new IntComparator(){

            public int compare(int a, int b) {
                return FloatProperty.get(names, a).compareTo(FloatProperty.get(names, b));
            }
        };
        Swapper swapper = new Swapper(){

            public void swap(int a, int b) {
                Object tmp = names.get(a);
                names.set(a, names.get(b));
                names.set(b, tmp);
                tmp = values.get(a);
                values.set(a, values.get(b));
                values.set(b, tmp);
            }
        };
        GenericSorting.quickSort(0, names.size(), comp, swapper);
        int maxLength = 0;
        for (int i = 0; i < names.size(); ++i) {
            int length = ((String)names.get(i)).length();
            maxLength = Math.max(length, maxLength);
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < names.size(); ++i) {
            String name = (String)names.get(i);
            buf.append(name);
            buf.append(FloatProperty.blanks(maxLength - name.length()));
            buf.append(" : ");
            buf.append(values.get(i));
            if (i >= names.size() - 1) continue;
            buf.append('\n');
        }
        return buf.toString();
    }

    public int upperBandwidth(FloatMatrix2D A) {
        int rows;
        this.checkSquare(A);
        float epsilon = this.tolerance();
        int k = rows = A.rows();
        while (--k >= 0) {
            int i = rows - k;
            while (--i >= 0) {
                int j = i + k;
                if (Math.abs(A.getQuick(i, j)) <= epsilon) continue;
                return k;
            }
        }
        return 0;
    }
}

