/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfcomplex.impl;

import cern.colt.matrix.tfcomplex.FComplexMatrix1D;
import cern.colt.matrix.tfcomplex.FComplexMatrix2D;
import cern.colt.matrix.tfcomplex.FComplexMatrix3D;
import cern.colt.matrix.tfcomplex.impl.DenseFComplexMatrix1D;
import cern.colt.matrix.tfcomplex.impl.WrapperFComplexMatrix2D;
import cern.colt.matrix.tfloat.FloatMatrix2D;

class DelegateFComplexMatrix2D
extends FComplexMatrix2D {
    private static final long serialVersionUID = 1L;
    protected FComplexMatrix3D content;
    protected int index;
    protected int axis;

    public DelegateFComplexMatrix2D(FComplexMatrix3D newContent, int axis, int index) {
        switch (axis) {
            case 0: {
                if (index < 0 || index >= newContent.slices()) {
                    throw new IllegalArgumentException();
                }
                this.setUp(newContent.rows(), newContent.columns());
                break;
            }
            case 1: {
                if (index < 0 || index >= newContent.rows()) {
                    throw new IllegalArgumentException();
                }
                this.setUp(newContent.slices(), newContent.columns());
                break;
            }
            case 2: {
                if (index < 0 || index >= newContent.columns()) {
                    throw new IllegalArgumentException();
                }
                this.setUp(newContent.slices(), newContent.rows());
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.axis = axis;
        this.index = index;
        this.content = newContent;
    }

    public synchronized float[] getQuick(int row, int column) {
        switch (this.axis) {
            case 0: {
                return this.content.getQuick(this.index, row, column);
            }
            case 1: {
                return this.content.getQuick(row, this.index, column);
            }
            case 2: {
                return this.content.getQuick(row, column, this.index);
            }
        }
        throw new IllegalArgumentException();
    }

    public FComplexMatrix2D like(int rows, int columns) {
        return this.content.like2D(rows, columns);
    }

    public synchronized void setQuick(int row, int column, float[] value) {
        switch (this.axis) {
            case 0: {
                this.content.setQuick(this.index, row, column, value);
                break;
            }
            case 1: {
                this.content.setQuick(row, this.index, column, value);
                break;
            }
            case 2: {
                this.content.setQuick(row, column, this.index, value);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public synchronized void setQuick(int row, int column, float re, float im) {
        switch (this.axis) {
            case 0: {
                this.content.setQuick(this.index, row, column, re, im);
                break;
            }
            case 1: {
                this.content.setQuick(row, this.index, column, re, im);
                break;
            }
            case 2: {
                this.content.setQuick(row, column, this.index, re, im);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public FComplexMatrix1D viewColumn(int column) {
        this.checkColumn(column);
        return new WrapperFComplexMatrix2D(this).viewColumn(column);
    }

    public Object elements() {
        return this.content.elements();
    }

    protected FComplexMatrix2D viewSelectionLike(int[] rowOffsets, int[] columnOffsets) {
        throw new IllegalArgumentException("This method is not supported.");
    }

    public FComplexMatrix1D like1D(int size) {
        throw new IllegalArgumentException("This method is not supported.");
    }

    protected FComplexMatrix1D like1D(int size, int zero, int stride) {
        throw new IllegalArgumentException("This method is not supported.");
    }

    public FComplexMatrix1D vectorize() {
        DenseFComplexMatrix1D v = new DenseFComplexMatrix1D(this.rows * this.columns);
        int idx = 0;
        for (int c = 0; c < this.columns; ++c) {
            for (int r = 0; r < this.rows; ++r) {
                ((FComplexMatrix1D)v).setQuick(idx++, this.getQuick(r, c));
            }
        }
        return v;
    }

    public FloatMatrix2D getImaginaryPart() {
        switch (this.axis) {
            case 0: {
                return this.content.viewSlice(this.index).getImaginaryPart();
            }
            case 1: {
                return this.content.viewRow(this.index).getImaginaryPart();
            }
            case 2: {
                return this.content.viewColumn(this.index).getImaginaryPart();
            }
        }
        throw new IllegalArgumentException();
    }

    public FloatMatrix2D getRealPart() {
        switch (this.axis) {
            case 0: {
                return this.content.viewSlice(this.index).getRealPart();
            }
            case 1: {
                return this.content.viewRow(this.index).getRealPart();
            }
            case 2: {
                return this.content.viewColumn(this.index).getRealPart();
            }
        }
        throw new IllegalArgumentException();
    }
}

